/*
 * Decompiled with CFR 0.152.
 */
package com.otter_in_a_suit.MC.ChunkAnalyzerMod.Blocks;

import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Blocks.ChunkAnalyzer;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Blocks.IScanner;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Blocks.MarkerTorch;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Blocks.TileEntities.TileEntityBaseScanner;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.ChunkAnalyzerMod;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.CreativeInv;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Helper.PlayerHelper;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Helper.TileEntityHelper;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Helper.Vertex;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Helper.WorldHelper;
import com.otter_in_a_suit.MC.ChunkAnalyzerMod.Randomizer;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.input.Keyboard;

public abstract class BaseScanner
extends BlockContainer
implements IScanner {
    protected int quantityDropped = 0;
    private int explosion_threshold = 50;
    private static Randomizer _randomizer = new Randomizer();

    public BaseScanner() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("BaseScanner");
        this.func_149658_d("chunkanalyzermod:IronScanner");
        this.func_149647_a(CreativeInv._instance);
    }

    public boolean func_149727_a(World world, int p_149727_2_, int p_149727_3_, int p_149727_4_, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (world.field_72995_K) {
            return false;
        }
        int x = p_149727_2_;
        int y = p_149727_3_;
        int z = p_149727_4_;
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ChunkAnalyzerMod._instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            return true;
        }
        Block searchFor = Blocks.field_150366_p;
        try {
            TileEntityBaseScanner tile = TileEntityHelper.getTileEntityBaseScannerFromCoords(world, x, y, z);
            if (tile != null) {
                searchFor = tile.getStoredBlock();
                if (searchFor == null || searchFor == Blocks.field_150350_a) {
                    WorldHelper.chat("Couldn't read or store a (stored) block!");
                    return false;
                }
                System.out.println("Search for: " + searchFor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.search(world, player, x, y, z, searchFor, this, true, false);
        return false;
    }

    protected ArrayList<Vertex> scan(World p_149727_1_, EntityPlayer player, int x, int y, int z, BaseScanner caller) {
        return this.search(p_149727_1_, player, x, y, z, null, caller, false, false);
    }

    protected void resetChunkFromMarkers(World p_149727_1_, EntityPlayer player, int x, int y, int z) {
        System.out.println("resetChunkFromMarkers");
        this.search(p_149727_1_, player, x, y, z, null, this, false, true);
    }

    protected ArrayList<Vertex> search(World world, EntityPlayer player, int x, int y, int z, Block searchFor, BaseScanner caller, boolean placeMarkers, boolean resetOnly) {
        int c;
        boolean debugPlacer = false;
        if (searchFor == null || caller instanceof ChunkAnalyzer) {
            placeMarkers = false;
        }
        System.out.println("click from " + caller);
        int x_mod = x % 16;
        int x1_border = x;
        for (c = 0; x_mod != 0 && c <= 16; ++c) {
            x_mod = ++x1_border % 16;
            if (!debugPlacer) continue;
            world.func_147449_b(x1_border, y, z, (Block)new MarkerTorch());
        }
        int z_mod = z % 16;
        int z1_border = z;
        for (c = 0; z_mod != 0 && c <= 16; ++c) {
            z_mod = ++z1_border % 16;
            if (!debugPlacer) continue;
            world.func_147449_b(x1_border, y, z1_border, (Block)new MarkerTorch());
        }
        int z2_border = z1_border - 16;
        int x2_border = x1_border - 16;
        if (debugPlacer) {
            world.func_147449_b(x1_border, y, z2_border, Blocks.field_150451_bX);
            world.func_147449_b(x2_border, y, z1_border, Blocks.field_150451_bX);
            world.func_147449_b(x2_border, y, z2_border, Blocks.field_150451_bX);
            world.func_147449_b(x1_border, y, z1_border, Blocks.field_150451_bX);
        }
        int count = 0;
        int accountableCount = 0;
        boolean kBlocked = true;
        ArrayList<Vertex> findings = new ArrayList<Vertex>();
        ArrayList<Vertex> torchPositions = new ArrayList<Vertex>();
        Chunk chunk = world.func_72938_d(x, z);
        int chunkX = chunk.field_76635_g * 16;
        int chunkZ = chunk.field_76647_h * 16;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                kBlocked = false;
                for (int k = 0; k < 256; ++k) {
                    Block block = world.func_147439_a(chunkX + i, k, chunkZ + j);
                    if (block != Blocks.field_150350_a) {
                        // empty if block
                    }
                    if (block == ChunkAnalyzerMod.markerTorch) {
                        torchPositions.add(new Vertex(chunkX + i, k, chunkZ + j, block));
                    }
                    if (resetOnly) continue;
                    if (searchFor == null) {
                        findings.add(new Vertex(chunkX + i, k, chunkZ + j, block));
                        continue;
                    }
                    if (block != searchFor) continue;
                    findings.add(new Vertex(chunkX + i, k, chunkZ + j, block));
                    ++count;
                    if (kBlocked) continue;
                    ++accountableCount;
                    kBlocked = true;
                }
            }
        }
        boolean sufficientLevels = false;
        if (ChunkAnalyzerMod.useXPForScanner && !player.field_71075_bZ.field_75098_d) {
            boolean bl = sufficientLevels = player.field_71067_cb >= count * this.getXPConsumtion();
            if (sufficientLevels) {
                player.func_71023_q(-1 * (count * this.getXPConsumtion()));
            } else {
                WorldHelper.chat("Insufficient XP for scan! You need at least " + (count * this.getXPConsumtion() - player.field_71067_cb) + " more!");
            }
        }
        sufficientLevels = player.field_71075_bZ.field_75098_d ? true : sufficientLevels;
        System.out.println("Torches: " + torchPositions.size() + " w " + resetOnly);
        if (resetOnly || placeMarkers || ChunkAnalyzerMod.useXPForScanner && !sufficientLevels) {
            for (Vertex v : torchPositions) {
                world.func_147468_f(v.x, v.y, v.z);
            }
        }
        if (placeMarkers && sufficientLevels) {
            this.renderMarkerAndSendMSG(findings, world, player, x, y, z, searchFor, caller, count, accountableCount);
        }
        return findings;
    }

    protected void renderMarkerAndSendMSG(ArrayList<Vertex> findings, World p_149727_1_, EntityPlayer player, int x, int y, int z, Block searchFor, BaseScanner caller, int count, int accountableCount) {
        int markerTorchCount;
        boolean playerNeedsTorches = false;
        String msg = "";
        boolean renderTorches = false;
        boolean renderOne = false;
        Item marker = Item.func_150898_a((Block)ChunkAnalyzerMod.markerTorch);
        int n = markerTorchCount = playerNeedsTorches ? PlayerHelper.InventoryContainsItem_i(player, marker) : findings.size() + 1;
        if (!findings.isEmpty()) {
            if (caller.getLevel() != 0) {
                if (caller.getLevel() == 3) {
                    msg = "Found at least one " + searchFor.func_149739_a().substring(5) + "!";
                    renderOne = true;
                } else if (caller.getLevel() == 2 || caller.getLevel() == 1) {
                    msg = "Found " + count + " " + searchFor.func_149739_a().substring(5) + "!";
                    renderTorches = true;
                }
            }
            int ySky = y;
            if (renderTorches) {
                for (int cc = 0; cc < markerTorchCount && cc < findings.size(); ++cc) {
                    Vertex v = findings.get(cc);
                    ySky = WorldHelper.getGroundLevelYAxsis_i(p_149727_1_, v.z, y, v.z);
                    if (p_149727_1_.func_147439_a(v.x, ySky, v.z) == ChunkAnalyzerMod.markerTorch || p_149727_1_.func_147439_a(v.x, ySky, v.z) == this) continue;
                    p_149727_1_.func_72838_d((Entity)new EntityItem(p_149727_1_, (double)x, (double)y, (double)z, new ItemStack(p_149727_1_.func_147439_a(v.x, ySky, v.z))));
                    p_149727_1_.func_147449_b(v.x, ySky, v.z, (Block)ChunkAnalyzerMod.markerTorch);
                    if (player.field_71075_bZ.field_75098_d || !playerNeedsTorches) continue;
                    player.field_71071_by.func_146026_a(marker);
                }
            } else if (renderOne && markerTorchCount >= 1) {
                Vertex v = findings.get(0);
                ySky = WorldHelper.getGroundLevelYAxsis_i(p_149727_1_, v.z, y, v.z);
                if (p_149727_1_.func_147439_a(v.x, ySky, v.z) != this) {
                    p_149727_1_.func_147449_b(v.x, ySky, v.z, (Block)ChunkAnalyzerMod.markerTorch);
                    System.out.println("Torch at " + v.x + ", " + ySky + ", " + v.z);
                }
                if (!player.field_71075_bZ.field_75098_d && playerNeedsTorches) {
                    player.field_71071_by.func_146026_a(marker);
                }
            }
            if (markerTorchCount <= 0) {
                msg = msg.replace("!", ", but you have no marker torches!");
            } else if (markerTorchCount < accountableCount) {
                msg = msg.replace("!", ", but you haven't sufficient marker torches!");
            }
        } else {
            msg = "Found none!";
        }
        WorldHelper.chat(msg);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        this.getAndSaveExplosionThreshold(world, x, y, z);
        int isExplode = _randomizer.calculateExplosionLevel(this.explosion_threshold);
        try {
            TileEntityBaseScanner tile = TileEntityHelper.getTileEntityBaseScannerFromCoords(world, x, y, z);
            ItemStack storedBlockAsItem = tile.func_70304_b(0);
            if (isExplode == 0) {
                this.triggerExplosion(world, x, y, z);
            } else if (isExplode == 1 || isExplode == 2) {
                System.out.println("no boom =(");
                this.dropBlockAsItem(world, x, y, z);
                if (storedBlockAsItem != null) {
                    EntityItem item = new EntityItem(world, (double)x, (double)y, (double)z, storedBlockAsItem);
                    world.func_72838_d((Entity)item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetChunkFromMarkers(world, player, x, y, z);
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    protected void dropBlockAsItem(World world, int x, int y, int z) {
        this.func_149642_a(world, x, y, z, null);
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        try {
            TileEntityBaseScanner tile = TileEntityHelper.getTileEntityBaseScannerFromCoords(world, x, y, z);
            String display = "";
            if (tile.getNBTTagCompound().func_74762_e("explosionThreshold") != 50) {
                display = display + "Reenforced ";
            }
            display = display + "Scanner";
            display = display + ", Target: " + tile.getStoredBlock().func_149739_a().substring(5);
            WorldHelper.dropBlockAsItemWithTileEntity(world, x, y, z, (Block)this, display);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase p_149689_5_, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        try {
            NBTTagCompound nbt = itemStack.func_77978_p();
            if (nbt != null) {
                TileEntityBaseScanner tile = new TileEntityBaseScanner();
                tile.writeToParByNBT(nbt);
                System.out.println(tile.explosionThreshold);
                world.func_147455_a(x, y, z, (TileEntity)tile);
            } else {
                System.out.println("No NBT");
            }
        }
        catch (Exception e) {
            System.out.println("NO entity dropped!");
            e.printStackTrace();
        }
    }

    public int func_149745_a(Random p_149745_1_) {
        return this.quantityDropped;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityBaseScanner();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    private int getAndSaveExplosionThreshold(World world, int x, int y, int z) {
        TileEntity genericTile = world.func_147438_o(x, y, z);
        if (genericTile != null && genericTile instanceof TileEntityBaseScanner) {
            TileEntityBaseScanner tile = (TileEntityBaseScanner)genericTile;
            this.explosion_threshold = tile.explosionThreshold;
            return this.explosion_threshold;
        }
        System.out.println("WARNING: explosionThreshold is 0!");
        return 0;
    }

    @Override
    public abstract int getLevel();

    private void triggerExplosion(World world, int x, int y, int z) {
        float strength = 2.0f;
        world.func_72876_a(null, (double)x, (double)y, (double)z, strength, true);
    }

    @Override
    public int getXPConsumtion() {
        if (this.getLevel() == 1) {
            return 0;
        }
        return (int)Math.ceil(1.0f * (float)this.getLevel() * 0.3f);
    }
}

