/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportPower
extends PipeTransport {
    private static final short MAX_DISPLAY = 100;
    private static final int DISPLAY_SMOOTHING = 10;
    private static final int OVERLOAD_TICKS = 60;
    public static final Map<Class<? extends Pipe>, Integer> powerCapacities = new HashMap<Class<? extends Pipe>, Integer>();
    private boolean needsInit = true;
    private TileEntity[] tiles = new TileEntity[6];
    public float[] displayPower = new float[6];
    private float[] prevDisplayPower = new float[6];
    public short[] clientDisplayPower = new short[6];
    public int overload;
    private int[] powerQuery = new int[6];
    public int[] nextPowerQuery = new int[6];
    private long currentDate;
    private float[] internalPower = new float[6];
    public float[] internalNextPower = new float[6];
    public int maxPower = 8;
    SafeTimeTracker tracker = new SafeTimeTracker();

    public PipeTransportPower() {
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
        }
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.POWER;
    }

    public void initFromPipe(Class<? extends Pipe> pipeClass) {
        this.maxPower = powerCapacities.get(pipeClass);
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        IPowerEmitter emitter;
        IPowerReceptor receptor;
        PowerHandler.PowerReceiver receiver;
        if (tile instanceof TileGenericPipe) {
            Pipe pipe2 = ((TileGenericPipe)tile).pipe;
            return !BlockGenericPipe.isValid(pipe2) || pipe2.transport instanceof PipeTransportPower;
        }
        if (tile instanceof IPowerReceptor && (receiver = (receptor = (IPowerReceptor)tile).getPowerReceiver(side.getOpposite())) != null && receiver.getType().canReceiveFromPipes()) {
            return true;
        }
        return this.container.pipe instanceof PipePowerWood && tile instanceof IPowerEmitter && (emitter = (IPowerEmitter)tile).canEmitPowerFrom(side.getOpposite());
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateTiles();
    }

    private void updateTiles() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.container.getTile(side);
            if (this.container.isPipeConnected(side)) {
                this.tiles[side.ordinal()] = tile;
                continue;
            }
            this.tiles[side.ordinal()] = null;
            this.internalPower[side.ordinal()] = 0.0f;
            this.internalNextPower[side.ordinal()] = 0.0f;
            this.displayPower[side.ordinal()] = 0.0f;
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            this.updateTiles();
        }
    }

    @Override
    public void updateEntity() {
        int i;
        int i2;
        PipeTransportPower nearbyTransport;
        TileGenericPipe nearbyTile;
        if (CoreProxy.proxy.isRenderWorld(this.container.field_70331_k)) {
            return;
        }
        this.step();
        this.init();
        System.arraycopy(this.displayPower, 0, this.prevDisplayPower, 0, 6);
        Arrays.fill(this.displayPower, 0.0f);
        for (int i3 = 0; i3 < 6; ++i3) {
            int j;
            if (!(this.internalPower[i3] > 0.0f)) continue;
            float totalPowerQuery = 0.0f;
            for (j = 0; j < 6; ++j) {
                if (j == i3 || this.powerQuery[j] <= 0 || !(this.tiles[j] instanceof TileGenericPipe) && !(this.tiles[j] instanceof IPowerReceptor)) continue;
                totalPowerQuery += (float)this.powerQuery[j];
            }
            for (j = 0; j < 6; ++j) {
                if (j == i3 || this.powerQuery[j] <= 0) continue;
                float watts = 0.0f;
                PowerHandler.PowerReceiver prov = this.getReceiverOnSide(ForgeDirection.VALID_DIRECTIONS[j]);
                if (prov != null && prov.powerRequest() > 0.0f) {
                    watts = this.internalPower[i3] / totalPowerQuery * (float)this.powerQuery[j];
                    watts = prov.receiveEnergy(PowerHandler.Type.PIPE, watts, ForgeDirection.VALID_DIRECTIONS[j].getOpposite());
                    int n = i3;
                    this.internalPower[n] = this.internalPower[n] - watts;
                } else if (this.tiles[j] instanceof TileGenericPipe) {
                    watts = this.internalPower[i3] / totalPowerQuery * (float)this.powerQuery[j];
                    nearbyTile = (TileGenericPipe)this.tiles[j];
                    nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
                    watts = nearbyTransport.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite(), watts);
                    int n = i3;
                    this.internalPower[n] = this.internalPower[n] - watts;
                }
                int n = j;
                this.displayPower[n] = this.displayPower[n] + watts;
                int n2 = i3;
                this.displayPower[n2] = this.displayPower[n2] + watts;
            }
        }
        double highestPower = 0.0;
        for (i2 = 0; i2 < 6; ++i2) {
            this.displayPower[i2] = (this.prevDisplayPower[i2] * 9.0f + this.displayPower[i2]) / 10.0f;
            if (!((double)this.displayPower[i2] > highestPower)) continue;
            highestPower = this.displayPower[i2];
        }
        this.overload += highestPower > (double)this.maxPower * 0.95 ? 1 : -1;
        if (this.overload < 0) {
            this.overload = 0;
        }
        if (this.overload > 60) {
            this.overload = 60;
        }
        for (i2 = 0; i2 < 6; ++i2) {
            float request;
            PowerHandler.PowerReceiver prov = this.getReceiverOnSide(ForgeDirection.VALID_DIRECTIONS[i2]);
            if (prov == null || !((request = prov.powerRequest()) > 0.0f)) continue;
            this.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i2], request);
        }
        int[] transferQuery = new int[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            TileEntity entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof TileGenericPipe)) continue;
            nearbyTile = (TileGenericPipe)entity;
            if (nearbyTile.pipe == null) continue;
            nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
            nearbyTransport.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i].getOpposite(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.container.field_70331_k, 2 * BuildCraftCore.updateFactor)) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
            double displayFactor = 0.09765625;
            for (int i4 = 0; i4 < this.clientDisplayPower.length; ++i4) {
                this.clientDisplayPower[i4] = (short)((double)this.displayPower[i4] * displayFactor + 0.9999);
            }
            packet.displayPower = this.clientDisplayPower;
            packet.overload = this.isOverloaded();
            CoreProxy.proxy.sendToPlayers(packet.getPacket(), this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
        }
    }

    private PowerHandler.PowerReceiver getReceiverOnSide(ForgeDirection side) {
        TileEntity tile = this.tiles[side.ordinal()];
        if (!(tile instanceof IPowerReceptor)) {
            return null;
        }
        IPowerReceptor receptor = (IPowerReceptor)tile;
        PowerHandler.PowerReceiver receiver = receptor.getPowerReceiver(side.getOpposite());
        if (receiver == null) {
            return null;
        }
        if (!receiver.getType().canReceiveFromPipes()) {
            return null;
        }
        return receiver;
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    private void step() {
        if (this.currentDate != this.container.field_70331_k.func_82737_E()) {
            this.currentDate = this.container.field_70331_k.func_82737_E();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[6];
            float[] next = this.internalPower;
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
        }
    }

    public float receiveEnergy(ForgeDirection from, float val) {
        float ret;
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook && (ret = ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val)) >= 0.0f) {
            return ret;
        }
        int side = from.ordinal();
        if (this.internalNextPower[side] > (float)this.maxPower) {
            return 0.0f;
        }
        int n = side;
        this.internalNextPower[n] = this.internalNextPower[n] + val;
        if (this.internalNextPower[side] > (float)this.maxPower) {
            val -= this.internalNextPower[side] - (float)this.maxPower;
            this.internalNextPower[side] = this.maxPower;
            if (val < 0.0f) {
                val = 0.0f;
            }
        }
        return val;
    }

    public void requestEnergy(ForgeDirection from, float amount) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            int n = from.ordinal();
            this.nextPowerQuery[n] = (int)((float)this.nextPowerQuery[n] + ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, amount));
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = (int)((float)this.nextPowerQuery[n] + amount);
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.container.field_70331_k.func_82737_E();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.func_74762_e("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.func_74762_e("nextPowerQuery[" + i + "]");
            this.internalPower[i] = (float)nbttagcompound.func_74769_h("internalPower[" + i + "]");
            this.internalNextPower[i] = (float)nbttagcompound.func_74769_h("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.func_74768_a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.func_74768_a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.func_74780_a("internalPower[" + i + "]", (double)this.internalPower[i]);
            nbttagcompound.func_74780_a("internalNextPower[" + i + "]", (double)this.internalNextPower[i]);
        }
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.clientDisplayPower = packetPower.displayPower;
        this.overload = packetPower.overload ? 60 : 0;
    }

    static {
        powerCapacities.put(PipePowerCobblestone.class, 8);
        powerCapacities.put(PipePowerStone.class, 16);
        powerCapacities.put(PipePowerWood.class, 32);
        powerCapacities.put(PipePowerQuartz.class, 64);
        powerCapacities.put(PipePowerIron.class, 128);
        powerCapacities.put(PipePowerGold.class, 256);
        powerCapacities.put(PipePowerDiamond.class, 1024);
    }
}

