/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.triggers.BCTrigger;
import java.util.Locale;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerInventory
extends BCTrigger {
    public State state;

    public TriggerInventory(int legacyId, State state) {
        super(legacyId, "buildcraft.inventory." + state.name().toLowerCase(Locale.ENGLISH));
        this.state = state;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Inventory Empty";
            }
            case Contains: {
                return "Items in Inventory";
            }
            case Space: {
                return "Space in Inventory";
            }
        }
        return "Inventory Full";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        ItemStack searchedStack = null;
        if (parameter != null) {
            searchedStack = parameter.getItemStack();
        }
        if (tile instanceof ISpecialInventory) {
            ISpecialInventory specialInventory = (ISpecialInventory)tile;
            switch (this.state) {
                case Contains: {
                    ItemStack[] itemStacks = specialInventory.extractItem(false, side, 1);
                    return itemStacks != null && itemStacks.length > 0 && itemStacks[0] != null && itemStacks[0].field_77994_a > 0 && (searchedStack == null || itemStacks[0].func_77969_a(searchedStack));
                }
                case Empty: {
                    ItemStack[] itemStacks = specialInventory.extractItem(false, side, 1);
                    return itemStacks == null || itemStacks.length == 0 || itemStacks[0] == null || itemStacks[0].field_77994_a == 0;
                }
                case Full: {
                    break;
                }
                case Space: {
                    if (searchedStack == null) break;
                    int added = specialInventory.addItem(searchedStack, false, side);
                    return added > 0;
                }
            }
        }
        if (tile instanceof IInventory) {
            boolean hasSlots = false;
            boolean foundItems = false;
            boolean foundSpace = false;
            for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, side)) {
                hasSlots = true;
                ItemStack stack = slot.getStackInSlot();
                foundItems |= stack != null && (searchedStack == null || StackHelper.instance().canStacksMerge(stack, searchedStack));
                foundSpace |= (stack == null || StackHelper.instance().canStacksMerge(stack, searchedStack) && stack.field_77994_a < stack.func_77976_d()) && (searchedStack == null || slot.canPutStackInSlot(searchedStack));
            }
            if (!hasSlots) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.state) {
            case Empty: {
                return 7;
            }
            case Contains: {
                return 8;
            }
            case Space: {
                return 9;
            }
        }
        return 10;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

