/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IExtractionHandler;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.BCAction;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.BCLog;
import buildcraft.core.utils.EnumColor;
import buildcraft.transport.BlockFilteredBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.GateIconProvider;
import buildcraft.transport.GuiHandler;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGate;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPlug;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.WireIconProvider;
import buildcraft.transport.blueprints.BptBlockPipe;
import buildcraft.transport.blueprints.BptItemPipeDiamond;
import buildcraft.transport.blueprints.BptItemPipeEmerald;
import buildcraft.transport.blueprints.BptItemPipeIron;
import buildcraft.transport.blueprints.BptItemPipeWooden;
import buildcraft.transport.network.PacketHandlerTransport;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDaizuli;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsLapis;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.triggers.ActionEnergyPulser;
import buildcraft.transport.triggers.ActionExtractionPreset;
import buildcraft.transport.triggers.ActionPipeColor;
import buildcraft.transport.triggers.ActionPipeDirection;
import buildcraft.transport.triggers.ActionPowerLimiter;
import buildcraft.transport.triggers.ActionSignalOutput;
import buildcraft.transport.triggers.ActionSingleEnergyPulse;
import buildcraft.transport.triggers.TriggerPipeContents;
import buildcraft.transport.triggers.TriggerPipeSignal;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.Property;

@Mod(version="4.2.2", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@4.2.2")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerTransport.class)
public class BuildCraftTransport {
    public static BlockGenericPipe genericPipeBlock;
    public static float pipeDurability;
    public static Item pipeWaterproof;
    public static Item pipeGate;
    public static Item pipeGateAutarchic;
    public static Item redPipeWire;
    public static Item bluePipeWire;
    public static Item greenPipeWire;
    public static Item yellowPipeWire;
    public static Item pipeItemsWood;
    public static Item pipeItemsEmerald;
    public static Item pipeItemsStone;
    public static Item pipeItemsCobblestone;
    public static Item pipeItemsIron;
    public static Item pipeItemsQuartz;
    public static Item pipeItemsGold;
    public static Item pipeItemsDiamond;
    public static Item pipeItemsObsidian;
    public static Item pipeItemsLapis;
    public static Item pipeItemsDaizuli;
    public static Item pipeItemsVoid;
    public static Item pipeItemsSandstone;
    public static Item pipeItemsEmzuli;
    public static Item pipeFluidsWood;
    public static Item pipeFluidsCobblestone;
    public static Item pipeFluidsStone;
    public static Item pipeFluidsIron;
    public static Item pipeFluidsGold;
    public static Item pipeFluidsVoid;
    public static Item pipeFluidsSandstone;
    public static Item pipeFluidsEmerald;
    public static Item pipePowerWood;
    public static Item pipePowerCobblestone;
    public static Item pipePowerStone;
    public static Item pipePowerQuartz;
    public static Item pipePowerIron;
    public static Item pipePowerGold;
    public static Item pipePowerDiamond;
    public static ItemFacade facadeItem;
    public static Item plugItem;
    public static BlockFilteredBuffer filteredBufferBlock;
    public static Item pipeStructureCobblestone;
    public static int groupItemsTrigger;
    public static BCTrigger triggerPipeEmpty;
    public static BCTrigger triggerPipeItems;
    public static BCTrigger triggerPipeFluids;
    public static BCTrigger triggerPipeContainsEnergy;
    public static BCTrigger triggerPipeRequestsEnergy;
    public static BCTrigger triggerPipeTooMuchEnergy;
    public static BCTrigger triggerRedSignalActive;
    public static BCTrigger triggerRedSignalInactive;
    public static BCTrigger triggerBlueSignalActive;
    public static BCTrigger triggerBlueSignalInactive;
    public static BCTrigger triggerGreenSignalActive;
    public static BCTrigger triggerGreenSignalInactive;
    public static BCTrigger triggerYellowSignalActive;
    public static BCTrigger triggerYellowSignalInactive;
    public static BCAction actionRedSignal;
    public static BCAction actionBlueSignal;
    public static BCAction actionGreenSignal;
    public static BCAction actionYellowSignal;
    public static BCAction actionEnergyPulser;
    public static BCAction actionSingleEnergyPulse;
    public static BCAction[] actionPipeColor;
    public static BCAction[] actionPipeDirection;
    public static BCAction[] actionPowerLimiter;
    public static BCAction actionExtractionPresetRed;
    public static BCAction actionExtractionPresetBlue;
    public static BCAction actionExtractionPresetGreen;
    public static BCAction actionExtractionPresetYellow;
    public IIconProvider pipeIconProvider = new PipeIconProvider();
    public IIconProvider gateIconProvider = new GateIconProvider();
    public IIconProvider wireIconProvider = new WireIconProvider();
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    private static LinkedList<PipeRecipe> pipeRecipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        try {
            Property exclusionFluidList;
            String[] excludedFluidBlocks;
            Property durability = BuildCraftCore.mainConfiguration.get("general", "pipes.durability", DefaultProps.PIPES_DURABILITY);
            durability.comment = "How long a pipe will take to break";
            pipeDurability = (float)durability.getDouble(DefaultProps.PIPES_DURABILITY);
            Property exclusionItemList = BuildCraftCore.mainConfiguration.get("block", "woodenPipe.item.exclusion", new String[0]);
            String[] excludedItemBlocks = exclusionItemList.getStringList();
            if (excludedItemBlocks != null) {
                for (int j = 0; j < excludedItemBlocks.length; ++j) {
                    excludedItemBlocks[j] = excludedItemBlocks[j].trim();
                }
            } else {
                excludedItemBlocks = new String[]{};
            }
            if ((excludedFluidBlocks = (exclusionFluidList = BuildCraftCore.mainConfiguration.get("block", "woodenPipe.liquid.exclusion", new String[0])).getStringList()) != null) {
                for (int j = 0; j < excludedFluidBlocks.length; ++j) {
                    excludedFluidBlocks[j] = excludedFluidBlocks[j].trim();
                }
            } else {
                excludedFluidBlocks = new String[]{};
            }
            PipeManager.registerExtractionHandler(new ExtractionHandler(excludedItemBlocks, excludedFluidBlocks));
            Property groupItemsTriggerProp = BuildCraftCore.mainConfiguration.get("general", "pipes.groupItemsTrigger", 32);
            groupItemsTriggerProp.comment = "when reaching this amount of objects in a pipes, items will be automatically grouped";
            groupItemsTrigger = groupItemsTriggerProp.getInt();
            Property genericPipeId = BuildCraftCore.mainConfiguration.getBlock("pipe.id", DefaultProps.GENERIC_PIPE_ID);
            Property pipeWaterproofId = BuildCraftCore.mainConfiguration.getItem("pipeWaterproof.id", DefaultProps.PIPE_WATERPROOF_ID);
            pipeWaterproof = new ItemBuildCraft(pipeWaterproofId.getInt());
            pipeWaterproof.func_77655_b("pipeWaterproof");
            LanguageRegistry.addName((Object)pipeWaterproof, (String)"Pipe Sealant");
            CoreProxy.proxy.registerItem(pipeWaterproof);
            genericPipeBlock = new BlockGenericPipe(genericPipeId.getInt());
            CoreProxy.proxy.registerBlock(genericPipeBlock.func_71864_b("pipeBlock"), ItemBlock.class);
            pipeItemsWood = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_WOOD_ID, PipeItemsWood.class, "Wooden Transport Pipe", "plankWood", Block.field_71946_M, "plankWood");
            pipeItemsEmerald = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_EMERALD_ID, PipeItemsEmerald.class, "Emerald Transport Pipe", Item.field_77817_bH, Block.field_71946_M, Item.field_77817_bH);
            pipeItemsCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_COBBLESTONE_ID, PipeItemsCobblestone.class, "Cobblestone Transport Pipe", "cobblestone", Block.field_71946_M, "cobblestone");
            pipeItemsStone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_STONE_ID, PipeItemsStone.class, "Stone Transport Pipe", "stone", Block.field_71946_M, "stone");
            pipeItemsQuartz = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_QUARTZ_ID, PipeItemsQuartz.class, "Quartz Transport Pipe", Block.field_94339_ct, Block.field_71946_M, Block.field_94339_ct);
            pipeItemsIron = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_IRON_ID, PipeItemsIron.class, "Iron Transport Pipe", Item.field_77703_o, Block.field_71946_M, Item.field_77703_o);
            pipeItemsGold = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_GOLD_ID, PipeItemsGold.class, "Golden Transport Pipe", Item.field_77717_p, Block.field_71946_M, Item.field_77717_p);
            pipeItemsDiamond = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_DIAMOND_ID, PipeItemsDiamond.class, "Diamond Transport Pipe", Item.field_77702_n, Block.field_71946_M, Item.field_77702_n);
            pipeItemsObsidian = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_OBSIDIAN_ID, PipeItemsObsidian.class, "Obsidian Transport Pipe", Block.field_72089_ap, Block.field_71946_M, Block.field_72089_ap);
            pipeItemsLapis = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_LAPIS_ID, PipeItemsLapis.class, "Lapis Transport Pipe", Block.field_71948_O, Block.field_71946_M, Block.field_71948_O);
            pipeItemsDaizuli = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_DAIZULI_ID, PipeItemsDaizuli.class, "Daizuli Transport Pipe", Block.field_71948_O, Block.field_71946_M, Item.field_77702_n);
            pipeItemsSandstone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_SANDSTONE_ID, PipeItemsSandstone.class, "Sandstone Transport Pipe", Block.field_71957_Q, Block.field_71946_M, Block.field_71957_Q);
            pipeItemsVoid = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_VOID_ID, PipeItemsVoid.class, "Void Transport Pipe", "dyeBlack", Block.field_71946_M, Item.field_77767_aC);
            pipeItemsEmzuli = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_EMZULI_ID, PipeItemsEmzuli.class, "Emzuli Transport Pipe", Block.field_71948_O, Block.field_71946_M, Item.field_77817_bH);
            pipeFluidsWood = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_WOOD_ID, PipeFluidsWood.class, "Wooden Waterproof Pipe", pipeWaterproof, pipeItemsWood);
            pipeFluidsCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_COBBLESTONE_ID, PipeFluidsCobblestone.class, "Cobblestone Waterproof Pipe", pipeWaterproof, pipeItemsCobblestone);
            pipeFluidsStone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_STONE_ID, PipeFluidsStone.class, "Stone Waterproof Pipe", pipeWaterproof, pipeItemsStone);
            pipeFluidsIron = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_IRON_ID, PipeFluidsIron.class, "Iron Waterproof Pipe", pipeWaterproof, pipeItemsIron);
            pipeFluidsGold = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_GOLD_ID, PipeFluidsGold.class, "Golden Waterproof Pipe", pipeWaterproof, pipeItemsGold);
            pipeFluidsEmerald = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_EMERALD_ID, PipeFluidsEmerald.class, "Emerald Waterproof Pipe", pipeWaterproof, pipeItemsEmerald);
            pipeFluidsSandstone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_SANDSTONE_ID, PipeFluidsSandstone.class, "Sandstone Waterproof Pipe", pipeWaterproof, pipeItemsSandstone);
            pipeFluidsVoid = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_VOID_ID, PipeFluidsVoid.class, "Void Waterproof Pipe", pipeWaterproof, pipeItemsVoid);
            pipePowerWood = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_WOOD_ID, PipePowerWood.class, "Wooden Kinesis Pipe", Item.field_77767_aC, pipeItemsWood);
            pipePowerCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_COBBLESTONE_ID, PipePowerCobblestone.class, "Cobblestone Kinesis Pipe", Item.field_77767_aC, pipeItemsCobblestone);
            pipePowerStone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_STONE_ID, PipePowerStone.class, "Stone Kinesis Pipe", Item.field_77767_aC, pipeItemsStone);
            pipePowerQuartz = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_QUARTZ_ID, PipePowerQuartz.class, "Quartz Kinesis Pipe", Item.field_77767_aC, pipeItemsQuartz);
            pipePowerIron = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_IRON_ID, PipePowerIron.class, "Iron Kinesis Pipe", Item.field_77767_aC, pipeItemsIron);
            pipePowerGold = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_GOLD_ID, PipePowerGold.class, "Golden Kinesis Pipe", Item.field_77767_aC, pipeItemsGold);
            pipePowerDiamond = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_DIAMOND_ID, PipePowerDiamond.class, "Diamond Kinesis Pipe", Item.field_77767_aC, pipeItemsDiamond);
            pipeStructureCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_STRUCTURE_COBBLESTONE_ID, PipeStructureCobblestone.class, "Cobblestone Structure Pipe", Block.field_71940_F, pipeItemsCobblestone);
            Property redPipeWireId = BuildCraftCore.mainConfiguration.get("item", "redPipeWire.id", DefaultProps.RED_PIPE_WIRE);
            redPipeWire = new ItemBuildCraft(redPipeWireId.getInt()).setPassSneakClick(true);
            redPipeWire.func_77655_b("redPipeWire");
            LanguageRegistry.addName((Object)redPipeWire, (String)"Red Pipe Wire");
            CoreProxy.proxy.registerItem(redPipeWire);
            Property bluePipeWireId = BuildCraftCore.mainConfiguration.get("item", "bluePipeWire.id", DefaultProps.BLUE_PIPE_WIRE);
            bluePipeWire = new ItemBuildCraft(bluePipeWireId.getInt()).setPassSneakClick(true);
            bluePipeWire.func_77655_b("bluePipeWire");
            LanguageRegistry.addName((Object)bluePipeWire, (String)"Blue Pipe Wire");
            CoreProxy.proxy.registerItem(bluePipeWire);
            Property greenPipeWireId = BuildCraftCore.mainConfiguration.get("item", "greenPipeWire.id", DefaultProps.GREEN_PIPE_WIRE);
            greenPipeWire = new ItemBuildCraft(greenPipeWireId.getInt()).setPassSneakClick(true);
            greenPipeWire.func_77655_b("greenPipeWire");
            LanguageRegistry.addName((Object)greenPipeWire, (String)"Green Pipe Wire");
            CoreProxy.proxy.registerItem(greenPipeWire);
            Property yellowPipeWireId = BuildCraftCore.mainConfiguration.get("item", "yellowPipeWire.id", DefaultProps.YELLOW_PIPE_WIRE);
            yellowPipeWire = new ItemBuildCraft(yellowPipeWireId.getInt()).setPassSneakClick(true);
            yellowPipeWire.func_77655_b("yellowPipeWire");
            LanguageRegistry.addName((Object)yellowPipeWire, (String)"Yellow Pipe Wire");
            CoreProxy.proxy.registerItem(yellowPipeWire);
            Property pipeGateId = BuildCraftCore.mainConfiguration.get("item", "pipeGate.id", DefaultProps.GATE_ID);
            pipeGate = new ItemGate(pipeGateId.getInt(), 0);
            pipeGate.func_77655_b("pipeGate");
            CoreProxy.proxy.registerItem(pipeGate);
            Property pipeGateAutarchicId = BuildCraftCore.mainConfiguration.get("item", "pipeGateAutarchic.id", DefaultProps.GATE_AUTARCHIC_ID);
            pipeGateAutarchic = new ItemGate(pipeGateAutarchicId.getInt(), 1);
            pipeGateAutarchic.func_77655_b("pipeGateAutarchic");
            CoreProxy.proxy.registerItem(pipeGateAutarchic);
            Property pipeFacadeId = BuildCraftCore.mainConfiguration.get("item", "pipeFacade.id", DefaultProps.PIPE_FACADE_ID);
            facadeItem = new ItemFacade(pipeFacadeId.getInt());
            facadeItem.func_77655_b("pipeFacade");
            CoreProxy.proxy.registerItem(facadeItem);
            Property pipePlugId = BuildCraftCore.mainConfiguration.get("item", "pipePlug.id", DefaultProps.PIPE_PLUG_ID);
            plugItem = new ItemPlug(pipePlugId.getInt());
            plugItem.func_77655_b("pipePlug");
            CoreProxy.proxy.registerItem(plugItem);
            Property filteredBufferId = BuildCraftCore.mainConfiguration.getBlock("filteredBuffer.id", DefaultProps.FILTERED_BUFFER_ID);
            filteredBufferBlock = new BlockFilteredBuffer(filteredBufferId.getInt());
            CoreProxy.proxy.registerBlock(filteredBufferBlock.func_71864_b("filteredBufferBlock"));
            CoreProxy.proxy.addName((Object)filteredBufferBlock, "Filtered Buffer");
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        TransportProxy.proxy.registerTileEntities();
        new BptBlockPipe(BuildCraftTransport.genericPipeBlock.field_71990_ca);
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsWood.field_77779_bT] = new BptItemPipeWooden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeFluidsWood.field_77779_bT] = new BptItemPipeWooden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsIron.field_77779_bT] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeFluidsIron.field_77779_bT] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsDiamond.field_77779_bT] = new BptItemPipeDiamond();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsEmerald.field_77779_bT] = new BptItemPipeEmerald();
        ActionManager.registerTriggerProvider(new PipeTriggerProvider());
        if (BuildCraftCore.loadDefaultRecipes) {
            this.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        ItemFacade.initialize();
        for (EnumColor enumColor : EnumColor.VALUES) {
            BuildCraftTransport.actionPipeColor[enumColor.ordinal()] = new ActionPipeColor(-1, enumColor);
        }
        for (EnumColor enumColor : ForgeDirection.VALID_DIRECTIONS) {
            BuildCraftTransport.actionPipeDirection[enumColor.ordinal()] = new ActionPipeDirection(-1, (ForgeDirection)enumColor);
        }
        for (Enum enum_ : PipePowerIron.PowerMode.VALUES) {
            BuildCraftTransport.actionPowerLimiter[enum_.ordinal()] = new ActionPowerLimiter(-1, (PipePowerIron.PowerMode)enum_);
        }
    }

    public void loadRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Item.field_77756_aW, 1, 2)});
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                CoreProxy.proxy.addShapelessRecipe(pipe.result, pipe.input);
                continue;
            }
            CoreProxy.proxy.addCraftingRecipe(pipe.result, pipe.input);
        }
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)filteredBufferBlock, 1), "wdw", "wcw", "wpw", Character.valueOf('w'), "plankWood", Character.valueOf('d'), pipeItemsDiamond, Character.valueOf('c'), Block.field_72077_au, Character.valueOf('p'), Block.field_71963_Z);
        GameRegistry.addRecipe((IRecipe)new ItemFacade.FacadeRecipe(facadeItem));
        try {
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(500, new ItemStack(redPipeWire, 8), "dyeRed", 1, new ItemStack(Item.field_77767_aC), new ItemStack(Item.field_77703_o)));
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(500, new ItemStack(bluePipeWire, 8), "dyeBlue", 1, new ItemStack(Item.field_77767_aC), new ItemStack(Item.field_77703_o)));
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(500, new ItemStack(greenPipeWire, 8), "dyeGreen", 1, new ItemStack(Item.field_77767_aC), new ItemStack(Item.field_77703_o)));
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(500, new ItemStack(yellowPipeWire, 8), "dyeYellow", 1, new ItemStack(Item.field_77767_aC), new ItemStack(Item.field_77703_o)));
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(pipeStructureCobblestone)}, 1000, new ItemStack(plugItem, 8)));
        }
        catch (Error error) {
            BCLog.logErrorAPI("Buildcraft", error, AssemblyRecipe.class);
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    public static Item buildPipe(int defaultID, Class<? extends Pipe> clas, String descr, Object ... ingredients) {
        String name = Character.toLowerCase(clas.getSimpleName().charAt(0)) + clas.getSimpleName().substring(1);
        Property prop = BuildCraftCore.mainConfiguration.getItem(name + ".id", defaultID);
        int id = prop.getInt(defaultID);
        ItemPipe res = BlockGenericPipe.registerPipe(id, clas);
        res.func_77655_b(clas.getSimpleName());
        LanguageRegistry.addName((Object)res, (String)descr);
        PipeRecipe recipe = new PipeRecipe();
        if (ingredients.length == 3) {
            recipe.result = new ItemStack((Item)res, 8);
            recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredients[0], Character.valueOf('B'), ingredients[1], Character.valueOf('C'), ingredients[2]};
            pipeRecipes.add(recipe);
        } else if (ingredients.length == 2) {
            recipe.isShapeless = true;
            recipe.result = new ItemStack((Item)res, 1);
            recipe.input = new Object[]{ingredients[0], ingredients[1]};
            pipeRecipes.add(recipe);
            if (ingredients[1] instanceof ItemPipe) {
                PipeRecipe uncraft = new PipeRecipe();
                uncraft.isShapeless = true;
                uncraft.input = new Object[]{new ItemStack((Item)res)};
                uncraft.result = new ItemStack((Item)ingredients[1]);
                pipeRecipes.add(uncraft);
            }
        }
        return res;
    }

    static {
        triggerPipeEmpty = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_EMPTY, TriggerPipeContents.Kind.Empty);
        triggerPipeItems = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ITEMS, TriggerPipeContents.Kind.ContainsItems);
        triggerPipeFluids = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_LIQUIDS, TriggerPipeContents.Kind.ContainsFluids);
        triggerPipeContainsEnergy = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_CONTAINS_ENERGY, TriggerPipeContents.Kind.ContainsEnergy);
        triggerPipeRequestsEnergy = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_REQUESTS_ENERGY, TriggerPipeContents.Kind.RequestsEnergy);
        triggerPipeTooMuchEnergy = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_TOO_MUCH_ENERGY, TriggerPipeContents.Kind.TooMuchEnergy);
        triggerRedSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_ACTIVE, true, IPipe.WireColor.Red);
        triggerRedSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_INACTIVE, false, IPipe.WireColor.Red);
        triggerBlueSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_ACTIVE, true, IPipe.WireColor.Blue);
        triggerBlueSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_INACTIVE, false, IPipe.WireColor.Blue);
        triggerGreenSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_ACTIVE, true, IPipe.WireColor.Green);
        triggerGreenSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_INACTIVE, false, IPipe.WireColor.Green);
        triggerYellowSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_ACTIVE, true, IPipe.WireColor.Yellow);
        triggerYellowSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_INACTIVE, false, IPipe.WireColor.Yellow);
        actionRedSignal = new ActionSignalOutput(DefaultProps.ACTION_RED_SIGNAL, IPipe.WireColor.Red);
        actionBlueSignal = new ActionSignalOutput(DefaultProps.ACTION_BLUE_SIGNAL, IPipe.WireColor.Blue);
        actionGreenSignal = new ActionSignalOutput(DefaultProps.ACTION_GREEN_SIGNAL, IPipe.WireColor.Green);
        actionYellowSignal = new ActionSignalOutput(DefaultProps.ACTION_YELLOW_SIGNAL, IPipe.WireColor.Yellow);
        actionEnergyPulser = new ActionEnergyPulser(DefaultProps.ACTION_ENERGY_PULSER);
        actionSingleEnergyPulse = new ActionSingleEnergyPulse(DefaultProps.ACTION_SINGLE_ENERGY_PULSE);
        actionPipeColor = new BCAction[16];
        actionPipeDirection = new BCAction[16];
        actionPowerLimiter = new BCAction[7];
        actionExtractionPresetRed = new ActionExtractionPreset(-1, EnumColor.RED);
        actionExtractionPresetBlue = new ActionExtractionPreset(-1, EnumColor.BLUE);
        actionExtractionPresetGreen = new ActionExtractionPreset(-1, EnumColor.GREEN);
        actionExtractionPresetYellow = new ActionExtractionPreset(-1, EnumColor.YELLOW);
        pipeRecipes = new LinkedList();
    }

    private static class ExtractionHandler
    implements IExtractionHandler {
        private final String[] items;
        private final String[] liquids;

        public ExtractionHandler(String[] items, String[] liquids) {
            this.items = items;
            this.liquids = liquids;
        }

        @Override
        public boolean canExtractItems(Object extractor, World world, int i, int j, int k) {
            return this.testStrings(this.items, world, i, j, k);
        }

        @Override
        public boolean canExtractFluids(Object extractor, World world, int i, int j, int k) {
            return this.testStrings(this.liquids, world, i, j, k);
        }

        private boolean testStrings(String[] excludedBlocks, World world, int i, int j, int k) {
            int id = world.func_72798_a(i, j, k);
            Block block = Block.field_71973_m[id];
            if (block == null) {
                return false;
            }
            int meta = world.func_72805_g(i, j, k);
            for (String excluded : excludedBlocks) {
                if (excluded.equals(block.func_71917_a())) {
                    return false;
                }
                String[] tokens = excluded.split(":");
                if (!tokens[0].equals(Integer.toString(id)) || tokens.length != 1 && !tokens[1].equals(Integer.toString(meta))) continue;
                return false;
            }
            return true;
        }
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

