/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.fluids;

import buildcraft.core.TileBuffer;
import buildcraft.core.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class FluidUtils {
    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, Utils.consumeItem(current));
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, Utils.consumeItem(current));
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, Utils.consumeItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static int getFluidBlockId(Fluid fluid, boolean moving) {
        if (fluid == FluidRegistry.WATER) {
            return moving ? Block.field_71942_A.field_71990_ca : Block.field_71943_B.field_71990_ca;
        }
        if (fluid == FluidRegistry.LAVA) {
            return moving ? Block.field_71944_C.field_71990_ca : Block.field_71938_D.field_71990_ca;
        }
        return fluid.getBlockID();
    }

    public static void pushFluidToConsumers(IFluidTank tank, int flowCap, TileBuffer[] tileBuffer) {
        int amountToPush = flowCap;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int used;
            TileEntity tile;
            FluidStack fluidStack = tank.drain(amountToPush, false);
            if (fluidStack == null || fluidStack.amount <= 0 || !((tile = tileBuffer[side.ordinal()].getTile()) instanceof IFluidHandler) || (used = ((IFluidHandler)tile).fill(side.getOpposite(), fluidStack, true)) <= 0) continue;
            tank.drain(used, true);
            if ((amountToPush -= used) > 0) continue;
            return;
        }
    }
}

