/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.IBuilderInventory;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptSlot;
import buildcraft.core.utils.BCLog;
import buildcraft.core.utils.BlockUtil;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;

public class BptBuilderBlueprint
extends BptBuilderBase {
    LinkedList<BptSlot> clearList = new LinkedList();
    LinkedList<BptSlot> primaryList = new LinkedList();
    LinkedList<BptSlot> secondaryList = new LinkedList();
    LinkedList<BptSlot> postProcessingList = new LinkedList();
    public TreeSet<ItemStack> neededItems = new TreeSet<ItemStack>(new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            if (o1.field_77994_a > o2.field_77994_a) {
                return -1;
            }
            if (o1.field_77994_a < o2.field_77994_a) {
                return 1;
            }
            if (o1.field_77993_c > o2.field_77993_c) {
                return -1;
            }
            if (o1.field_77993_c < o2.field_77993_c) {
                return 1;
            }
            if (o1.func_77960_j() > o2.func_77960_j()) {
                return -1;
            }
            if (o1.func_77960_j() < o2.func_77960_j()) {
                return 1;
            }
            return 0;
        }
    });

    public BptBuilderBlueprint(BptBlueprint bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
        BptSlot slot;
        int zCoord;
        int yCoord;
        int xCoord;
        int k;
        int i;
        int j;
        for (j = bluePrint.sizeY - 1; j >= 0; --j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.ClearIfInvalid;
                    this.clearList.add(slot);
                }
            }
        }
        for (j = 0; j < bluePrint.sizeY; ++j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.Build;
                    if (slot.blockId != 0 && Block.field_71973_m[slot.blockId].func_71926_d()) {
                        this.primaryList.add(slot);
                    } else {
                        this.secondaryList.add(slot);
                    }
                    if (slot.blockId == 0) continue;
                    this.postProcessingList.add(slot.clone());
                }
            }
        }
        this.recomputeNeededItems();
    }

    private void checkDone() {
        this.recomputeNeededItems();
        this.done = this.clearList.size() == 0 && this.primaryList.size() == 0 && this.secondaryList.size() == 0;
    }

    @Override
    public BptSlot getNextBlock(World world, IBuilderInventory inv) {
        if (this.clearList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.clearList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.primaryList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.primaryList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.secondaryList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.secondaryList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        this.checkDone();
        return null;
    }

    public BptSlot internalGetNextBlock(World world, IBuilderInventory inv, LinkedList<BptSlot> list) {
        LinkedList<BptSlot> failSlots = new LinkedList<BptSlot>();
        BptSlot result = null;
        while (list.size() > 0) {
            BptSlot slot = list.removeFirst();
            boolean getNext = false;
            try {
                getNext = !slot.isValid(this.context) && !slot.ignoreBuilding();
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "internalGetBlock", t);
                getNext = false;
            }
            if (!getNext) continue;
            if (slot.mode == BptSlot.Mode.ClearIfInvalid) {
                if (BlockUtil.isSoftBlock(world, slot.x, slot.y, slot.z)) continue;
                result = slot;
                break;
            }
            if (world.func_72912_H().func_76077_q() == EnumGameType.CREATIVE) {
                result = slot;
                break;
            }
            if (this.checkRequirements(inv, slot)) {
                this.useRequirements(inv, slot);
                result = slot;
                break;
            }
            failSlots.add(slot);
        }
        list.addAll(failSlots);
        return result;
    }

    public boolean checkRequirements(IBuilderInventory inv, BptSlot slot) {
        if (slot.blockId == 0) {
            return true;
        }
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        LinkedList<ItemStack> tmpInv = new LinkedList<ItemStack>();
        try {
            for (ItemStack stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing("BptBuilderBlueprint", "checkRequirements", t);
        }
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            if (!inv.isBuildingMaterial(i) || inv.func_70301_a(i) == null) continue;
            tmpInv.add(inv.func_70301_a(i).func_77946_l());
        }
        for (ItemStack reqStk : tmpReq) {
            for (ItemStack invStk : tmpInv) {
                if (invStk == null || reqStk.field_77993_c != invStk.field_77993_c || invStk.field_77994_a <= 0 || !invStk.func_77984_f() && reqStk.func_77960_j() != invStk.func_77960_j()) continue;
                try {
                    slot.useItem(this.context, reqStk, invStk);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing("BptBuilderBlueprint", "checkRequirements", t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a == 0) continue;
            return false;
        }
        return true;
    }

    public void useRequirements(IBuilderInventory inv, BptSlot slot) {
        if (slot.blockId == 0) {
            return;
        }
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            for (ItemStack stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing("BptBuilderBlueprint", "useRequirements", t);
        }
        ListIterator<ItemStack> itr = tmpReq.listIterator();
        while (itr.hasNext()) {
            ItemStack reqStk = (ItemStack)itr.next();
            boolean smallStack = reqStk.field_77994_a == 1;
            ItemStack usedStack = reqStk;
            int size = inv.func_70302_i_();
            for (int i = 0; i <= size; ++i) {
                ItemStack invStk;
                if (!inv.isBuildingMaterial(i)) {
                    // empty if block
                }
                if ((invStk = inv.func_70301_a(i)) == null || reqStk.field_77993_c != invStk.field_77993_c || invStk.field_77994_a <= 0 || !invStk.func_77984_f() && reqStk.func_77960_j() != invStk.func_77960_j()) continue;
                try {
                    usedStack = slot.useItem(this.context, reqStk, invStk);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing("BptBuilderBlueprint", "useRequirements", t);
                }
                if (invStk.field_77994_a == 0) {
                    inv.func_70299_a(i, null);
                } else {
                    inv.func_70299_a(i, invStk);
                }
                if (reqStk.field_77994_a == 0) break;
            }
            if (reqStk.field_77994_a != 0) {
                return;
            }
            if (!smallStack) continue;
            itr.set(usedStack);
        }
    }

    public void recomputeNeededItems() {
        Integer num;
        LinkedList<Object> stacks;
        this.neededItems.clear();
        TreeMap<ItemStack, Integer> computeStacks = new TreeMap<ItemStack, Integer>(new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1.field_77993_c > o2.field_77993_c) {
                    return 1;
                }
                if (o1.field_77993_c < o2.field_77993_c) {
                    return -1;
                }
                if (o1.func_77960_j() > o2.func_77960_j()) {
                    return 1;
                }
                if (o1.func_77960_j() < o2.func_77960_j()) {
                    return -1;
                }
                return 0;
            }
        });
        for (BptSlot slot : this.primaryList) {
            stacks = new LinkedList();
            try {
                stacks = slot.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "recomputeIfNeeded", t);
            }
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.field_77993_c == 0) continue;
                if (!computeStacks.containsKey(itemStack)) {
                    computeStacks.put(itemStack.func_77946_l(), itemStack.field_77994_a);
                    continue;
                }
                num = (Integer)computeStacks.get(itemStack);
                num = num + itemStack.field_77994_a;
                computeStacks.put(itemStack, num);
            }
        }
        for (BptSlot slot : this.secondaryList) {
            stacks = slot.getRequirements(this.context);
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.field_77993_c <= 0 || itemStack.field_77993_c >= Item.field_77698_e.length || itemStack.field_77994_a == 0 || itemStack.func_77973_b() == null) continue;
                if (!computeStacks.containsKey(itemStack)) {
                    computeStacks.put(itemStack.func_77946_l(), itemStack.field_77994_a);
                    continue;
                }
                num = (Integer)computeStacks.get(itemStack);
                num = num + itemStack.field_77994_a;
                computeStacks.put(itemStack, num);
            }
        }
        for (ItemStack stack : computeStacks.keySet()) {
            if (stack.func_77984_f()) {
                this.neededItems.add(new ItemStack(stack.func_77973_b()));
                continue;
            }
            this.neededItems.add(new ItemStack(stack.field_77993_c, ((Integer)computeStacks.get(stack)).intValue(), stack.func_77960_j()));
        }
    }

    @Override
    public void postProcessing(World world) {
        for (BptSlot s : this.postProcessingList) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "postProcessing", t);
            }
        }
    }
}

