/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.ConfigUtils;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockFloodGate;
import buildcraft.factory.BlockFrame;
import buildcraft.factory.BlockHopper;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockQuarry;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.BptBlockAutoWorkbench;
import buildcraft.factory.BptBlockFrame;
import buildcraft.factory.BptBlockRefinery;
import buildcraft.factory.BptBlockTank;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.FactoryProxyClient;
import buildcraft.factory.GuiHandler;
import buildcraft.factory.PumpDimensionList;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileFloodGate;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileQuarry;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.network.PacketHandlerFactory;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;

@Mod(name="BuildCraft Factory", version="4.2.2", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@4.2.2")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerFactory.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftFactory {
    public static final int MINING_MJ_COST_PER_BLOCK = 64;
    public static BlockQuarry quarryBlock;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockFrame frameBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockFloodGate floodGateBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockHopper hopperBlock;
    public static boolean allowMining;
    public static boolean quarryOneTimeUse;
    public static float miningMultiplier;
    public static int miningDepth;
    public static PumpDimensionList pumpDimensionList;
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        FactoryProxy.proxy.initializeNEIIntegration();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new QuarryChunkloadCallback());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileQuarry.class, "Machine");
        CoreProxy.proxy.registerTileEntity(TileMiningWell.class, "MiningWell");
        CoreProxy.proxy.registerTileEntity(TileAutoWorkbench.class, "AutoWorkbench");
        CoreProxy.proxy.registerTileEntity(TilePump.class, "net.minecraft.src.buildcraft.factory.TilePump");
        CoreProxy.proxy.registerTileEntity(TileFloodGate.class, "net.minecraft.src.buildcraft.factory.TileFloodGate");
        CoreProxy.proxy.registerTileEntity(TileTank.class, "net.minecraft.src.buildcraft.factory.TileTank");
        CoreProxy.proxy.registerTileEntity(TileRefinery.class, "net.minecraft.src.buildcraft.factory.Refinery");
        CoreProxy.proxy.registerTileEntity(TileHopper.class, "net.minecraft.src.buildcraft.factory.TileHopper");
        FactoryProxy.proxy.initializeTileEntities();
        new BptBlockAutoWorkbench(BuildCraftFactory.autoWorkbenchBlock.field_71990_ca);
        new BptBlockFrame(BuildCraftFactory.frameBlock.field_71990_ca);
        new BptBlockRefinery(BuildCraftFactory.refineryBlock.field_71990_ca);
        new BptBlockTank(BuildCraftFactory.tankBlock.field_71990_ca);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    @Mod.EventHandler
    public void initialize(FMLPreInitializationEvent evt) {
        ConfigUtils genCat = new ConfigUtils(BuildCraftCore.mainConfiguration, "general");
        allowMining = genCat.get("mining.enabled", true, "disables the recipes for automated mining machines");
        quarryOneTimeUse = genCat.get("quarry.one.time.use", false, "Quarry cannot be picked back up after placement");
        miningMultiplier = genCat.get("mining.cost.multipler", 1.0f, 1.0f, 10.0f, "cost multiplier for mining operations, range (1.0 - 10.0)\nhigh values may render engines incapable of powering machines directly");
        miningDepth = genCat.get("mining.depth", 2, 256, 256, "how far below the machine can mining machines dig, range (2 - 256), default 256");
        Property pumpList = BuildCraftCore.mainConfiguration.get("general", "pumping.controlList", DefaultProps.PUMP_DIMENSION_LIST);
        pumpList.comment = "Allows admins to whitelist or blacklist pumping of specific fluids in specific dimensions.\nEg. \"-/-1/Lava\" will disable lava in the nether. \"-/*/Lava\" will disable lava in any dimension. \"+/0/*\" will enable any fluid in the overworld.\nEntries are comma seperated, banned fluids have precedence over allowed ones.Default is \"+/*/*,+/-1/Lava\" - the second redundant entry (\"+/-1/lava\") is there to show the format.";
        pumpDimensionList = new PumpDimensionList(pumpList.getString());
        int miningWellId = BuildCraftCore.mainConfiguration.getBlock("miningWell.id", DefaultProps.MINING_WELL_ID).getInt(DefaultProps.MINING_WELL_ID);
        int plainPipeId = BuildCraftCore.mainConfiguration.getBlock("drill.id", DefaultProps.DRILL_ID).getInt(DefaultProps.DRILL_ID);
        int autoWorkbenchId = BuildCraftCore.mainConfiguration.getBlock("autoWorkbench.id", DefaultProps.AUTO_WORKBENCH_ID).getInt(DefaultProps.AUTO_WORKBENCH_ID);
        int frameId = BuildCraftCore.mainConfiguration.getBlock("frame.id", DefaultProps.FRAME_ID).getInt(DefaultProps.FRAME_ID);
        int quarryId = BuildCraftCore.mainConfiguration.getBlock("quarry.id", DefaultProps.QUARRY_ID).getInt(DefaultProps.QUARRY_ID);
        int pumpId = BuildCraftCore.mainConfiguration.getBlock("pump.id", DefaultProps.PUMP_ID).getInt(DefaultProps.PUMP_ID);
        int floodGateId = BuildCraftCore.mainConfiguration.getBlock("floodGate.id", DefaultProps.FLOOD_GATE_ID).getInt(DefaultProps.FLOOD_GATE_ID);
        int tankId = BuildCraftCore.mainConfiguration.getBlock("tank.id", DefaultProps.TANK_ID).getInt(DefaultProps.TANK_ID);
        int refineryId = BuildCraftCore.mainConfiguration.getBlock("refinery.id", DefaultProps.REFINERY_ID).getInt(DefaultProps.REFINERY_ID);
        int hopperId = BuildCraftCore.mainConfiguration.getBlock("hopper.id", DefaultProps.HOPPER_ID).getInt(DefaultProps.HOPPER_ID);
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        if (miningWellId > 0) {
            miningWellBlock = new BlockMiningWell(miningWellId);
            CoreProxy.proxy.registerBlock(miningWellBlock.func_71864_b("miningWellBlock"));
            CoreProxy.proxy.addName((Object)miningWellBlock, "Mining Well");
        }
        if (plainPipeId > 0) {
            plainPipeBlock = new BlockPlainPipe(plainPipeId);
            CoreProxy.proxy.registerBlock(plainPipeBlock.func_71864_b("plainPipeBlock"));
            CoreProxy.proxy.addName(plainPipeBlock, "Mining Pipe");
        }
        if (autoWorkbenchId > 0) {
            autoWorkbenchBlock = new BlockAutoWorkbench(autoWorkbenchId);
            CoreProxy.proxy.registerBlock(autoWorkbenchBlock.func_71864_b("autoWorkbenchBlock"));
            CoreProxy.proxy.addName((Object)autoWorkbenchBlock, "Automatic Crafting Table");
        }
        if (frameId > 0) {
            frameBlock = new BlockFrame(frameId);
            CoreProxy.proxy.registerBlock(frameBlock.func_71864_b("frameBlock"));
            CoreProxy.proxy.addName(frameBlock, "Frame");
        }
        if (quarryId > 0) {
            quarryBlock = new BlockQuarry(quarryId);
            CoreProxy.proxy.registerBlock(quarryBlock.func_71864_b("machineBlock"));
            CoreProxy.proxy.addName((Object)quarryBlock, "Quarry");
        }
        if (tankId > 0) {
            tankBlock = new BlockTank(tankId);
            CoreProxy.proxy.registerBlock(tankBlock.func_71864_b("tankBlock"));
            CoreProxy.proxy.addName((Object)tankBlock, "Tank");
        }
        if (pumpId > 0) {
            pumpBlock = new BlockPump(pumpId);
            CoreProxy.proxy.registerBlock(pumpBlock.func_71864_b("pumpBlock"));
            CoreProxy.proxy.addName((Object)pumpBlock, "Pump");
        }
        if (floodGateId > 0) {
            floodGateBlock = new BlockFloodGate(floodGateId);
            CoreProxy.proxy.registerBlock(floodGateBlock.func_71864_b("floodGateBlock"));
            CoreProxy.proxy.addName((Object)floodGateBlock, "Flood Gate");
        }
        if (refineryId > 0) {
            refineryBlock = new BlockRefinery(refineryId);
            CoreProxy.proxy.registerBlock(refineryBlock.func_71864_b("refineryBlock"));
            CoreProxy.proxy.addName((Object)refineryBlock, "Refinery");
        }
        if (hopperId > 0) {
            hopperBlock = new BlockHopper(hopperId);
            CoreProxy.proxy.registerBlock(hopperBlock.func_71864_b("blockHopper"));
            CoreProxy.proxy.addName((Object)hopperBlock, "Hopper");
        }
        FactoryProxy.proxy.initializeEntityRenders();
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        if (allowMining) {
            if (miningWellBlock != null) {
                CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)miningWellBlock, 1), "ipi", "igi", "iPi", Character.valueOf('p'), Item.field_77767_aC, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('P'), Item.field_77696_g);
            }
            if (quarryBlock != null) {
                CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)quarryBlock), "ipi", "gig", "dDd", Character.valueOf('i'), BuildCraftCore.ironGearItem, Character.valueOf('p'), Item.field_77767_aC, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('D'), Item.field_77674_B);
            }
            if (pumpBlock != null && miningWellBlock != null) {
                CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pumpBlock), new Object[]{"T", "W", Character.valueOf('T'), tankBlock != null ? tankBlock : Block.field_71946_M, Character.valueOf('W'), miningWellBlock});
            }
        }
        if (!(allowMining && miningWellBlock != null || pumpBlock == null)) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pumpBlock), new Object[]{"iri", "iTi", "gpg", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('T'), tankBlock != null ? tankBlock : Block.field_71946_M, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('p'), BuildCraftTransport.pipeFluidsGold});
        }
        if (autoWorkbenchBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), " g ", "gwg", " g ", Character.valueOf('w'), Block.field_72060_ay, Character.valueOf('g'), BuildCraftCore.woodenGearItem);
        }
        if (tankBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)tankBlock), "ggg", "g g", "ggg", Character.valueOf('g'), Block.field_71946_M);
        }
        if (refineryBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)refineryBlock), new Object[]{"RTR", "TGT", Character.valueOf('T'), tankBlock != null ? tankBlock : Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.diamondGearItem, Character.valueOf('R'), Block.field_72035_aQ});
        }
        if (hopperBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)hopperBlock), "ICI", "IGI", " I ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('C'), Block.field_72077_au, Character.valueOf('G'), BuildCraftCore.stoneGearItem);
        }
        if (floodGateBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)floodGateBlock), new Object[]{"IGI", "FTF", "IFI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('T'), tankBlock != null ? tankBlock : Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('F'), new ItemStack(Block.field_72002_bp)});
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map.field_94255_a == 0) {
            TextureMap terrainTextures = evt.map;
            FactoryProxyClient.pumpTexture = terrainTextures.func_94245_a("buildcraft:pump_tube");
            FactoryProxyClient.drillTexture = terrainTextures.func_94245_a("buildcraft:blockDrillTexture");
            FactoryProxyClient.drillHeadTexture = terrainTextures.func_94245_a("buildcraft:blockDrillHeadTexture");
        }
    }

    static {
        allowMining = true;
        quarryOneTimeUse = false;
        miningMultiplier = 1.0f;
        miningDepth = 256;
    }

    public class QuarryChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                int quarryY = ticket.getModData().func_74762_e("quarryY");
                int quarryZ = ticket.getModData().func_74762_e("quarryZ");
                TileQuarry tq = (TileQuarry)world.func_72796_p(quarryX, quarryY, quarryZ);
                tq.forceChunkLoading(ticket);
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                int blId = world.func_72798_a(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ"));
                if (blId != BuildCraftFactory.quarryBlock.field_71990_ca) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

