/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.vanilla;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.IOException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import rebelkeithy.mods.keithyutils.metablock.MetaBlock;
import rebelkeithy.mods.keithyutils.metablock.SubBlock;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;

public class VanillaAddons {
    public static SubBlock goldBrick;
    public static SubBlock ironBrick;
    public static Item dustIron;
    public static Item dustGold;
    public static int goldBrickID;
    public static int ironBrickID;
    public static int goldBrickMeta;
    public static int ironBrickMeta;

    public static void init() {
        VanillaAddons.initConfig();
        goldBrick = new SubBlock(goldBrickID, goldBrickMeta, "Metallurgy:Vanilla/GoldBrick").setHardness(3.0f).setResistance(10.0f).setUnlocalizedName("Metallurgy:Vanilla/GoldBricks").setCreativeTab(CreativeTabs.field_78030_b);
        ironBrick = new SubBlock(ironBrickID, ironBrickMeta, "Metallurgy:Vanilla/IronBrick").setHardness(5.0f).setResistance(10.0f).setUnlocalizedName("Metallurgy:Vanilla/IronBricks").setCreativeTab(CreativeTabs.field_78030_b);
        MetaBlock.registerID((int)goldBrickID);
        MetaBlock.registerID((int)ironBrickID);
    }

    public static void initConfig() {
        File fileDir = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3");
        fileDir.mkdir();
        File cfgFile = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3/MetallurgyVanilla.cfg");
        try {
            cfgFile.createNewFile();
        }
        catch (IOException e) {
            MetallurgyCore.log.info("[Metallurgy3] Could not create configuration file for Metallurgy 3 metal set Vanilla. Reason:");
            MetallurgyCore.log.info(e.getLocalizedMessage());
        }
        Configuration config = new Configuration(cfgFile);
        config.load();
        ironBrickID = Integer.parseInt(config.get("Iron", "Brick ID", "900:3").getString().split(":")[0]);
        ironBrickMeta = Integer.parseInt(config.get("Iron", "Brick ID", "900:3").getString().split(":")[1]);
        goldBrickID = Integer.parseInt(config.get("Gold", "Brick ID", "900:4").getString().split(":")[0]);
        goldBrickMeta = Integer.parseInt(config.get("Gold", "Brick ID", "900:4").getString().split(":")[1]);
        config.save();
    }

    public static void load() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(goldBrickID, 4, goldBrickMeta), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), Item.field_77717_p});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ironBrickID, 4, ironBrickMeta), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), Item.field_77703_o});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Item.field_77717_p), (Object[])new Object[]{new ItemStack(goldBrickID, 1, goldBrickMeta)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Item.field_77703_o), (Object[])new Object[]{new ItemStack(ironBrickID, 1, ironBrickMeta)});
    }

    public static void registerNames() {
        LanguageRegistry.addName((Object)new ItemStack(goldBrickID, 1, goldBrickMeta), (String)"Gold Bricks");
        LanguageRegistry.addName((Object)new ItemStack(ironBrickID, 1, ironBrickMeta), (String)"Iron Bricks");
    }
}

