/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import rebelkeithy.mods.metallurgy.core.Coord;
import rebelkeithy.mods.metallurgy.machines.MetallurgyMachines;
import rebelkeithy.mods.metallurgy.machines.storage.InventoryStorage;
import rebelkeithy.mods.metallurgy.machines.storage.TileEntityStorageBlock;

public class TileEntityStorageAccessor
extends TileEntity {
    public Map<Integer, InventoryStorage> inventories = new HashMap<Integer, InventoryStorage>();
    List<Coord> connectedBlocks = new ArrayList<Coord>();
    List<Coord> activatedBlocks = new ArrayList<Coord>();
    Coord corner1 = new Coord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    Coord corner2 = new Coord(this.field_70329_l, this.field_70330_m, this.field_70327_n);

    private void activateBlock(Coord c) {
        this.activatedBlocks.add(c);
        if (this.field_70331_k.func_72798_a(c.x, c.y, c.z) == MetallurgyMachines.storageBlock.field_71990_ca) {
            int itemID = ((TileEntityStorageBlock)this.field_70331_k.func_72796_p((int)c.x, (int)c.y, (int)c.z)).itemID;
            this.addTab(new ItemStack(itemID, 1, 0), 27);
        }
    }

    public void addBlock(int xCoord, int yCoord, int zCoord) {
        if (this.corner1.equals(new Coord(0, 0, 0)) && this.corner2.equals(new Coord(0, 0, 0))) {
            this.corner1 = new Coord(xCoord, yCoord, zCoord);
            this.corner2 = new Coord(xCoord, yCoord, zCoord);
        }
        this.expandZAxis();
        this.expandYAxis();
        this.expandXAxis();
    }

    public void addTab(ItemStack itemstack, int amount) {
        if (this.inventories.containsKey(itemstack.field_77993_c)) {
            this.inventories.get(itemstack.field_77993_c).addSlots(amount);
        } else {
            this.inventories.put(itemstack.field_77993_c, new InventoryStorage(this, amount));
        }
    }

    private boolean checkNewBlock(int x, int y, int z) {
        int id = this.field_70331_k.func_72798_a(x, y, z);
        return id == MetallurgyMachines.storageAccessor.field_71990_ca || id == MetallurgyMachines.storageBlock.field_71990_ca;
    }

    private void expandXAxis() {
        List<Coord> iter = Coord.between(new Coord(this.corner2.x + 1, this.corner1.y, this.corner1.z), new Coord(this.corner2.x + 1, this.corner2.y, this.corner2.z));
        if (this.tryExpandSide(iter)) {
            ++this.corner2.x;
        }
        if (this.tryExpandSide(iter = Coord.between(new Coord(this.corner1.x - 1, this.corner1.y, this.corner1.z), new Coord(this.corner1.x - 1, this.corner2.y, this.corner2.z)))) {
            --this.corner1.x;
        }
    }

    private void expandYAxis() {
        List<Coord> iter = Coord.between(new Coord(this.corner1.x, this.corner2.y + 1, this.corner1.z), new Coord(this.corner2.x, this.corner2.y + 1, this.corner2.z));
        if (this.tryExpandSide(iter)) {
            ++this.corner2.y;
        }
        if (this.tryExpandSide(iter = Coord.between(new Coord(this.corner1.x, this.corner1.y - 1, this.corner1.z), new Coord(this.corner2.x, this.corner1.y - 1, this.corner2.z)))) {
            --this.corner1.y;
        }
    }

    private void expandZAxis() {
        List<Coord> iter = Coord.between(new Coord(this.corner1.x, this.corner1.y, this.corner2.z + 1), new Coord(this.corner2.x, this.corner2.y, this.corner2.z + 1));
        if (this.tryExpandSide(iter)) {
            ++this.corner2.z;
        }
        if (this.tryExpandSide(iter = Coord.between(new Coord(this.corner1.x, this.corner1.y, this.corner1.z - 1), new Coord(this.corner2.x, this.corner2.y, this.corner1.z - 1)))) {
            --this.corner1.z;
        }
    }

    public InventoryStorage getInventory() {
        if (this.inventories.size() == 0) {
            return new InventoryStorage(this, 0);
        }
        return null;
    }

    public InventoryStorage getInventory(int id) {
        if (id == 0) {
            return this.getInventory();
        }
        return this.inventories.get(id);
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList tagTabList = par1NBTTagCompound.func_74761_m("TabList");
        for (int n = 0; n < tagTabList.func_74745_c(); ++n) {
            NBTTagCompound tag = (NBTTagCompound)tagTabList.func_74743_b(n);
            int id = tag.func_74762_e("ID");
            int size = tag.func_74762_e("Size");
            this.addTab(new ItemStack(id, 1, 0), size);
        }
        for (int id : this.inventories.keySet()) {
            NBTTagList tagTabItems = par1NBTTagCompound.func_74761_m("Tab" + id);
            for (int n = 0; n < tagTabItems.func_74745_c(); ++n) {
                NBTTagCompound tagItem = (NBTTagCompound)tagTabItems.func_74743_b(n);
                int item = tagItem.func_74762_e("Slot");
                this.inventories.get((Object)Integer.valueOf((int)id)).items[item] = ItemStack.func_77949_a((NBTTagCompound)tagItem);
            }
        }
    }

    public void setTabSize(ItemStack itemStack, int size) {
        if (this.field_70331_k.field_72995_K) {
            if (this.inventories.containsKey(itemStack.field_77993_c)) {
                int change = size - this.inventories.get((Object)Integer.valueOf((int)itemStack.field_77993_c)).items.length;
                this.addTab(itemStack, change);
            } else {
                this.addTab(itemStack, size);
            }
        }
    }

    private boolean tryExpandSide(List<Coord> coords) {
        for (Coord c : coords) {
            if (this.checkNewBlock(c.x, c.y, c.z)) continue;
            return false;
        }
        for (Coord c : coords) {
            this.activateBlock(c);
        }
        return true;
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        NBTTagList var2 = new NBTTagList();
        for (Integer id : this.inventories.keySet()) {
            InventoryStorage inv = this.inventories.get(id);
            NBTTagCompound tagID = new NBTTagCompound();
            tagID.func_74768_a("ID", id.intValue());
            tagID.func_74768_a("Size", inv.func_70302_i_());
            var2.func_74742_a((NBTBase)tagID);
        }
        par1NBTTagCompound.func_74782_a("TabList", (NBTBase)var2);
        for (Integer id : this.inventories.keySet()) {
            NBTTagList items = new NBTTagList();
            InventoryStorage inv = this.inventories.get(id);
            for (int n = 0; n < inv.func_70302_i_(); ++n) {
                if (inv.items[n] == null) continue;
                NBTTagCompound tagSlot = new NBTTagCompound();
                tagSlot.func_74768_a("Slot", n);
                inv.items[n].func_77955_b(tagSlot);
                items.func_74742_a((NBTBase)tagSlot);
            }
            par1NBTTagCompound.func_74782_a("Tab" + id, (NBTBase)items);
        }
    }
}

