/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core.metalsets;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import rebelkeithy.mods.keithyutils.items.CustomItemAxe;
import rebelkeithy.mods.keithyutils.items.CustomItemHoe;
import rebelkeithy.mods.keithyutils.items.CustomItemPickaxe;
import rebelkeithy.mods.keithyutils.items.CustomItemSpade;
import rebelkeithy.mods.keithyutils.metablock.MetaBlock;
import rebelkeithy.mods.keithyutils.metablock.SubBlock;
import rebelkeithy.mods.metallurgy.api.IOreInfo;
import rebelkeithy.mods.metallurgy.api.OreType;
import rebelkeithy.mods.metallurgy.core.MetalInfoDatabase;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;
import rebelkeithy.mods.metallurgy.core.metalsets.ItemMetallurgy;
import rebelkeithy.mods.metallurgy.core.metalsets.ItemMetallurgyArmor;
import rebelkeithy.mods.metallurgy.core.metalsets.ItemMetallurgySword;
import rebelkeithy.mods.metallurgy.machines.abstractor.AbstractorRecipes;

public class OreInfo
implements IOreInfo,
IWorldGenerator {
    protected String setName;
    protected String name;
    protected boolean enabled;
    protected CreativeTabs tab;
    protected OreType type;
    public int oreID;
    public int oreMeta;
    protected int blockID;
    protected int blockMeta;
    protected int brickID;
    protected int brickMeta;
    protected int itemIDs;
    protected String dropName;
    protected int dropMin;
    protected int dropMax;
    protected String[] alloyRecipe;
    protected int abstractorXP;
    protected int blockLvl;
    protected int pickLvl;
    protected int toolDura;
    protected int toolDamage;
    protected int toolSpeed;
    protected int toolEnchant;
    protected int helmetArmor;
    protected int chestArmor;
    protected int legsArmor;
    protected int bootsArmor;
    protected int armorDura;
    protected int dungeonLootChance;
    protected int dungeonLootAmount;
    protected int veinCount;
    protected int oreCount;
    protected int minHeight;
    protected int maxHeight;
    protected int veinChance;
    protected int veinDensity;
    protected String[] diminsions;
    public SubBlock ore;
    public SubBlock block;
    public SubBlock brick;
    public Item dust;
    public Item ingot;
    public EnumToolMaterial toolEnum;
    public Item pickaxe;
    public Item shovel;
    public Item axe;
    public Item hoe;
    public ItemMetallurgySword sword;
    public Item helmet;
    public Item chest;
    public Item legs;
    public Item boots;

    public OreInfo() {
    }

    public OreInfo(Map<String, String> info, CreativeTabs tab) {
        this.setName = info.get("Metal Set");
        this.name = info.get("Name");
        this.tab = tab;
        if (info.get("Type").equals("Ore")) {
            this.type = OreType.ORE;
        } else if (info.get("Type").equals("Catalyst")) {
            this.type = OreType.CATALYST;
        } else if (info.get("Type").equals("Alloy")) {
            this.type = OreType.ALLOY;
        } else if (info.get("Type").equals("Respawn")) {
            this.type = OreType.RESPAWN;
        } else if (info.get("Type").equals("Drop")) {
            this.type = OreType.DROP;
        }
        this.alloyRecipe = info.get("Alloy Recipe").split("\" \"");
        for (int n = 0; n < this.alloyRecipe.length; ++n) {
            this.alloyRecipe[n] = "dust" + this.alloyRecipe[n].replace("\"", "");
        }
        if (this.type.generates()) {
            this.oreID = Integer.parseInt(info.get("Ore ID").split(":")[0]);
            this.oreMeta = Integer.parseInt(info.get("Ore ID").split(":")[1]);
        }
        if (!info.get("Block ID").equals("0")) {
            this.blockID = Integer.parseInt(info.get("Block ID").split(":")[0]);
            this.blockMeta = Integer.parseInt(info.get("Block ID").split(":")[1]);
        }
        if (!info.get("Brick ID").equals("0")) {
            this.brickID = Integer.parseInt(info.get("Brick ID").split(":")[0]);
            this.brickMeta = Integer.parseInt(info.get("Brick ID").split(":")[1]);
        }
        if (this.type == OreType.DROP) {
            this.dropName = info.get("Drops").replace("\"", "");
            if (info.get("Drop Amount").contains("-")) {
                this.dropMin = Integer.parseInt(info.get("Drop Amount").split("-")[0]);
                this.dropMax = Integer.parseInt(info.get("Drop Amount").split("-")[1]);
            } else {
                this.dropMax = this.dropMin = Integer.parseInt(info.get("Drop Amount"));
            }
        } else {
            this.dropName = null;
        }
        this.itemIDs = Integer.parseInt(info.get("Item IDs"));
        this.abstractorXP = Integer.parseInt(info.get("Abstractor XP"));
        this.blockLvl = Integer.parseInt(info.get("Block lvl"));
        if (this.type != OreType.CATALYST && this.type != OreType.DROP) {
            this.pickLvl = Integer.parseInt(info.get("Pick lvl"));
            this.toolDura = Integer.parseInt(info.get("Durability"));
            this.toolDamage = Integer.parseInt(info.get("Damage"));
            this.toolSpeed = Integer.parseInt(info.get("Speed"));
            this.toolEnchant = Integer.parseInt(info.get("Enchantability"));
            this.helmetArmor = Integer.parseInt(info.get("Helmet Armor"));
            this.chestArmor = Integer.parseInt(info.get("Chestplate Armor"));
            this.legsArmor = Integer.parseInt(info.get("Leggings Armor"));
            this.bootsArmor = Integer.parseInt(info.get("Boots Armor"));
            this.armorDura = Integer.parseInt(info.get("Durability Multiplier"));
        }
        this.dungeonLootChance = Integer.parseInt(info.get("Dungeon Loot Chance"));
        this.dungeonLootAmount = Integer.parseInt(info.get("Dungeon Loot Amount"));
        if (this.type.generates()) {
            this.veinCount = Integer.parseInt(info.get("Veins Per Chunk"));
            this.oreCount = Integer.parseInt(info.get("Ores Per Vein"));
            this.minHeight = Integer.parseInt(info.get("Min Level"));
            this.maxHeight = Integer.parseInt(info.get("Max Level"));
            this.veinChance = Integer.parseInt(info.get("Vein Chance Per Chunk"));
            this.veinDensity = Integer.parseInt(info.get("Vein Density"));
            this.diminsions = info.get("Diminsions").split(" ");
        }
    }

    public void addRecipes() {
        ShapedOreRecipe recipe;
        if (!this.enabled) {
            return;
        }
        if (this.type.generates() && this.ore != null) {
            FurnaceRecipes.func_77602_a().addSmelting(this.oreID, this.oreMeta, new ItemStack(this.ingot), 0.0f);
        }
        FurnaceRecipes.func_77602_a().addSmelting(this.dust.field_77779_bT, 0, new ItemStack(this.ingot), 0.0f);
        if (this.block != null) {
            recipe = new ShapedOreRecipe(new ItemStack(this.blockID, 1, this.blockMeta), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingot" + this.name});
            GameRegistry.addRecipe((IRecipe)recipe);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.ingot, 9), (Object[])new Object[]{new ItemStack(this.blockID, 1, this.blockMeta)});
        }
        if (this.brick != null) {
            recipe = new ShapedOreRecipe(new ItemStack(this.brickID, 4, this.brickMeta), new Object[]{"XX", "XX", Character.valueOf('X'), "ingot" + this.name});
            GameRegistry.addRecipe((IRecipe)recipe);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.ingot, 1), (Object[])new Object[]{new ItemStack(this.brickID, 1, this.brickMeta)});
        }
        if (this.type != OreType.CATALYST) {
            if (MetallurgyCore.getConfigSettingBoolean("Tool Recipes", this.name, true).booleanValue()) {
                recipe = new ShapedOreRecipe(new ItemStack(this.pickaxe), new Object[]{"XXX", " S ", " S ", Character.valueOf('X'), "ingot" + this.name, Character.valueOf('S'), Item.field_77669_D});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack(this.shovel), new Object[]{"X", "S", "S", Character.valueOf('X'), "ingot" + this.name, Character.valueOf('S'), Item.field_77669_D});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack(this.axe), new Object[]{"XX", "SX", "S ", Character.valueOf('X'), "ingot" + this.name, Character.valueOf('S'), Item.field_77669_D});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack(this.hoe), new Object[]{"XX", "S ", "S ", Character.valueOf('X'), "ingot" + this.name, Character.valueOf('S'), Item.field_77669_D});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack((Item)this.sword), new Object[]{"X", "X", "S", Character.valueOf('X'), "ingot" + this.name, Character.valueOf('S'), Item.field_77669_D});
                GameRegistry.addRecipe((IRecipe)recipe);
            }
            if (MetallurgyCore.getConfigSettingBoolean("Armour Recipes", this.name, true).booleanValue()) {
                recipe = new ShapedOreRecipe(new ItemStack(this.helmet), new Object[]{"XXX", "X X", Character.valueOf('X'), "ingot" + this.name});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack(this.chest), new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "ingot" + this.name});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack(this.legs), new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "ingot" + this.name});
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe = new ShapedOreRecipe(new ItemStack(this.boots), new Object[]{"X X", "X X", Character.valueOf('X'), "ingot" + this.name});
                GameRegistry.addRecipe((IRecipe)recipe);
            }
            if (MetallurgyCore.getConfigSettingBoolean("Features", "Bucket Recipes", true).booleanValue()) {
                recipe = new ShapedOreRecipe(new ItemStack(Item.field_77788_aw), new Object[]{"X X", " X ", Character.valueOf('X'), "ingot" + this.name});
                GameRegistry.addRecipe((IRecipe)recipe);
            }
            recipe = new ShapedOreRecipe(new ItemStack((Item)Item.field_77745_be), new Object[]{"X ", " X", Character.valueOf('X'), "ingot" + this.name});
            GameRegistry.addRecipe((IRecipe)recipe);
        }
        if (this.type == OreType.ALLOY) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(this.dust, 2), (Object[])this.alloyRecipe));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.type.generates() || this.ore == null && this.type != OreType.RESPAWN) {
            return;
        }
        if (!this.spawnsInDim(world.field_73011_w.field_76574_g)) {
            return;
        }
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ + (long)this.oreID + (long)this.oreMeta ^ worldSeed;
        random.setSeed(chunkSeed);
        chunkX <<= 4;
        chunkZ <<= 4;
        WorldGenMinable worldGenMinable = new WorldGenMinable(this.oreID, this.oreMeta, this.oreCount + 1, Block.field_71981_t.field_71990_ca);
        if (world.field_73011_w.field_76574_g == -1) {
            worldGenMinable = new WorldGenMinable(this.oreID, this.oreMeta, this.oreCount + 1, Block.field_72012_bb.field_71990_ca);
        }
        if (world.field_73011_w.field_76574_g == 1) {
            worldGenMinable = new WorldGenMinable(this.oreID, this.oreMeta, this.oreCount + 1, Block.field_72082_bJ.field_71990_ca);
        }
        for (int i = 0; i < this.veinCount + 1; ++i) {
            int x = chunkX + random.nextInt(16);
            int y = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
            int z = chunkZ + random.nextInt(16);
            worldGenMinable.func_76484_a(world, random, x, y, z);
        }
    }

    @Override
    public String[] getAlloyRecipe() {
        return this.alloyRecipe;
    }

    @Override
    public ItemStack getBlock() {
        if (this.blockID != 0 && this.block != null) {
            return new ItemStack(this.blockID, 1, this.blockMeta);
        }
        return null;
    }

    @Override
    public ItemStack getBrick() {
        if (this.brickID != 0 && this.brick != null) {
            return new ItemStack(this.brickID, 1, this.brickMeta);
        }
        return null;
    }

    @Override
    public ItemStack getDrop() {
        if (this.dropName != null) {
            return MetalInfoDatabase.getItem(this.dropName);
        }
        return null;
    }

    @Override
    public int getDropAmountMax() {
        return this.dropMax;
    }

    @Override
    public int getDropAmountMin() {
        return this.dropMin;
    }

    @Override
    public ItemStack getDust() {
        if (this.dust != null) {
            return new ItemStack(this.dust);
        }
        return null;
    }

    @Override
    public ItemStack getIngot() {
        if (this.ingot != null) {
            return new ItemStack(this.ingot);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getOre() {
        if (this.oreID != 0 && this.ore != null) {
            return new ItemStack(this.oreID, 1, this.oreMeta);
        }
        return null;
    }

    @Override
    public OreType getType() {
        return this.type;
    }

    public void init() {
        if (!this.enabled) {
            return;
        }
        if (!this.type.equals((Object)OreType.RESPAWN)) {
            if (this.type.generates() && this.oreID != 0) {
                this.ore = new SubBlock(this.oreID, this.oreMeta, "Metallurgy:" + this.setName + "/" + this.name + "Ore").setUnlocalizedName(this.setName + this.oreID).setCreativeTab(this.tab);
                if (this.type == OreType.DROP) {
                    this.ore.setBlockDrops(MetalInfoDatabase.getItem(this.dropName), this.dropMin, this.dropMax);
                }
            }
            if (this.type != OreType.DROP && this.blockID != 0) {
                this.block = new SubBlock(this.blockID, this.blockMeta, "Metallurgy:" + this.setName + "/" + this.name + "Block").setUnlocalizedName(this.setName + this.blockID).setCreativeTab(this.tab);
            }
            if (this.type != OreType.DROP && this.brickID != 0) {
                this.brick = new SubBlock(this.brickID, this.brickMeta, "Metallurgy:" + this.setName + "/" + this.name + "Brick").setUnlocalizedName(this.setName + this.brickID).setCreativeTab(this.tab);
            }
            if (this.type != OreType.DROP) {
                this.dust = new ItemMetallurgy(this.itemIDs).setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Dust").func_77655_b(this.name + "Dust").func_77637_a(this.tab);
                this.ingot = new ItemMetallurgy(this.itemIDs + 1).setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Ingot").setSmeltinExperience((float)this.abstractorXP / 3.0f).func_77655_b(this.name + "Ingot").func_77637_a(this.tab);
                AbstractorRecipes.addEssence(this.ingot.field_77779_bT, 0, this.abstractorXP);
            }
            if (this.type != OreType.CATALYST && this.type != OreType.DROP) {
                this.toolEnum = EnumHelper.addToolMaterial((String)this.name, (int)this.pickLvl, (int)this.toolDura, (float)this.toolSpeed, (float)this.toolDamage, (int)this.toolEnchant);
                this.toolEnum.customCraftingMaterial = this.ingot;
                this.pickaxe = new CustomItemPickaxe(this.itemIDs + 2, this.toolEnum).func_111206_d("Metallurgy:" + this.setName + "/" + this.name + "Pick").func_77655_b(this.name + "Pick").func_77637_a(this.tab);
                this.shovel = new CustomItemSpade(this.itemIDs + 3, this.toolEnum).func_111206_d("Metallurgy:" + this.setName + "/" + this.name + "Shovel").func_77655_b(this.name + "Shovel").func_77637_a(this.tab);
                this.axe = new CustomItemAxe(this.itemIDs + 4, this.toolEnum).func_111206_d("Metallurgy:" + this.setName + "/" + this.name + "Axe").func_77655_b(this.name + "Axe").func_77637_a(this.tab);
                this.hoe = new CustomItemHoe(this.itemIDs + 5, this.toolEnum).func_111206_d("Metallurgy:" + this.setName + "/" + this.name + "Hoe").func_77655_b(this.name + "Hoe").func_77637_a(this.tab);
                this.sword = (ItemMetallurgySword)new ItemMetallurgySword(this.itemIDs + 6, this.toolEnum).setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Sword").func_77655_b(this.name + "Sword").func_77637_a(this.tab);
                EnumArmorMaterial armorEnum = EnumHelper.addArmorMaterial((String)this.name, (int)this.armorDura, (int[])new int[]{this.helmetArmor, this.chestArmor, this.legsArmor, this.bootsArmor}, (int)this.toolEnchant);
                armorEnum.customCraftingMaterial = this.ingot;
                String armorTexture = this.name;
                armorTexture = armorTexture.replaceAll("\\s", "").toLowerCase();
                this.helmet = new ItemMetallurgyArmor(this.itemIDs + 7, armorEnum, 0, 0).setTextureFile(armorTexture + "_1").setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Helmet").func_77655_b("Metallurgy:" + this.setName + "/" + this.name + "Helmet").func_77637_a(this.tab);
                this.chest = new ItemMetallurgyArmor(this.itemIDs + 8, armorEnum, 1, 1).setTextureFile(armorTexture + "_1").setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Chest").func_77655_b("Metallurgy:" + this.setName + "/" + this.name + "Chest").func_77637_a(this.tab);
                this.legs = new ItemMetallurgyArmor(this.itemIDs + 9, armorEnum, 2, 2).setTextureFile(armorTexture + "_2").setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Legs").func_77655_b("Metallurgy:" + this.setName + "/" + this.name + "Legs").func_77637_a(this.tab);
                this.boots = new ItemMetallurgyArmor(this.itemIDs + 10, armorEnum, 3, 3).setTextureFile(armorTexture + "_1").setTextureName("Metallurgy:" + this.setName + "/" + this.name + "Boots").func_77655_b("Metallurgy:" + this.setName + "/" + this.name + "Boots").func_77637_a(this.tab);
            }
        }
        if (this.type.generates()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)this);
        }
    }

    public void initConfig(Configuration config) {
        this.enabled = config.get("!Enable.Enable Metals", "Enable " + this.name, true).getBoolean(true);
        boolean setEnabled = config.get("!Enable", "Enable " + this.setName + " Set", true).getBoolean(true);
        boolean bl = this.enabled = this.enabled && setEnabled;
        if (!this.type.equals((Object)OreType.RESPAWN)) {
            String id;
            if ((this.type == OreType.ORE || this.type == OreType.CATALYST || this.type == OreType.DROP) && this.oreID != 0) {
                id = config.get("#Block IDs", this.name + " Ore", this.oreID + ":" + this.oreMeta).getString();
                this.oreID = Integer.parseInt(id.split(":")[0]);
                this.oreMeta = Integer.parseInt(id.split(":")[1]);
            }
            if (this.type != OreType.DROP && this.blockID != 0) {
                id = config.get("#Block IDs", this.name + " Block", this.blockID + ":" + this.blockMeta).getString();
                this.blockID = Integer.parseInt(id.split(":")[0]);
                this.blockMeta = Integer.parseInt(id.split(":")[1]);
            }
            if (this.type != OreType.DROP && this.brickID != 0) {
                id = config.get("#Block IDs", this.name + " Brick", this.brickID + ":" + this.brickMeta).getString();
                this.brickID = Integer.parseInt(id.split(":")[0]);
                this.brickMeta = Integer.parseInt(id.split(":")[1]);
            }
            if (this.type != OreType.DROP) {
                this.itemIDs = config.get("#Item IDs", this.name + " Item IDs (reserves 50)", this.itemIDs).getInt();
                this.abstractorXP = config.get(this.name + ".misc", "abstractor xp", this.abstractorXP).getInt();
            }
            this.blockLvl = config.get(this.name + ".misc", "Block Hardness Level", this.blockLvl).getInt();
            if (this.type != OreType.CATALYST && this.type != OreType.DROP) {
                this.pickLvl = config.get(this.name + ".Tool Info", "Pick Level", this.pickLvl).getInt();
                this.toolDura = config.get(this.name + ".Tool Info", "Durability", this.toolDura).getInt();
                this.toolDamage = config.get(this.name + ".Tool Info", "Damage", this.toolDamage).getInt();
                this.toolSpeed = config.get(this.name + ".Tool Info", "Speed", this.toolSpeed).getInt();
                this.toolEnchant = config.get(this.name + ".Tool Info", "Enchantability", this.toolEnchant).getInt();
                this.helmetArmor = config.get(this.name + ".Armor Info", "Helmet Armor", this.helmetArmor).getInt();
                this.chestArmor = config.get(this.name + ".Armor Info", "Chestplate Armor", this.chestArmor).getInt();
                this.legsArmor = config.get(this.name + ".Armor Info", "Leggings Armor", this.legsArmor).getInt();
                this.bootsArmor = config.get(this.name + ".Armor Info", "Boots Armor", this.bootsArmor).getInt();
                this.armorDura = config.get(this.name + ".Armor Info", "Durability Multiplier", this.armorDura).getInt();
            }
            if (this.type != OreType.DROP) {
                this.dungeonLootChance = config.get(this.name + ".World Gen", "Dungeon Loot Chance", this.dungeonLootChance).getInt();
                this.dungeonLootAmount = config.get(this.name + ".World Gen", "Dungeon Loot Amount", this.dungeonLootAmount).getInt();
            }
        }
        if (this.type.generates()) {
            this.veinCount = config.get(this.name + ".World Gen", "Veins Per Chunk", this.veinCount).getInt();
            this.oreCount = config.get(this.name + ".World Gen", "Vein Size", this.oreCount).getInt();
            this.minHeight = config.get(this.name + ".World Gen", "Min Height", this.minHeight).getInt();
            this.maxHeight = config.get(this.name + ".World Gen", "Max Height", this.maxHeight).getInt();
            this.veinChance = config.get(this.name + ".World Gen", "Vein Chance", this.veinChance).getInt();
            this.veinDensity = config.get(this.name + ".World Gen", "Vein Density", this.veinDensity).getInt();
            String dimCombined = "";
            if (this.diminsions.length > 0) {
                dimCombined = this.diminsions[0];
                for (int n = 1; n < this.diminsions.length; ++n) {
                    dimCombined = dimCombined + " " + this.diminsions[n];
                }
            }
            this.diminsions = config.get(this.name + ".World Gen", "Diminsions", dimCombined).getString().split(" ");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void load() {
        if (!this.enabled) {
            return;
        }
        if (!this.type.equals((Object)OreType.RESPAWN)) {
            if (this.oreID != 0) {
                MetaBlock.registerID((int)this.oreID);
            }
            if (this.brickID != 0) {
                MetaBlock.registerID((int)this.brickID);
            }
            if (this.blockID != 0) {
                MetaBlock.registerID((int)this.blockID);
            }
            this.setLevels();
            if (this.type != OreType.DROP) {
                this.addRecipes();
            } else {
                FurnaceRecipes.func_77602_a().addSmelting(this.oreID, this.oreMeta, this.getDrop(), 0.0f);
            }
            this.registerMetal();
        }
    }

    public void registerMetal() {
        if (!this.enabled) {
            return;
        }
        if (this.ore != null) {
            OreDictionary.registerOre((String)("ore" + this.name), (ItemStack)new ItemStack(this.oreID, 1, this.oreMeta));
        }
        if (this.block != null) {
            OreDictionary.registerOre((String)("block" + this.name), (ItemStack)new ItemStack(this.blockID, 1, this.blockMeta));
        }
        if (this.type != OreType.DROP) {
            OreDictionary.registerOre((String)("ingot" + this.name), (Item)this.ingot);
            OreDictionary.registerOre((String)("dust" + this.name), (Item)this.dust);
        }
    }

    public void registerNames() {
        if (this.type == OreType.RESPAWN || !this.enabled) {
            return;
        }
        if (this.type.generates() && this.ore != null) {
            LanguageRegistry.addName((Object)new ItemStack(this.oreID, 1, this.oreMeta), (String)(this.name + " Ore"));
        }
        if (this.block != null) {
            LanguageRegistry.addName((Object)new ItemStack(this.blockID, 1, this.blockMeta), (String)(this.name + " Block"));
        }
        if (this.brick != null) {
            LanguageRegistry.addName((Object)new ItemStack(this.brickID, 1, this.brickMeta), (String)(this.name + " Brick"));
        }
        if (this.type != OreType.DROP) {
            LanguageRegistry.addName((Object)this.dust, (String)(this.name + " Dust"));
            LanguageRegistry.addName((Object)this.ingot, (String)(this.name + " Ingot"));
        }
        if (this.type != OreType.CATALYST && this.type != OreType.DROP) {
            LanguageRegistry.addName((Object)this.pickaxe, (String)(this.name + " Pickaxe"));
            LanguageRegistry.addName((Object)this.shovel, (String)(this.name + " Shovel"));
            LanguageRegistry.addName((Object)this.axe, (String)(this.name + " Axe"));
            LanguageRegistry.addName((Object)this.hoe, (String)(this.name + " Hoe"));
            LanguageRegistry.addName((Object)((Object)this.sword), (String)(this.name + " Sword"));
            LanguageRegistry.addName((Object)this.helmet, (String)(this.name + " Helmet"));
            LanguageRegistry.addName((Object)this.chest, (String)(this.name + " Chestplate"));
            LanguageRegistry.addName((Object)this.legs, (String)(this.name + " Legs"));
            LanguageRegistry.addName((Object)this.boots, (String)(this.name + " Boots"));
        }
    }

    public void setLevels() {
        if (!this.enabled) {
            return;
        }
        MinecraftForge.setToolClass((Item)this.pickaxe, (String)"pickaxe", (int)this.pickLvl);
        if (this.ore != null) {
            MinecraftForge.setBlockHarvestLevel((Block)this.ore.getBlock(), (int)this.oreMeta, (String)"pickaxe", (int)this.blockLvl);
            this.ore.setHardness(2.0f).setResistance(1.0f);
        }
        if (this.block != null) {
            MinecraftForge.setBlockHarvestLevel((Block)this.block.getBlock(), (int)this.blockMeta, (String)"pickaxe", (int)this.blockLvl);
            this.block.setHardness(5.0f).setResistance(10.0f);
        }
        if (this.brick != null) {
            MinecraftForge.setBlockHarvestLevel((Block)this.brick.getBlock(), (int)this.brickMeta, (String)"pickaxe", (int)this.blockLvl);
            this.brick.setHardness(5.0f).setResistance(10.0f);
        }
    }

    private boolean spawnsInDim(int dim) {
        for (String string : this.diminsions) {
            if (string.contains("-") && !string.startsWith("-")) {
                int max;
                int min = Integer.parseInt(string.split("-")[0]);
                if (min > (max = Integer.parseInt(string.split("-")[1]))) {
                    int temp = min;
                    min = max;
                    max = temp;
                }
                if (dim < min || dim > max) continue;
                return true;
            }
            int check = Integer.parseInt(string);
            return dim == check;
        }
        return false;
    }
}

