/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core.metalsets;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;

public class MetallurgyWorldGenMinable
extends WorldGenerator {
    private final List<Integer> replaceableBlocks;
    private final int numberOfBlocks;
    private final int metadata;
    private final int minableBlockId;
    private final int density;
    private static List<Integer[]> possibleMoves = new ArrayList<Integer[]>();

    public MetallurgyWorldGenMinable(int id, int meta, int size, int density, Object ... replacableIDs) {
        this.minableBlockId = id;
        this.metadata = meta;
        this.numberOfBlocks = size;
        this.density = density;
        this.replaceableBlocks = new ArrayList<Integer>();
        for (Object i : replacableIDs) {
            this.replaceableBlocks.add((Integer)i);
        }
    }

    public boolean func_76484_a(World par1World, Random par2Random, int par3, int par4, int par5) {
        float f = par2Random.nextFloat() * (float)Math.PI;
        double d0 = (float)(par3 + 8) + MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(par3 + 8) - MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(par5 + 8) + MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(par5 + 8) - MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d4 = par4 + par2Random.nextInt(3) - 2;
        double d5 = par4 + par2Random.nextInt(3) - 2;
        for (int l = 0; l <= this.numberOfBlocks; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)this.numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.numberOfBlocks;
            double d9 = par2Random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        Block block = Block.field_71973_m[par1World.func_72798_a(k2, l2, i3)];
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        if (MetallurgyCore.spawnInAir) {
                            par1World.func_72832_d(k2, l2, i3, this.minableBlockId, this.metadata, 2);
                            continue;
                        }
                        if (block == null || block.field_71990_ca != Block.field_71981_t.field_71990_ca && !block.isGenMineableReplaceable(par1World, k2, l2, i3, Block.field_71981_t.field_71990_ca) && block.field_71990_ca != Block.field_72012_bb.field_71990_ca && block.field_71990_ca != Block.field_72082_bJ.field_71990_ca) continue;
                        par1World.func_72832_d(k2, l2, i3, this.minableBlockId, this.metadata, 2);
                    }
                }
            }
        }
        return true;
    }

    public boolean generate2(World world, Random par2Random, int x, int y, int z) {
        ArrayList<Integer[]> spawnedCoords = new ArrayList<Integer[]>();
        this.spawnOre(world, x, y, z);
        spawnedCoords.add(new Integer[]{x, y, z});
        for (int n = 1; n < this.numberOfBlocks; ++n) {
            ArrayList<Integer[]> cpm = new ArrayList<Integer[]>();
            for (Integer[] i : possibleMoves) {
                cpm.add(i);
            }
            int pickedOre = (int)(par2Random.nextFloat() * par2Random.nextFloat() * (float)spawnedCoords.size());
            pickedOre = spawnedCoords.size() - 1;
            Integer[] coords = (Integer[])spawnedCoords.get(pickedOre);
            Integer[] finalCoords = new Integer[]{coords[0], coords[1], coords[2]};
            do {
                if (cpm.size() == 0) {
                    --n;
                    spawnedCoords.remove(pickedOre);
                    break;
                }
                int pick = (int)(par2Random.nextFloat() * (float)cpm.size());
                Integer[] offset = (Integer[])cpm.get(pick);
                finalCoords = new Integer[]{coords[0] + offset[0], coords[1] + offset[1], coords[2] + offset[2]};
                cpm.remove(pick);
            } while (spawnedCoords.contains(finalCoords));
            if (par2Random.nextInt(100) < this.density) {
                this.spawnOre(world, finalCoords);
            }
            spawnedCoords.add(finalCoords);
        }
        return true;
    }

    public boolean spawnOre(World world, int x, int y, int z) {
        int currentID = world.func_72798_a(x, y, z);
        if (this.replaceableBlocks.contains(currentID)) {
            world.func_72832_d(x, y, z, this.minableBlockId, this.metadata, 2);
            return true;
        }
        return false;
    }

    public boolean spawnOre(World world, Integer[] coords) {
        return this.spawnOre(world, coords[0], coords[1], coords[2]);
    }

    static {
        possibleMoves.add(new Integer[]{1, 0, 0});
        possibleMoves.add(new Integer[]{0, 1, 0});
        possibleMoves.add(new Integer[]{0, 0, 1});
        possibleMoves.add(new Integer[]{-1, 0, 0});
        possibleMoves.add(new Integer[]{0, -1, 0});
        possibleMoves.add(new Integer[]{0, 0, -1});
        possibleMoves.add(new Integer[]{1, 1, 0});
        possibleMoves.add(new Integer[]{-1, 1, 0});
        possibleMoves.add(new Integer[]{1, -1, 0});
        possibleMoves.add(new Integer[]{-1, -1, 0});
        possibleMoves.add(new Integer[]{1, 0, 1});
        possibleMoves.add(new Integer[]{-1, 0, 1});
        possibleMoves.add(new Integer[]{1, 0, -1});
        possibleMoves.add(new Integer[]{-1, 0, -1});
        possibleMoves.add(new Integer[]{0, 1, 1});
        possibleMoves.add(new Integer[]{0, -1, 1});
        possibleMoves.add(new Integer[]{0, 1, -1});
        possibleMoves.add(new Integer[]{0, -1, -1});
    }
}

