/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import rebelkeithy.mods.keithyutils.guiregistry.GuiRegistry;
import rebelkeithy.mods.metallurgy.core.CommonProxy;
import rebelkeithy.mods.metallurgy.core.MetalInfoDatabase;
import rebelkeithy.mods.metallurgy.core.metalsets.MetalSet;

@Mod(modid="Metallurgy3Core", name="Metallurgy 3 Core", version="3.2.3", dependencies="required-after:KeithyUtils@[1.2,]")
@NetworkMod(channels={"MetallurgyCore"}, clientSideRequired=true, serverSideRequired=false)
public class MetallurgyCore {
    @SidedProxy(clientSide="rebelkeithy.mods.metallurgy.core.ClientProxy", serverSide="rebelkeithy.mods.metallurgy.core.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Metallurgy3Core")
    public static MetallurgyCore instance;
    public static boolean spawnInAir;
    public static boolean DEBUG;
    public static Configuration config;
    List<String> csvFiles;
    List<String> setsToRead;
    public static Logger log;
    private static List<MetalSet> metalSets;
    MetalSet baseSet;

    public static List<MetalSet> getMetalSetList() {
        if (metalSets == null) {
            metalSets = new ArrayList<MetalSet>();
        }
        return metalSets;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (MetalSet set : MetallurgyCore.getMetalSetList()) {
            set.load();
            proxy.registerNamesForMetalSet(set);
        }
        MetalInfoDatabase.registerItemsWithOreDict();
    }

    public void initConfig() {
        File fileDir = new File(proxy.getMinecraftDir() + "/config/Metallurgy3");
        fileDir.mkdir();
        File cfgFile = new File(proxy.getMinecraftDir() + "/config/Metallurgy3/MetallurgyCore.cfg");
        try {
            cfgFile.createNewFile();
            log.info("[Metallurgy3] Successfully created/read configuration file for Metallurgy 3 Core");
        }
        catch (IOException e) {
            log.warning("[Metallurgy3] Could not create configuration file for Metallurgy 3 Core, Reason:");
            e.printStackTrace();
        }
        config = new Configuration(cfgFile);
        config.load();
        spawnInAir = config.get("Cheats", "Spawn Ore In Air", false).getBoolean(false);
        this.csvFiles = Arrays.asList(config.get("Metal Sets", "File List", "").getString().split("\\s*,\\s*"));
        this.setsToRead = Arrays.asList(config.get("Metal Sets", "Metal Set List", "").getString().split("\\s*,\\s*"));
        log.info("reading sets " + this.setsToRead.size());
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Boolean getConfigSettingBoolean(String category, String name, Boolean defaultValue) {
        config.load();
        Property property = config.get(category, name, defaultValue.booleanValue());
        if (config.hasChanged()) {
            config.save();
        }
        return property.getBoolean(defaultValue.booleanValue());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        this.initConfig();
        for (String filename : this.csvFiles) {
            if (filename.equals("")) continue;
            MetalInfoDatabase.readMetalDataFromFile("/config/Metallurgy3/" + filename);
        }
        for (String set : this.setsToRead) {
            if (set.equals("")) continue;
            CreativeTabs tab = new CreativeTabs(set);
            new MetalSet(set, MetalInfoDatabase.getSpreadsheetDataForSet(set), tab);
        }
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)GuiRegistry.instance());
    }

    static {
        spawnInAir = false;
        DEBUG = true;
    }
}

