/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;
import rebelkeithy.mods.metallurgy.core.metalsets.ItemMetallurgy;

public class MetalInfoDatabase {
    private static List<Map<String, String>> spreadsheet;
    private static Map<String, Item> items;
    private static Map<String, String> oreDictNames;

    public static ItemStack getItem(String itemName) {
        if (items == null || !items.containsKey(itemName)) {
            return null;
        }
        return new ItemStack(items.get(itemName));
    }

    public static Map<String, Map<String, String>> getSpreadsheetDataForSet(String name) {
        HashMap<String, Map<String, String>> returnData = new HashMap<String, Map<String, String>>();
        if (spreadsheet == null) {
            return returnData;
        }
        for (Map<String, String> data : spreadsheet) {
            if (!data.get("Metal Set").equals(name)) continue;
            returnData.put(data.get("Name"), data);
        }
        return returnData;
    }

    private static void readItemData(Configuration config, BufferedReader in, CreativeTabs tab) {
        if (items == null) {
            items = new HashMap<String, Item>();
        }
        if (oreDictNames == null) {
            oreDictNames = new HashMap<String, String>();
        }
        try {
            String input = in.readLine();
            String[] header = input.split(",");
            input = in.readLine();
            while (input != null) {
                String[] inputArray = input.split(",");
                HashMap<String, String> itemMap = new HashMap<String, String>();
                for (int n = 0; n < inputArray.length; ++n) {
                    if (inputArray[n].equals("")) {
                        inputArray[n] = "0";
                    }
                    itemMap.put(header[n], inputArray[n]);
                }
                int id = Integer.parseInt((String)itemMap.get("Item ID"));
                id = config.get("Item IDs", (String)itemMap.get("Item Name"), id).getInt();
                Item item = new ItemMetallurgy(id).setTextureName("Metallurgy:" + (String)itemMap.get("Set Name") + "/" + (String)itemMap.get("Item Name")).func_77655_b("Metallurgy:" + (String)itemMap.get("Set Name") + "/" + (String)itemMap.get("Item Name")).func_77637_a(tab);
                LanguageRegistry.addName((Object)item, (String)((String)itemMap.get("Item Name")));
                items.put((String)itemMap.get("Item Name"), item);
                if (!((String)itemMap.get("Ore Dictionary Name")).equals("0")) {
                    oreDictNames.put((String)itemMap.get("Item Name"), (String)itemMap.get("Ore Dictionary Name"));
                }
                input = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readItemDataFromClassPath(Configuration config, String resourcePath, CreativeTabs tab) {
        BufferedReader in = MetalInfoDatabase.bufferedReaderFromClassPathResource(resourcePath);
        MetalInfoDatabase.readItemData(config, in, tab);
    }

    public static void readMetalDataFromFile(String filepath) {
        try {
            MetalInfoDatabase.readOreData(MetalInfoDatabase.bufferedReaderFromFile(filepath));
        }
        catch (FileNotFoundException e) {
            MetallurgyCore.log.log(Level.WARNING, String.format("User supplied file (%s) not found. Check config file.", filepath), e);
        }
    }

    public static void readMetalDataFromClassPath(String resourcePath) {
        MetalInfoDatabase.readOreData(MetalInfoDatabase.bufferedReaderFromClassPathResource(resourcePath));
    }

    private static BufferedReader bufferedReaderFromFile(String filePath) throws FileNotFoundException {
        return Files.newReader((File)new File(filePath), (Charset)Charsets.UTF_8);
    }

    private static BufferedReader bufferedReaderFromClassPathResource(String resourcePath) {
        BufferedReader in;
        URL url = Resources.getResource((String)resourcePath);
        InputSupplier readerSupplier = Resources.newReaderSupplier((URL)url, (Charset)Charsets.UTF_8);
        try {
            in = new BufferedReader((Reader)readerSupplier.getInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return in;
    }

    private static void readOreData(BufferedReader in) {
        if (spreadsheet == null) {
            spreadsheet = new ArrayList<Map<String, String>>();
        }
        try {
            String input = in.readLine();
            ArrayList header = Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)input));
            input = in.readLine();
            while (input != null) {
                ArrayList inputArray = Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)input));
                HashMap oreMap = new HashMap();
                for (int n = 0; n < inputArray.size(); ++n) {
                    String column = (String)inputArray.get(n);
                    if (column.equals("") || column.equals("-")) {
                        column = "0";
                    }
                    oreMap.put(header.get(n), column);
                }
                spreadsheet.add(oreMap);
                input = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerItemsWithOreDict() {
        for (String name : oreDictNames.keySet()) {
            OreDictionary.registerOre((String)oreDictNames.get(name), (Item)items.get(name));
        }
    }
}

