/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core;

import java.util.ArrayList;
import java.util.List;

public class Coord {
    public static final List<Coord> adjacent = new ArrayList<Coord>();
    public int x;
    public int y;
    public int z;

    public static List<Coord> between(Coord c1, Coord c2) {
        ArrayList<Coord> between = new ArrayList<Coord>();
        for (int x = Math.min(c1.x, c2.x); x <= Math.max(c1.x, c2.x); ++x) {
            for (int y = Math.min(c1.y, c2.y); y <= Math.max(c1.y, c2.y); ++y) {
                for (int z = Math.min(c1.z, c2.z); z <= Math.max(c1.z, c2.z); ++z) {
                    between.add(new Coord(x, y, z));
                }
            }
        }
        return between;
    }

    public static List<Coord> getAdjacentCoords(Coord c) {
        ArrayList<Coord> newAdjacent = new ArrayList<Coord>();
        for (Coord a : adjacent) {
            newAdjacent.add(a.add(c));
        }
        return newAdjacent;
    }

    public Coord(Coord coord) {
        this.x = coord.x;
        this.y = coord.y;
        this.z = coord.z;
    }

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private Coord add(Coord c) {
        return new Coord(this.x + c.x, this.y + c.y, this.z + c.z);
    }

    public Coord clone() {
        return new Coord(this);
    }

    public boolean equals(int x2, int y2, int z2) {
        return this.x == x2 && this.y == y2 && this.z == z2;
    }

    public boolean equals(Object o) {
        Coord coord = (Coord)o;
        return this.x == coord.x && this.y == coord.y && this.z == coord.z;
    }

    public Coord subtract(Coord c) {
        return new Coord(this.x - c.x, this.y - c.y, this.z - c.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    static {
        adjacent.add(new Coord(-1, 0, 0));
        adjacent.add(new Coord(1, 0, 0));
        adjacent.add(new Coord(0, -1, 0));
        adjacent.add(new Coord(0, 1, 0));
        adjacent.add(new Coord(0, 0, -1));
        adjacent.add(new Coord(0, 0, 1));
    }
}

