/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.forge;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rebelkeithy.mods.keithyutils.guiregistry.GuiRegistry;
import rebelkeithy.mods.metallurgy.machines.ConfigMachines;
import rebelkeithy.mods.metallurgy.machines.MetallurgyMachines;
import rebelkeithy.mods.metallurgy.machines.forge.TileEntityNetherForge;

public class BlockNetherForge
extends BlockContainer {
    private final Random furnaceRand = new Random();
    private static int front = 0;
    private static int side = 5;
    private static int active = 10;
    private static int top = 15;
    private static int bottom = 17;
    private Map<Integer, Icon[]> iconMap;
    private static boolean keepFurnaceInventory = false;

    public static void updateFurnaceBlockState(boolean par0, World par1World, int par2, int par3, int par4) {
        int metadata = par1World.func_72805_g(par2, par3, par4);
        keepFurnaceInventory = true;
        if (par0 && metadata < 8) {
            par1World.func_72921_c(par2, par3, par4, metadata + 8, 2);
        } else if (!par0 && metadata >= 8) {
            par1World.func_72921_c(par2, par3, par4, metadata - 8, 2);
        }
        keepFurnaceInventory = false;
    }

    public BlockNetherForge(int par1, boolean par2) {
        super(par1, Material.field_76246_e);
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        TileEntityNetherForge var5;
        boolean spawnLava = false;
        if (((TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)).getFuelScaled(2) > 0) {
            spawnLava = true;
        }
        if (!keepFurnaceInventory && (var5 = (TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)) != null) {
            for (int var6 = 0; var6 < var5.func_70302_i_(); ++var6) {
                ItemStack var7 = var5.func_70301_a(var6);
                if (var7 == null) continue;
                float var8 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float var9 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float var10 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (var7.field_77994_a > 0) {
                    int var11 = this.furnaceRand.nextInt(21) + 10;
                    if (var11 > var7.field_77994_a) {
                        var11 = var7.field_77994_a;
                    }
                    var7.field_77994_a -= var11;
                    EntityItem var12 = new EntityItem(par1World, (double)((float)par2 + var8), (double)((float)par3 + var9), (double)((float)par4 + var10), new ItemStack(var7.field_77993_c, var11, var7.func_77960_j()));
                    if (var7.func_77942_o()) {
                        var12.func_92059_d().func_77982_d((NBTTagCompound)var7.func_77978_p().func_74737_b());
                    }
                    float var13 = 0.05f;
                    var12.field_70159_w = (float)this.furnaceRand.nextGaussian() * 0.05f;
                    var12.field_70181_x = (float)this.furnaceRand.nextGaussian() * 0.05f + 0.2f;
                    var12.field_70179_y = (float)this.furnaceRand.nextGaussian() * 0.05f;
                    par1World.func_72838_d((Entity)var12);
                }
            }
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
        if (ConfigMachines.smelterDropsLava && spawnLava) {
            par1World.func_72832_d(par2, par3, par4, Block.field_71944_C.field_71990_ca, 0, 2);
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityNetherForge();
    }

    public int func_71899_b(int metadata) {
        return metadata < 8 ? metadata : metadata - 8;
    }

    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        boolean isBurning;
        TileEntity tileEntity = par1IBlockAccess.func_72796_p(par2, par3, par4);
        int metadata = par1IBlockAccess.func_72805_g(par2, par3, par4);
        int dir = tileEntity instanceof TileEntityNetherForge ? ((TileEntityNetherForge)tileEntity).getDirection() : 0;
        int fuel = tileEntity instanceof TileEntityNetherForge ? ((TileEntityNetherForge)tileEntity).getScaledFuel(4) : 0;
        boolean bl = isBurning = tileEntity instanceof TileEntityNetherForge ? ((TileEntityNetherForge)tileEntity).isBurning() : false;
        if (fuel == 0) {
            isBurning = false;
        }
        return this.getNetherForgeTexture(par5, metadata, dir, fuel, isBurning);
    }

    public Icon func_71858_a(int par1, int par2) {
        return this.getNetherForgeTexture(par1, par2, 3, 0, false);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        try {
            TileEntityNetherForge var6 = (TileEntityNetherForge)world.func_72796_p(x, y, z);
            if (var6 != null && var6.isBurning()) {
                return 12;
            }
        }
        catch (ClassCastException e) {
            return 0;
        }
        return 0;
    }

    public Icon getNetherForgeTexture(int side, int meta, int facing, int fuel, boolean isActive) {
        if (side == 1) {
            return this.iconMap.get(meta)[top];
        }
        if (side == 0) {
            return this.iconMap.get(meta)[bottom];
        }
        if (side != facing) {
            return this.iconMap.get(meta)[BlockNetherForge.side + fuel];
        }
        if (isActive) {
            return this.iconMap.get(meta)[active + fuel];
        }
        return this.iconMap.get(meta)[front + fuel];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int n = 0; n < 8; ++n) {
            par3List.add(new ItemStack((Block)this, 1, n));
        }
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return ConfigMachines.forgeID;
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        if (par5EntityPlayer.func_70093_af()) {
            return false;
        }
        ItemStack currentItem = par5EntityPlayer.field_71071_by.func_70448_g();
        TileEntityNetherForge var6 = (TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4);
        par5EntityPlayer.func_71035_c("Fuel: " + var6.fuel);
        par5EntityPlayer.func_71035_c("MaxFuel: " + var6.maxFuel);
        if (currentItem != null) {
            if (currentItem.field_77993_c == Item.field_77775_ay.field_77779_bT) {
                if (var6.fuel == var6.maxFuel) {
                    return false;
                }
                var6.addFuelBucket();
                if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                    if (currentItem.field_77994_a-- == 1) {
                        par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, new ItemStack(Item.field_77788_aw));
                    } else if (!par5EntityPlayer.field_71071_by.func_70441_a(new ItemStack(Item.field_77788_aw))) {
                        par5EntityPlayer.func_71021_b(new ItemStack(Item.field_77788_aw.field_77779_bT, 1, 0));
                    }
                    if (par5EntityPlayer instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)par5EntityPlayer).func_71120_a(par5EntityPlayer.field_71069_bz);
                    }
                }
                return true;
            }
            if (currentItem.field_77993_c == Item.field_77788_aw.field_77779_bT) {
                if (var6.fuel < 1000) {
                    return false;
                }
                var6.removeFuelBucket();
                if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                    if (currentItem.field_77994_a-- == 1) {
                        par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, new ItemStack(Item.field_77775_ay));
                    } else if (!par5EntityPlayer.field_71071_by.func_70441_a(new ItemStack(Item.field_77775_ay))) {
                        par5EntityPlayer.func_71021_b(new ItemStack(Item.field_77775_ay.field_77779_bT, 1, 0));
                    }
                    if (par5EntityPlayer instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)par5EntityPlayer).func_71120_a(par5EntityPlayer.field_71069_bz);
                    }
                }
                return true;
            }
        }
        if (var6 != null) {
            GuiRegistry.openGui((String)"NetherForge", (Object)MetallurgyMachines.instance, (EntityPlayer)par5EntityPlayer, (World)par1World, (int)par2, (int)par3, (int)par4);
        }
        return true;
    }

    public void func_71921_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int var6 = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (var6 == 0) {
            ((TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)).setDirection(2);
        }
        if (var6 == 1) {
            ((TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)).setDirection(5);
        }
        if (var6 == 2) {
            ((TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)).setDirection(3);
        }
        if (var6 == 3) {
            ((TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)).setDirection(4);
        }
        TileEntityNetherForge var5 = (TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4);
        int metadata = par1World.func_72805_g(par2, par3, par4);
        var5.setSpeed((int)(20.0f * ConfigMachines.forgeSpeeds[metadata]));
        var5.setMaxBuckets(ConfigMachines.forgeBuckets[metadata]);
    }

    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        par1World.func_72805_g(par2, par3, par4);
        TileEntityNetherForge tef = (TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4);
        if (tef.isBurning()) {
            int var6 = ((TileEntityNetherForge)par1World.func_72796_p(par2, par3, par4)).getDirection();
            float var7 = (float)par2 + 0.5f;
            float var8 = (float)par3 + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
            float var9 = (float)par4 + 0.5f;
            float var10 = 0.52f;
            float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
            if (var6 == 4) {
                par1World.func_72869_a("smoke", (double)(var7 - 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 - 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
            } else if (var6 == 5) {
                par1World.func_72869_a("smoke", (double)(var7 + 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 + 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
            } else if (var6 == 2) {
                par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - 0.52f), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - 0.52f), 0.0, 0.0, 0.0);
            } else if (var6 == 3) {
                par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + 0.52f), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + 0.52f), 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconMap = new HashMap<Integer, Icon[]>();
        for (int i = 0; i < 8; ++i) {
            Icon[] iArray = new Icon[18];
            for (int j = 0; j < 5; ++j) {
                iArray[BlockNetherForge.front + j] = par1IconRegister.func_94245_a("Metallurgy:machines/smelter/Smelter" + i + "Front" + j);
                iArray[BlockNetherForge.side + j] = par1IconRegister.func_94245_a("Metallurgy:machines/smelter/Smelter" + i + "Side" + j);
                if (j <= 0) continue;
                iArray[BlockNetherForge.active + j] = par1IconRegister.func_94245_a("Metallurgy:machines/smelter/Smelter" + i + "Active" + j);
            }
            iArray[BlockNetherForge.top] = par1IconRegister.func_94245_a("Metallurgy:machines/smelter/Smelter" + i + "Top0");
            iArray[BlockNetherForge.top + 1] = par1IconRegister.func_94245_a("Metallurgy:machines/smelter/Smelter" + i + "Top1");
            iArray[BlockNetherForge.bottom] = par1IconRegister.func_94245_a("Metallurgy:machines/smelter/Smelter" + i + "Bottom");
            this.iconMap.put(i, iArray);
        }
    }
}

