/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.block;

import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.tile.TileEntityConductor;

public abstract class BlockConductor
extends BlockContainer {
    public boolean isWireCollision = true;
    public Vector3 minVector = new Vector3(0.3, 0.3, 0.3);
    public Vector3 maxVector = new Vector3(0.7, 0.7, 0.7);

    public BlockConductor(int id, Material material) {
        super(id, material);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IConductor) {
            ((IConductor)tileEntity).refresh();
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IConductor) {
            ((IConductor)tileEntity).refresh();
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71911_a_(world, x, y, z);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntity[] connectable;
        TileEntity tileEntity;
        if (this.isWireCollision && (tileEntity = world.func_72796_p(x, y, z)) instanceof TileEntityConductor && (connectable = ((TileEntityConductor)tileEntity).getAdjacentConnections()) != null) {
            float minX = (float)this.minVector.x;
            float minY = (float)this.minVector.y;
            float minZ = (float)this.minVector.z;
            float maxX = (float)this.maxVector.x;
            float maxY = (float)this.maxVector.y;
            float maxZ = (float)this.maxVector.z;
            if (connectable[0] != null) {
                minY = 0.0f;
            }
            if (connectable[1] != null) {
                maxY = 1.0f;
            }
            if (connectable[2] != null) {
                minZ = 0.0f;
            }
            if (connectable[3] != null) {
                maxZ = 1.0f;
            }
            if (connectable[4] != null) {
                minX = 0.0f;
            }
            if (connectable[5] != null) {
                maxX = 1.0f;
            }
            this.func_71905_a(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List list, Entity entity) {
        if (this.isWireCollision) {
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            if (tileEntity instanceof TileEntityConductor) {
                TileEntity[] connectable = ((TileEntityConductor)tileEntity).getAdjacentConnections();
                this.func_71905_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                if (connectable[4] != null) {
                    this.func_71905_a(0.0f, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                    super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                }
                if (connectable[5] != null) {
                    this.func_71905_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, 1.0f, (float)this.maxVector.y, (float)this.maxVector.z);
                    super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                }
                if (connectable[0] != null) {
                    this.func_71905_a((float)this.minVector.x, 0.0f, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                    super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                }
                if (connectable[1] != null) {
                    this.func_71905_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, 1.0f, (float)this.maxVector.z);
                    super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                }
                if (connectable[2] != null) {
                    this.func_71905_a((float)this.minVector.x, (float)this.minVector.y, 0.0f, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                    super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                }
                if (connectable[3] != null) {
                    this.func_71905_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, 1.0f);
                    super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
                }
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            super.func_71871_a(world, x, y, z, axisalignedbb, list, entity);
        }
    }
}

