/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricalEvent;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class ElectricityHelper {
    @ForgeSubscribe
    public void onProduce(ElectricalEvent.ElectricityProduceEvent evt) {
        Vector3 position = new Vector3((TileEntity)evt.tileEntity);
        HashMap<IElectricityNetwork, ForgeDirection> networks = new HashMap<IElectricityNetwork, ForgeDirection>();
        for (ForgeDirection direction : ElectricityHelper.getDirections((TileEntity)evt.tileEntity)) {
            IElectricityNetwork network = ElectricityHelper.getNetworkFromTileEntity(VectorHelper.getTileEntityFromSide(evt.world, position, direction), direction.getOpposite());
            if (network == null) continue;
            networks.put(network, direction);
            ElectricityPack provided = evt.tileEntity.provideElectricity(direction, network.getRequest((TileEntity)evt.tileEntity), true);
            if (provided == null || !(provided.getWatts() > 0.0f)) continue;
            network.produce(provided, (TileEntity)evt.tileEntity);
        }
    }

    public static EnumSet<ForgeDirection> getDirections(TileEntity tileEntity) {
        EnumSet<ForgeDirection> possibleSides = EnumSet.noneOf(ForgeDirection.class);
        if (tileEntity instanceof IConnector) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                if (!((IConnector)tileEntity).canConnect(direction)) continue;
                possibleSides.add(direction);
            }
        }
        return possibleSides;
    }

    @Deprecated
    public static ElectricityPack produceFromMultipleSides(TileEntity tileEntity, ElectricityPack electricityPack) {
        return ElectricityHelper.produceFromMultipleSides(tileEntity, ElectricityHelper.getDirections(tileEntity), electricityPack);
    }

    @Deprecated
    public static ElectricityPack produceFromMultipleSides(TileEntity tileEntity, EnumSet<ForgeDirection> approachingDirection, ElectricityPack producingPack) {
        Set<IElectricityNetwork> connectedNetworks;
        ElectricityPack remainingElectricity = producingPack.clone();
        if (tileEntity != null && approachingDirection != null && (connectedNetworks = ElectricityHelper.getNetworksFromMultipleSides(tileEntity, approachingDirection)).size() > 0) {
            float wattsPerSide = producingPack.getWatts() / (float)connectedNetworks.size();
            float voltage = producingPack.voltage;
            for (IElectricityNetwork network : connectedNetworks) {
                if (!(wattsPerSide > 0.0f) || !(producingPack.getWatts() > 0.0f)) continue;
                TileEntity[] tileEntityArray = new TileEntity[]{tileEntity};
                float amperes = Math.min(wattsPerSide / voltage, network.getRequest(tileEntityArray).getWatts() / voltage);
                if (!(amperes > 0.0f)) continue;
                network.produce(new ElectricityPack(amperes, voltage), new TileEntity[0]);
                remainingElectricity.amperes -= amperes;
            }
        }
        return remainingElectricity;
    }

    public static Set<IElectricityNetwork> getNetworksFromMultipleSides(TileEntity tileEntity, EnumSet<ForgeDirection> approachingDirection) {
        HashSet<IElectricityNetwork> connectedNetworks = new HashSet<IElectricityNetwork>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!approachingDirection.contains(side)) continue;
            Vector3 position = new Vector3(tileEntity);
            position.modifyPositionFromSide(side);
            TileEntity outputConductor = position.getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            IElectricityNetwork electricityNetwork = ElectricityHelper.getNetworkFromTileEntity(outputConductor, side);
            if (electricityNetwork == null) continue;
            connectedNetworks.add(electricityNetwork);
        }
        return connectedNetworks;
    }

    public static IElectricityNetwork getNetworkFromTileEntity(TileEntity tileEntity, ForgeDirection approachDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider) {
            if (tileEntity instanceof IConnector) {
                if (((IConnector)tileEntity).canConnect(approachDirection.getOpposite())) {
                    return ((INetworkProvider)tileEntity).getNetwork();
                }
            } else {
                return ((INetworkProvider)tileEntity).getNetwork();
            }
        }
        return null;
    }
}

