/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityUniversalElectrical
extends TileEntityElectrical
implements IEnergySink,
IEnergySource,
IPowerReceptor {
    protected boolean isAddedToEnergyNet;
    public PowerHandler bcPowerHandler;
    public PowerHandler.Type bcBlockType = PowerHandler.Type.MACHINE;

    @Override
    public void initiate() {
        super.initiate();
        this.initBuildCraft();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && !this.isAddedToEnergyNet) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this.isAddedToEnergyNet = true;
        }
        this.produce();
    }

    @Override
    public void produce() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection outputDirection : this.getOutputDirections()) {
                this.produceUE(outputDirection);
                this.produceIC2(outputDirection);
                this.produceBuildCraft(outputDirection);
            }
        }
        if (Compatibility.isBuildcraftLoaded()) {
            this.receiveElectricity(this.bcPowerHandler.getEnergyStored(), true);
            this.bcPowerHandler.setEnergy(0.0f);
        }
    }

    public void produceIC2(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f && Compatibility.isIndustrialCraft2Loaded()) {
                int ic2Provide = (int)Math.ceil(provide * Compatibility.TO_IC2_RATIO);
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, ic2Provide);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.setEnergyStored(this.getEnergyStored() - ((float)ic2Provide * Compatibility.IC2_RATIO - (float)event.amount * Compatibility.IC2_RATIO));
            }
        }
    }

    public void produceBuildCraft(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            PowerHandler.PowerReceiver receiver;
            TileEntity tileEntity;
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f && Compatibility.isBuildcraftLoaded() && (tileEntity = new Vector3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IPowerReceptor && (receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(outputDirection.getOpposite())) != null) {
                float bc3Provide = provide * Compatibility.TO_BC_RATIO;
                float energyUsed = Math.min(receiver.receiveEnergy(this.bcBlockType, bc3Provide, outputDirection.getOpposite()), bc3Provide);
                this.setEnergyStored(this.getEnergyStored() - (bc3Provide - energyUsed * Compatibility.TO_BC_RATIO));
            }
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return this.canConnect(direction.toForgeDirection());
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_70331_k != null) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Override
    public int demandsEnergy() {
        return (int)Math.ceil(this.getRequest(ForgeDirection.UNKNOWN) * Compatibility.TO_IC2_RATIO);
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (this.getInputDirections().contains(directionFrom.toForgeDirection())) {
            float convertedEnergy = (float)amount * Compatibility.IC2_RATIO;
            ElectricityPack toSend = ElectricityPack.getFromWatts(convertedEnergy, this.getVoltage());
            float receive = this.receiveElectricity(directionFrom.toForgeDirection(), toSend, true);
            return Math.round((float)amount - receive * Compatibility.TO_IC2_RATIO);
        }
        return amount;
    }

    @Override
    public int getMaxEnergyOutput() {
        return (int)Math.ceil(this.getProvide(ForgeDirection.UNKNOWN));
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return receiver instanceof IEnergyTile && direction.toForgeDirection().equals(this.getOutputDirections());
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public void initBuildCraft() {
        if (this.bcPowerHandler == null) {
            this.bcPowerHandler = new PowerHandler(this, this.bcBlockType);
            this.bcPowerHandler.configure(0.0f, 100.0f, 0.0f, (int)Math.ceil(this.getMaxEnergyStored() * Compatibility.BC3_RATIO));
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        this.initBuildCraft();
        return this.bcPowerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.func_70314_l();
    }
}

