/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.item.ItemElectric;

public abstract class ItemUniversalElectric
extends ItemElectric
implements ISpecialElectricItem,
IChargeableItem {
    public static final float CHARGE_RATE = 0.005f;

    public ItemUniversalElectric(int id) {
        super(id);
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) * Compatibility.TO_IC2_RATIO);
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) * 0.005f * Compatibility.TO_IC2_RATIO);
    }

    @Override
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ElectricItemManager.MANAGER;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.recharge(itemStack, 1.0f, false) > 0.0f;
    }

    @Override
    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        return this.recharge(theItem, energy * Compatibility.BC3_RATIO, doReceive) * Compatibility.TO_BC_RATIO;
    }

    @Override
    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        return this.discharge(theItem, energy * Compatibility.BC3_RATIO, doTransfer) * Compatibility.TO_BC_RATIO;
    }

    @Override
    public float getEnergyStored(ItemStack theItem) {
        return this.getElectricityStored(theItem) * Compatibility.TO_BC_RATIO;
    }

    @Override
    public float getMaxEnergyStored(ItemStack theItem) {
        return this.getMaxElectricityStored(theItem) * Compatibility.TO_BC_RATIO;
    }

    public static class IC2ElectricItemManager
    implements IElectricItemManager {
        public static final IElectricItemManager MANAGER = new IC2ElectricItemManager();

        private IItemElectric getElectricItem(ItemStack itemStack) {
            if (itemStack.func_77973_b() instanceof IItemElectric) {
                return (IItemElectric)itemStack.func_77973_b();
            }
            return null;
        }

        @Override
        public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
            float inputElectricity = (float)amount * Compatibility.IC2_RATIO;
            return (int)(this.getElectricItem(itemStack).recharge(itemStack, inputElectricity, !simulate) * Compatibility.TO_IC2_RATIO);
        }

        @Override
        public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
            float outputElectricity = (float)amount * Compatibility.IC2_RATIO;
            return (int)(this.getElectricItem(itemStack).discharge(itemStack, outputElectricity, !simulate) * Compatibility.TO_IC2_RATIO);
        }

        @Override
        public boolean canUse(ItemStack itemStack, int amount) {
            return false;
        }

        @Override
        public int getCharge(ItemStack itemStack) {
            return 0;
        }

        @Override
        public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
            return false;
        }

        @Override
        public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        }

        @Override
        public String getToolTip(ItemStack itemStack) {
            return null;
        }
    }
}

