/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.compatibility.TileEntityUniversalElectrical;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntitySolar
extends TileEntityUniversalElectrical
implements IMultiBlock,
IPacketReceiver,
IDisableableMachine,
IInventory,
ISidedInventory {
    public HashSet<TileEntity> connectedTiles = new HashSet();
    public Vector3 mainBlockPosition;
    public int solarStrength = 0;
    public float targetAngle;
    public float currentAngle;
    public boolean disabled = true;
    public int disableCooldown = 0;
    private ItemStack[] containingItems = new ItemStack[1];
    public static final float MAX_GENERATE_WATTS = 15.0f;
    public float generateWatts = 0.0f;
    private float ueMaxEnergy;

    public GCCoreTileEntitySolar() {
        this(0.0f);
    }

    public GCCoreTileEntitySolar(float maxEnergy) {
        this.ueMaxEnergy = maxEnergy;
    }

    public void setMainBlock(Vector3 mainBlock) {
        this.mainBlockPosition = mainBlock;
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void func_70316_g() {
        this.setEnergyStored(this.getEnergyStored() + this.generateWatts);
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            this.recharge(this.containingItems[0]);
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if (!this.getDisabled() && this.ticks % 20L == 0L) {
                this.solarStrength = 0;
                if (this.field_70331_k.func_72935_r() && (this.field_70331_k.field_73011_w instanceof IGalacticraftWorldProvider || !this.field_70331_k.func_72896_J() && !this.field_70331_k.func_72911_I())) {
                    double distance = 100.0;
                    double sinA = -Math.sin(((double)this.currentAngle - 77.5) * Math.PI / 180.0);
                    double cosA = Math.abs(Math.cos(((double)this.currentAngle - 77.5) * Math.PI / 180.0));
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            boolean valid;
                            if (this.func_70322_n() < 4) {
                                if (!this.field_70331_k.func_72937_j(this.field_70329_l + x, this.field_70330_m + 2, this.field_70327_n + z)) continue;
                                valid = true;
                                for (int y = this.field_70330_m + 3; y < 256; ++y) {
                                    int blockID = this.field_70331_k.func_72798_a(this.field_70329_l + x, y, this.field_70327_n + z);
                                    if (blockID == 0 || !Block.field_71973_m[blockID].func_71926_d()) continue;
                                    valid = false;
                                    break;
                                }
                                if (!valid) continue;
                                ++this.solarStrength;
                                continue;
                            }
                            valid = true;
                            for (double d = 0.0; d < distance; d += 1.0) {
                                Vector3 thisVec = new Vector3(this);
                                Vector3 blockAt = thisVec.clone().add(new Vector3(x, 3.0, z)).clone().add(new Vector3(d * sinA, d * cosA, 0.0));
                                int blockID = blockAt.getBlockID((IBlockAccess)this.field_70331_k);
                                if (blockID == 0 || !Block.field_71973_m[blockID].func_71926_d()) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            ++this.solarStrength;
                        }
                    }
                }
            }
        }
        float angle = this.field_70331_k.func_72826_c(1.0f) - 0.7845194f < 0.0f ? 0.21548063f : -0.7845194f;
        float celestialAngle = (this.field_70331_k.func_72826_c(1.0f) + angle) * 360.0f;
        celestialAngle %= 360.0f;
        if (this.func_70322_n() >= 4) {
            if (celestialAngle > 30.0f && celestialAngle < 150.0f) {
                float difference = this.targetAngle - celestialAngle;
                this.targetAngle -= difference / 20.0f;
            } else if (!this.field_70331_k.func_72935_r() || this.field_70331_k.func_72896_J() || this.field_70331_k.func_72911_I()) {
                this.targetAngle = 257.5f;
            } else if (celestialAngle < 50.0f) {
                this.targetAngle = 50.0f;
            } else if (celestialAngle > 150.0f) {
                this.targetAngle = 150.0f;
            }
        } else {
            this.targetAngle = !this.field_70331_k.func_72935_r() || this.field_70331_k.func_72896_J() || this.field_70331_k.func_72911_I() ? 257.5f : 77.5f;
        }
        float difference = this.targetAngle - this.currentAngle;
        this.currentAngle += difference / 20.0f;
        if (!this.field_70331_k.field_72995_K) {
            this.generateWatts = this.getGenerate() > 0.0f ? Math.min(Math.max(this.getGenerate(), 0.0f), 15.0f) / 20.0f : 0.0f;
        }
        if (this.ticks % 3L == 0L) {
            PacketManager.sendPacketToClients(this.func_70319_e(), this.field_70331_k, new Vector3(this), 50.0);
        }
    }

    public float getGenerate() {
        if (this.getDisabled()) {
            return 0.0f;
        }
        float angle = this.field_70331_k.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
        float celestialAngle = (this.field_70331_k.func_72826_c(1.0f) + angle) * 360.0f;
        float difference = (180.0f - Math.abs(this.currentAngle % 180.0f - (celestialAngle %= 360.0f))) / 180.0f;
        return 0.001f * difference * difference * ((float)this.solarStrength * (Math.abs(difference) * 500.0f)) * this.getSolarBoost();
    }

    public float getSolarBoost() {
        return (float)(this.field_70331_k.field_73011_w instanceof ISolarLevel ? ((ISolarLevel)this.field_70331_k.field_73011_w).getSolarEnergyMultiplier() : 1.0);
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            this.mainBlockPosition = new Vector3(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.solarStrength = dataStream.readInt();
            this.generateWatts = dataStream.readFloat();
            this.disableCooldown = dataStream.readInt();
            this.disabled = dataStream.readBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet func_70319_e() {
        return PacketManager.getPacket("GCCoreEntities", this, new Object[]{this.mainBlockPosition != null ? this.mainBlockPosition.intX() : 0, this.mainBlockPosition != null ? this.mainBlockPosition.intY() : 0, this.mainBlockPosition != null ? this.mainBlockPosition.intZ() : 0, this.solarStrength, Float.valueOf(this.generateWatts), this.disableCooldown, this.disabled});
    }

    public void onBlockRemoval() {
        IMultiBlock mainBlock;
        TileEntity tileEntity;
        if (this.mainBlockPosition != null && (tileEntity = this.field_70331_k.func_72796_p(this.mainBlockPosition.intX(), this.mainBlockPosition.intY(), this.mainBlockPosition.intZ())) != null && tileEntity instanceof IMultiBlock && (mainBlock = (IMultiBlock)tileEntity) != null) {
            mainBlock.onDestroy(this);
        }
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        return this.func_70311_o().func_71903_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, entityPlayer, 0, (float)this.field_70329_l, (float)this.field_70330_m, (float)this.field_70327_n);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void onCreate(Vector3 placedPosition) {
        this.mainBlockPosition = placedPosition;
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    Vector3 vecToAdd = Vector3.add(placedPosition, new Vector3(y == 2 ? (double)x : 0.0, y, y == 2 ? (double)z : 0.0));
                    if (vecToAdd.equals(placedPosition)) continue;
                    GCCoreBlocks.dummyBlock.makeFakeBlock(this.field_70331_k, vecToAdd, placedPosition, 4);
                }
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        Vector3 thisBlock = new Vector3(this);
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (this.field_70331_k.field_72995_K && this.field_70331_k.field_73012_v.nextDouble() < 0.1) {
                        FMLClientHandler.instance().getClient().field_71452_i.func_78871_a(thisBlock.intX() + (y == 2 ? x : 0), thisBlock.intY() + y, thisBlock.intZ() + (y == 2 ? z : 0), GCCoreBlocks.solarPanel.field_71990_ca & 0xFFF, GCCoreBlocks.solarPanel.field_71990_ca >> 12 & 0xFF);
                    }
                    this.field_70331_k.func_72832_d(thisBlock.intX() + (y == 2 ? x : 0), thisBlock.intY() + y, thisBlock.intZ() + (y == 2 ? z : 0), 0, 0, 3);
                }
            }
        }
        this.field_70331_k.func_72832_d(thisBlock.intX(), thisBlock.intY(), thisBlock.intZ(), 0, 0, 3);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.mainBlockPosition = Vector3.readFromNBT(nbt.func_74775_l("mainBlockPosition"));
        this.ueMaxEnergy = nbt.func_74760_g("maxEnergy");
        if (this.ueMaxEnergy > 1000.0f) {
            this.ueMaxEnergy /= 1000.0f;
        }
        this.currentAngle = nbt.func_74760_g("currentAngle");
        this.targetAngle = nbt.func_74760_g("targetAngle");
        this.setDisabled(nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.mainBlockPosition != null) {
            nbt.func_74766_a("mainBlockPosition", this.mainBlockPosition.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStored());
        nbt.func_74776_a("currentAngle", this.currentAngle);
        nbt.func_74776_a("targetAngle", this.targetAngle);
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled());
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return this.getOutputDirections().contains(direction) ? Math.min(Math.max(this.getEnergyStored(), 0.0f), 1300.0f) : 0.0f;
    }

    @Override
    public EnumSet<ForgeDirection> getInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getOutputDirections() {
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (metadata >= 4) {
            metadata -= 4;
        }
        return EnumSet.of(ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite(), ForgeDirection.UNKNOWN);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public boolean func_94042_c() {
        return true;
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization(this.func_70322_n() < 4 ? "container.solarbasic.name" : "container.solaradvanced.name");
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStored() * (float)i / this.getMaxEnergyStored());
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 ? itemstack.func_77973_b() instanceof IItemElectric : false;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.ueMaxEnergy;
    }
}

