/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import mekanism.api.EnumGas;
import mekanism.api.GasNetwork;
import mekanism.api.IPressurizedTube;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntityOxygenPipe
extends TileEntity
implements ITubeConnection,
IPressurizedTube,
IColorable,
IPacketReceiver {
    private byte pipeColor = (byte)15;
    private byte preLoadColor;
    private byte preColorCooldown;
    private boolean setColor = false;
    public GasNetwork gasNetwork;

    @Override
    public boolean canTransferGas() {
        return true;
    }

    @Override
    public boolean canTransferGasToTube(TileEntity tile) {
        if (tile instanceof IColorable) {
            return this.getColor() == ((IColorable)tile).getColor();
        }
        return true;
    }

    public boolean canUpdate() {
        return !this.setColor;
    }

    @Override
    public GasNetwork getNetwork() {
        if (this.gasNetwork == null) {
            this.gasNetwork = new GasNetwork(this);
        }
        return this.gasNetwork;
    }

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    @Override
    public void setNetwork(GasNetwork network) {
        this.gasNetwork = network;
    }

    @Override
    public void refreshNetwork() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.canTransferGas()) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                    if (!(tileEntity instanceof IPressurizedTube)) continue;
                    if (((IPressurizedTube)tileEntity).canTransferGasToTube(this) && this.canTransferGasToTube(tileEntity)) {
                        this.getNetwork().merge(((IPressurizedTube)tileEntity).getNetwork());
                        continue;
                    }
                    ((IPressurizedTube)tileEntity).getNetwork().split(this);
                    this.getNetwork().split((IPressurizedTube)tileEntity);
                }
                this.getNetwork().refresh();
            } else {
                this.getNetwork().split(this);
            }
        }
    }

    public void func_70316_g() {
        if (this.preColorCooldown > 0) {
            this.preColorCooldown = (byte)(this.preColorCooldown - 1);
        }
        if (this.preColorCooldown == 0 && !this.field_70331_k.field_72995_K && this.preLoadColor != -1) {
            PacketManager.sendPacketToClients(PacketManager.getPacket("GCCoreEntities", this, new Object[]{this.getColor(), this.preLoadColor}));
            this.preLoadColor = (byte)-1;
            this.setColor = true;
        }
        if (this.preColorCooldown == 0 && this.field_70331_k.field_72995_K && this.preLoadColor == 0) {
            Vector3 thisVec = new Vector3(this);
            this.field_70331_k.func_72902_n(thisVec.intX(), thisVec.intY(), thisVec.intZ());
            this.preLoadColor = (byte)-1;
            this.setColor = true;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        this.preColorCooldown = (byte)40;
        if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            Vector3 thisVec = new Vector3(this);
            this.field_70331_k.func_72902_n(thisVec.intX(), thisVec.intY(), thisVec.intZ());
        }
    }

    @Override
    public void setColor(byte col) {
        this.pipeColor = col;
        if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            Vector3 thisVec = new Vector3(this);
            this.field_70331_k.func_72902_n(thisVec.intX(), thisVec.intY(), thisVec.intZ());
        }
    }

    @Override
    public byte getColor() {
        return this.pipeColor;
    }

    @Override
    public void onAdjacentColorChanged(ForgeDirection direction) {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        byte by = par1NBTTagCompound.func_74771_c("pipeColor");
        this.setColor(by);
        this.preLoadColor = by;
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("pipeColor", this.getColor());
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l + side.offsetX, this.field_70330_m + side.offsetY, this.field_70327_n + side.offsetZ);
        if (tile != null && tile instanceof IColorable) {
            byte color = ((IColorable)tile).getColor();
            return color == this.getColor();
        }
        return true;
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70331_k.field_72995_K) {
                this.setColor(dataStream.readByte());
                this.preLoadColor = dataStream.readByte();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onTransfer(EnumGas type) {
    }
}

