/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import mekanism.api.EnumGas;
import mekanism.api.IGasAcceptor;
import mekanism.api.ITubeConnection;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public abstract class GCCoreTileEntityOxygen
extends GCCoreTileEntityElectric
implements IGasAcceptor,
ITubeConnection {
    public int maxOxygen;
    public int oxygenPerTick;
    public int storedOxygen;
    public int lastStoredOxygen;
    public static int timeSinceOxygenRequest;

    public GCCoreTileEntityOxygen(float wattsPerTick, float maxEnergy, int maxOxygen, int oxygenPerTick) {
        super(wattsPerTick, maxEnergy);
        this.maxOxygen = maxOxygen;
        this.oxygenPerTick = oxygenPerTick;
    }

    public abstract ForgeDirection getOxygenInputDirection();

    public abstract boolean shouldPullOxygen();

    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor((double)this.storedOxygen / (double)this.maxOxygen * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (timeSinceOxygenRequest > 0) {
                --timeSinceOxygenRequest;
            }
            this.oxygenPerTick = (int)((float)this.storedOxygen / 250.0f);
            if (this.storedOxygen == this.lastStoredOxygen && this.storedOxygen < 250) {
                this.oxygenPerTick = 1;
            }
            this.storedOxygen = Math.max(this.storedOxygen - this.oxygenPerTick, 0);
        }
        this.lastStoredOxygen = this.storedOxygen;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, EnumGas type) {
        return side == this.getOxygenInputDirection() && type == EnumGas.OXYGEN;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection direction) {
        return direction == this.getOxygenInputDirection();
    }

    @Override
    public int transferGasToAcceptor(int amount, EnumGas type) {
        timeSinceOxygenRequest = 20;
        if (this.shouldPullOxygen() && type == EnumGas.OXYGEN) {
            int rejectedOxygen = 0;
            int requiredOxygen = this.maxOxygen - this.storedOxygen;
            if (amount <= requiredOxygen) {
                this.storedOxygen += amount;
            } else {
                this.storedOxygen += requiredOxygen;
                rejectedOxygen = amount - requiredOxygen;
            }
            return rejectedOxygen;
        }
        return amount;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.storedOxygen = nbt.func_74762_e("storedOxygen");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("storedOxygen", this.storedOxygen);
    }
}

