/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public class GCCorePacketManager
extends PacketManager
implements IPacketHandler,
IPacketReceiver {
    public static Packet getPacket(String channelName, Entity sender, ArrayList<Object> objs) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(2);
            data.writeInt(sender.field_70157_k);
            data = GCCorePacketManager.encodeDataStream(data, objs);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, ArrayList<Object> sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (!(dataValue instanceof NBTTagCompound)) continue;
                PacketManager.writeNBTTagCompound((NBTTagCompound)dataValue, data);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public static Packet getPacket(String channelName, Entity sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(2);
            data.writeInt(sender.field_70157_k);
            data = GCCorePacketManager.encodeDataStream(data, sendData);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (dataValue instanceof NBTTagCompound) {
                    PacketManager.writeNBTTagCompound((NBTTagCompound)dataValue, data);
                    continue;
                }
                if (!(dataValue instanceof ArrayList)) continue;
                for (Object dataValue2 : (ArrayList)dataValue) {
                    if (dataValue instanceof Integer) {
                        data.writeInt((Integer)dataValue);
                        continue;
                    }
                    if (dataValue instanceof Float) {
                        data.writeFloat(((Float)dataValue).floatValue());
                        continue;
                    }
                    if (dataValue instanceof Double) {
                        data.writeDouble((Double)dataValue);
                        continue;
                    }
                    if (dataValue instanceof Byte) {
                        data.writeByte(((Byte)dataValue).byteValue());
                        continue;
                    }
                    if (dataValue instanceof Boolean) {
                        data.writeBoolean((Boolean)dataValue);
                        continue;
                    }
                    if (dataValue instanceof String) {
                        data.writeUTF((String)dataValue);
                        continue;
                    }
                    if (dataValue instanceof Short) {
                        data.writeShort(((Short)dataValue).shortValue());
                        continue;
                    }
                    if (dataValue instanceof Long) {
                        data.writeLong((Long)dataValue);
                        continue;
                    }
                    if (!(dataValue instanceof NBTTagCompound)) continue;
                    PacketManager.writeNBTTagCompound((NBTTagCompound)dataValue, data);
                }
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    @Override
    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player player) {
        if (packet == null) {
            FMLLog.severe((String)"Packet received as null!", (Object[])new Object[0]);
            return;
        }
        if (packet.field_73629_c == null) {
            FMLLog.severe((String)("Packet data received as null! ID " + packet.func_73281_k()), (Object[])new Object[0]);
            return;
        }
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.field_73629_c);
            int packetTypeID = data.readInt();
            if (packetTypeID == 2) {
                double id = data.readInt();
                World world = ((EntityPlayer)player).field_70170_p;
                if (world != null) {
                    for (Object o : world.field_72996_f) {
                        if (!(o instanceof Entity)) continue;
                        Entity e = (Entity)o;
                        if (id != (double)e.field_70157_k || !(e instanceof IPacketReceiver)) continue;
                        ((IPacketReceiver)e).handlePacketData(network, packetTypeID, packet, (EntityPlayer)player, data);
                    }
                }
            } else if (packetTypeID == 1) {
                TileEntity tileEntity;
                int x = data.readInt();
                int y = data.readInt();
                int z = data.readInt();
                World world = ((EntityPlayer)player).field_70170_p;
                if (world != null && (tileEntity = world.func_72796_p(x, y, z)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (EntityPlayer)player, data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
    }

    public static enum GCCorePacketType {
        UNSPECIFIED,
        TILEENTITY,
        ENTITY;


        public static GCCorePacketType get(int id) {
            if (id >= 0 && id < PacketManager.PacketType.values().length) {
                return GCCorePacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

