/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.client.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemOilCanister;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;

public class GCCoreItemOilExtractor
extends Item {
    protected Icon[] icons = new Icon[5];
    public static final String[] names = new String[]{"extactor_1", "extactor_2", "extactor_3", "extactor_4", "extactor_5"};

    public GCCoreItemOilExtractor(int par1) {
        super(par1);
        this.func_77625_d(1);
    }

    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftTab;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.getNearestOilBlock(par3EntityPlayer) != null && this.openCanister(par3EntityPlayer) != null) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.icons = new Icon[5];
        this.icons[0] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "extractor_1" + GalacticraftCore.TEXTURE_SUFFIX);
        this.icons[1] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "extractor_2" + GalacticraftCore.TEXTURE_SUFFIX);
        this.icons[2] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "extractor_3" + GalacticraftCore.TEXTURE_SUFFIX);
        this.icons[3] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "extractor_4" + GalacticraftCore.TEXTURE_SUFFIX);
        this.icons[4] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "extractor_5" + GalacticraftCore.TEXTURE_SUFFIX);
        this.field_77791_bV = this.icons[0];
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.oilExtractor";
    }

    public void onUsingItemTick(ItemStack par1ItemStack, EntityPlayer par3EntityPlayer, int count) {
        int z;
        int y;
        int x;
        Vector3 blockHit = null;
        blockHit = this.getNearestOilBlock(par3EntityPlayer);
        if (blockHit != null && this.isOilBlock(par3EntityPlayer, par3EntityPlayer.field_70170_p, x = MathHelper.func_76128_c((double)blockHit.x), y = MathHelper.func_76128_c((double)blockHit.y), z = MathHelper.func_76128_c((double)blockHit.z))) {
            ItemStack canister;
            par3EntityPlayer.field_70170_p.func_94575_c(x, y, z, 0);
            if (this.openCanister(par3EntityPlayer) != null && (canister = this.openCanister(par3EntityPlayer)) != null && count % 5 == 0 && canister.func_77960_j() > 25) {
                canister.func_77964_b(canister.func_77960_j() - 25);
            }
        }
    }

    private ItemStack openCanister(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof GCCoreItemOilCanister) || stack.func_77958_k() - stack.func_77960_j() < 0 || stack.func_77958_k() - stack.func_77960_j() >= GCCoreItems.oilCanister.func_77612_l() - 1) continue;
            return stack;
        }
        return null;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int count2 = useRemaining / 2;
        switch (count2 % 5) {
            case 0: {
                if (useRemaining == 0) {
                    return this.icons[0];
                }
                return this.icons[4];
            }
            case 1: {
                return this.icons[3];
            }
            case 2: {
                return this.icons[2];
            }
            case 3: {
                return this.icons[1];
            }
            case 4: {
                return this.icons[0];
            }
        }
        return this.icons[0];
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        if (par2World.field_72995_K) {
            this.field_77791_bV = this.icons[0];
        }
    }

    private boolean isOilBlock(EntityPlayer player, World world, int x, int y, int z) {
        Class<?> buildCraftClass = null;
        try {
            buildCraftClass = Class.forName("buildcraft.BuildCraftEnergy");
            if (buildCraftClass != null) {
                for (Field f : buildCraftClass.getFields()) {
                    if (!f.getName().equals("oilMoving") && !f.getName().equals("oilStill")) continue;
                    Block block = (Block)f.get(null);
                    if (world.func_72798_a(x, y, z) != block.field_71990_ca || world.func_72805_g(x, y, z) != 0) continue;
                    return true;
                }
            }
        }
        catch (Throwable cnfe) {
            // empty catch block
        }
        return world.func_72798_a(x, y, z) == GCCoreBlocks.crudeOilStill.field_71990_ca && world.func_72805_g(x, y, z) == 0;
    }

    private Vector3 getNearestOilBlock(EntityPlayer par1EntityPlayer) {
        float var4 = 1.0f;
        float var5 = par1EntityPlayer.field_70127_C + (par1EntityPlayer.field_70125_A - par1EntityPlayer.field_70127_C) * 1.0f;
        float var6 = par1EntityPlayer.field_70126_B + (par1EntityPlayer.field_70177_z - par1EntityPlayer.field_70126_B) * 1.0f;
        double var7 = par1EntityPlayer.field_70169_q + (par1EntityPlayer.field_70165_t - par1EntityPlayer.field_70169_q) * 1.0;
        double var9 = par1EntityPlayer.field_70167_r + (par1EntityPlayer.field_70163_u - par1EntityPlayer.field_70167_r) * 1.0 + 1.62 - (double)par1EntityPlayer.field_70129_M;
        double var11 = par1EntityPlayer.field_70166_s + (par1EntityPlayer.field_70161_v - par1EntityPlayer.field_70166_s) * 1.0;
        Vector3 var13 = new Vector3(var7, var9, var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 5.0;
        if (par1EntityPlayer instanceof EntityPlayerMP) {
            var21 = ((EntityPlayerMP)par1EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        for (double dist = 0.0; dist <= var21; dist += 1.0) {
            Vector3 var23 = var13.add(new Vector3((double)var18 * dist, (double)var17 * dist, (double)var20 * dist));
            if (!this.isOilBlock(par1EntityPlayer, par1EntityPlayer.field_70170_p, MathHelper.func_76128_c((double)var23.x), MathHelper.func_76128_c((double)var23.y), MathHelper.func_76128_c((double)var23.z))) continue;
            return var23;
        }
        return null;
    }
}

