/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.fx.GCCoreEntityLanderFlameFX;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityAdvanced;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;

public class GCCoreEntityLander
extends GCCoreEntityAdvanced
implements IInventory,
IPacketReceiver {
    private final int tankCapacity = 5000;
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public double ySpeed;
    public double startingYSpeed;
    float maxSpeed = 0.05f;
    float minSpeed = 0.3f;
    float accel = 0.04f;
    float turnFactor = 2.0f;
    private double lastMotionY;
    public ItemStack[] chestContents = new ItemStack[0];
    public int numUsingPlayers;
    public GCCorePlayerMP playerSpawnedIn;
    private final float MAX_PITCH_ROTATION = 25.0f;
    public boolean landed;
    public float rumble;

    public GCCoreEntityLander(World var1) {
        super(var1, -5.0, 2.5f);
        this.func_70105_a(3.0f, 4.5f);
        this.ySpeed = 0.0;
        this.startingYSpeed = -5.0;
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public GCCoreEntityLander(World var1, double var2, double var4, double var6) {
        this(var1);
        this.func_70107_b(var2, var4 + (double)this.field_70129_M, var6);
    }

    public GCCoreEntityLander(GCCorePlayerMP player) {
        this(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        this.playerSpawnedIn = player;
        this.chestContents = new ItemStack[player.getRocketStacks().length + 1];
        this.fuelTank.setFluid(new FluidStack(GalacticraftCore.FUEL, player.getFuelLevel()));
        for (int i = 0; i < player.getRocketStacks().length; ++i) {
            this.chestContents[i] = player.getRocketStacks()[i];
        }
    }

    @Override
    public void func_70071_h_() {
        FluidStack liquid;
        EntityPlayer player;
        super.func_70071_h_();
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        }
        if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70165_t += (double)this.rumble * Math.abs(this.field_70181_x) / 20.0;
            this.field_70153_n.field_70161_v += (double)this.rumble * Math.abs(this.field_70181_x) / 20.0;
        }
        if (this.field_70181_x != 0.0) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (this.ticks < 40L && this.field_70163_u > 100.0 && this.field_70153_n == null && (player = this.field_70170_p.func_72890_a((Entity)this, 5.0)) != null) {
            player.func_70078_a((Entity)this);
        }
        if (!this.field_70170_p.field_72995_K && (liquid = this.fuelTank.getFluid()) != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid().getName().equalsIgnoreCase("Fuel") && FluidContainerRegistry.isEmptyContainer((ItemStack)this.chestContents[this.chestContents.length - 1])) {
            boolean isCanister = this.chestContents[this.chestContents.length - 1].func_77969_a(new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l()));
            int amountToFill = Math.min(liquid.amount, isCanister ? GCCoreItems.fuelCanister.func_77612_l() - 1 : 1000);
            this.chestContents[this.chestContents.length - 1] = isCanister ? new ItemStack(GCCoreItems.fuelCanister, 1, GCCoreItems.fuelCanister.func_77612_l() - amountToFill) : FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)this.chestContents[this.chestContents.length - 1]);
            this.fuelTank.drain(amountToFill, true);
        }
        this.lastMotionY = this.field_70181_x;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.chestContents = new ItemStack[nbt.func_74762_e("rocketStacksLength")];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.chestContents.length) continue;
            this.chestContents[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.landed = nbt.func_74767_n("landed");
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        nbt.func_74768_a("rocketStacksLength", this.chestContents.length);
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74757_a("landed", this.landed);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public int func_70302_i_() {
        return this.chestContents.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.chestContents[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.chestContents[par1] != null) {
            if (this.chestContents[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.chestContents[par1];
                this.chestContents[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[par1].func_77979_a(par2);
            if (this.chestContents[par1].field_77994_a == 0) {
                this.chestContents[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.chestContents[par1] != null) {
            ItemStack itemstack = this.chestContents[par1];
            this.chestContents[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.chestContents[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization("container.lander");
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return par1EntityPlayer.func_70092_e(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
    }

    public void func_70305_f() {
        --this.numUsingPlayers;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_130002_c(EntityPlayer var1) {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            return true;
        }
        if (this.field_70153_n == null && this.field_70122_E && var1 instanceof EntityPlayerMP) {
            GCCoreUtil.openParachestInv((EntityPlayerMP)var1, this);
            return true;
        }
        if (var1 instanceof EntityPlayerMP) {
            ((EntityPlayerMP)var1).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, new Object[]{0}));
            var1.func_70078_a(null);
            return true;
        }
        return true;
    }

    @Override
    public boolean pressKey(int key) {
        switch (key) {
            case 0: {
                if (!this.field_70122_E) {
                    this.field_70125_A -= 0.5f * this.turnFactor;
                }
                return true;
            }
            case 1: {
                if (!this.field_70122_E) {
                    this.field_70125_A += 0.5f * this.turnFactor;
                }
                return true;
            }
            case 2: {
                if (!this.field_70122_E) {
                    this.field_70177_z -= 0.5f * this.turnFactor;
                }
                return true;
            }
            case 3: {
                if (!this.field_70122_E) {
                    this.field_70177_z += 0.5f * this.turnFactor;
                }
                return true;
            }
            case 4: {
                this.ySpeed += (double)0.05f;
                return true;
            }
            case 5: {
                this.ySpeed -= (double)0.005f;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldMove() {
        if (this.ticks < 40L) {
            return this.field_70153_n != null;
        }
        return !this.landed;
    }

    @Override
    public boolean shouldSpawnParticles() {
        return !this.landed && this.field_70163_u < 256.0;
    }

    @Override
    public Map<Vector3, Vector3> getParticleMap() {
        double x1 = 2.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double z1 = 2.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double y1 = -5.0;
        new Vector3(this);
        HashMap<Vector3, Vector3> particleMap = new HashMap<Vector3, Vector3>();
        float angle1 = (float)((double)(this.field_70177_z - 40.0f) * Math.PI / 180.0);
        float angle2 = (float)((double)(this.field_70177_z + 40.0f) * Math.PI / 180.0);
        float angle3 = (float)((double)(this.field_70177_z + 180.0f - 40.0f) * Math.PI / 180.0);
        float angle4 = (float)((double)(this.field_70177_z + 180.0f + 40.0f) * Math.PI / 180.0);
        float pitch = (float)Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        particleMap.put(new Vector3(this).add(new Vector3(0.4 * Math.cos(angle1) * Math.cos(pitch), -1.5, 0.4 * Math.sin(angle1) * Math.cos(pitch))), new Vector3(x1, -5.0, z1));
        particleMap.put(new Vector3(this).add(new Vector3(0.4 * Math.cos(angle2) * Math.cos(pitch), -1.5, 0.4 * Math.sin(angle2) * Math.cos(pitch))), new Vector3(x1, -5.0, z1));
        particleMap.put(new Vector3(this).add(new Vector3(0.4 * Math.cos(angle3) * Math.cos(pitch), -1.5, 0.4 * Math.sin(angle3) * Math.cos(pitch))), new Vector3(x1, -5.0, z1));
        particleMap.put(new Vector3(this).add(new Vector3(0.4 * Math.cos(angle4) * Math.cos(pitch), -1.5, 0.4 * Math.sin(angle4) * Math.cos(pitch))), new Vector3(x1, -5.0, z1));
        return particleMap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityFX getParticle(Random rand, double x, double y, double z, double motX, double motY, double motZ) {
        return new GCCoreEntityLanderFlameFX(this.field_70170_p, x, y, z, motX, motY, motZ);
    }

    @Override
    public void tickInAir() {
        if (this.landed) {
            this.field_70181_x = 0.0;
            return;
        }
        if (this.field_70125_A >= this.MAX_PITCH_ROTATION) {
            this.field_70125_A = this.MAX_PITCH_ROTATION;
        } else if (this.field_70125_A <= -this.MAX_PITCH_ROTATION) {
            this.field_70125_A = -this.MAX_PITCH_ROTATION;
        }
        this.ySpeed *= 0.98;
        this.startingYSpeed += this.ySpeed * (double)this.accel;
        double d = this.startingYSpeed < -5.0 ? -5.0 : (this.startingYSpeed = this.startingYSpeed > (double)(-this.minSpeed) ? (double)(-this.minSpeed) : this.startingYSpeed);
        if (this.field_70170_p.field_72995_K) {
            this.field_70181_x = this.startingYSpeed;
        }
    }

    @Override
    public void tickOnGround() {
        this.field_70125_A = 0.0f;
        this.field_70177_z = 0.0f;
    }

    @Override
    public void onGroundHit() {
        if (Math.abs(this.lastMotionY) > 2.0) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayerMP) {
                Object[] toSend2 = new Object[]{0};
                ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, toSend2));
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0f, true);
            this.func_70106_y();
        }
        this.landed = true;
    }

    @Override
    public Vector3 getMotionVec() {
        return new Vector3(-(50.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0)), this.ticks < 40L ? 0.0 : this.field_70181_x, -(50.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0)));
    }

    @Override
    public ArrayList<Object> getNetworkedData() {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(this.landed);
        Integer cargoLength = this.chestContents != null ? this.chestContents.length : 0;
        objList.add(cargoLength);
        objList.add(this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluid().amount);
        return objList;
    }

    @Override
    public int getPacketTickSpacing() {
        return 5;
    }

    @Override
    public double getPacketSendDistance() {
        return 50.0;
    }

    @Override
    public void readNetworkedData(ByteArrayDataInput dataStream) {
        this.landed = dataStream.readBoolean();
        int cargoLength = dataStream.readInt();
        if (this.chestContents == null || this.chestContents.length == 0) {
            this.chestContents = new ItemStack[cargoLength];
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket("GalacticraftCore", 21, new Object[]{this.field_70157_k}));
        }
        this.fuelTank.setFluid(new FluidStack(GalacticraftCore.FUEL, dataStream.readInt()));
    }

    @Override
    public boolean allowDamageSource(DamageSource damageSource) {
        return this.landed && !damageSource.func_94541_c();
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.chestContents) {
            items.add(stack);
        }
        return items;
    }
}

