/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFuelLoader;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockFuelLoader
extends GCCoreBlockAdvanced {
    private Icon iconMachineSide;
    private Icon iconInput;
    private Icon iconFront;
    private Icon iconFuelInput;

    public GCCoreBlockFuelLoader(int id) {
        super(id, Material.field_76246_e);
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_power_input");
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconFront = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_fuelloader");
        this.iconFuelInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_fuel_input");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new GCCoreTileEntityFuelLoader();
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiFuelLoader, world, x, y, z);
        return true;
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconMachineSide;
        }
        if (side == metadata + 2) {
            return this.iconInput;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
            return this.iconFuelInput;
        }
        return this.iconFront;
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                int id = world.func_72798_a(x + dX, y, z + dZ);
                if (id != GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                world.func_72845_h(x + dX, y, z + dZ);
            }
        }
    }

    public void func_71898_d(World world, int x, int y, int z, int par5) {
        super.func_71898_d(world, x, y, z, par5);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                int id = world.func_72798_a(x + dX, y, z + dZ);
                if (id != GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                world.func_72845_h(x + dX, y, z + dZ);
            }
        }
    }
}

