/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.vector;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;

public abstract class Vector
implements Cloneable {
    public abstract List<Double> getCoords();

    public abstract void setCoords(List<Double> var1) throws IndexOutOfBoundsException;

    public abstract Vector add(Vector var1);

    public void writeToNBT(NBTTagList list) {
        for (Double coord : this.getCoords()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74780_a("Coordinate", coord.doubleValue());
            list.func_74742_a((NBTBase)nbt);
        }
    }

    public static Vector readFromNBT(NBTTagList list) {
        Vector vec;
        switch (list.func_74745_c()) {
            case 2: {
                vec = new Vector2();
                break;
            }
            case 3: {
                vec = new Vector3();
                break;
            }
            default: {
                FMLLog.severe((String)"FAILED TO LOAD VECTOR FROM NBT", (Object[])new Object[0]);
                return null;
            }
        }
        ArrayList<Double> coordList = new ArrayList<Double>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = (NBTTagCompound)list.func_74743_b(i);
            coordList.add(nbt.func_74769_h("Coordinate"));
        }
        try {
            vec.setCoords(coordList);
        }
        catch (IndexOutOfBoundsException e) {
            FMLLog.severe((String)"FAILED TO LOAD VECTOR FROM NBT", (Object[])new Object[0]);
            return null;
        }
        return vec;
    }

    public static class Vector2
    extends Vector {
        public double x;
        public double y;

        public Vector2() {
        }

        public Vector2(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public List<Double> getCoords() {
            return Arrays.asList(this.x, this.y);
        }

        @Override
        public void setCoords(List<Double> coords) throws IndexOutOfBoundsException {
            this.x = coords.get(0);
            this.y = coords.get(1);
        }

        public Vector2 clone() {
            return new Vector2(this.x, this.y);
        }

        @Override
        public Vector add(Vector vec) {
            if (vec instanceof Vector2) {
                this.x += ((Vector3)vec).x;
                this.y += ((Vector3)vec).y;
            } else {
                FMLLog.severe((String)"CANNOT ADD VECTOR3 to VECTOR2", (Object[])new Object[0]);
            }
            return this;
        }
    }

    public static class Vector3
    extends Vector {
        public double x;
        public double y;
        public double z;

        public Vector3() {
        }

        public Vector3(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public List<Double> getCoords() {
            return Arrays.asList(this.x, this.y, this.z);
        }

        public int getIntX() {
            return (int)Math.floor(this.x);
        }

        public int getIntY() {
            return (int)Math.floor(this.y);
        }

        public int getIntZ() {
            return (int)Math.floor(this.z);
        }

        @Override
        public void setCoords(List<Double> coords) throws IndexOutOfBoundsException {
            this.x = coords.get(0);
            this.y = coords.get(1);
            this.z = coords.get(2);
        }

        public Vector3 clone() {
            return new Vector3(this.x, this.y, this.z);
        }

        @Override
        public Vector add(Vector vec) {
            if (vec instanceof Vector3) {
                this.x += ((Vector3)vec).x;
                this.y += ((Vector3)vec).y;
                this.z += ((Vector3)vec).z;
            } else {
                FMLLog.severe((String)"CANNOT ADD VECTOR2 to VECTOR3", (Object[])new Object[0]);
            }
            return this;
        }

        public int getBlockID(IBlockAccess blockAccess) {
            return blockAccess.func_72798_a(this.getIntX(), this.getIntY(), this.getIntZ());
        }

        public Object toUEVector3() {
            try {
                Class<?> clazz = Class.forName("universalelectricity.core.vector.Vector3");
                Constructor<?> c = clazz.getConstructor(Double.class, Double.class, Double.class);
                return c.newInstance(this.x, this.y, this.z);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

