/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.IGalaxy;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import net.minecraft.world.WorldProvider;

public class GalacticraftRegistry {
    private static Map<Class<? extends WorldProvider>, ITeleportType> teleportTypeMap = new HashMap<Class<? extends WorldProvider>, ITeleportType>();
    private static List<SpaceStationType> spaceStations = new ArrayList<SpaceStationType>();
    private static List<ICelestialBody> celestialBodies = new ArrayList<ICelestialBody>();
    private static List<IGalaxy> galaxies = new ArrayList<IGalaxy>();
    private static List<INasaWorkbenchRecipe> rocketBenchRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> buggyBenchRecipes = new ArrayList<INasaWorkbenchRecipe>();

    public static void registerTeleportType(Class<? extends WorldProvider> clazz, ITeleportType type) {
        if (!teleportTypeMap.containsKey(clazz)) {
            teleportTypeMap.put(clazz, type);
        }
    }

    public static void registerCelestialBody(ICelestialBody body) {
        if (!celestialBodies.contains(body)) {
            celestialBodies.add(body);
        }
    }

    public static void registerGalaxy(IGalaxy galaxy) {
        if (!galaxies.contains(galaxy)) {
            galaxies.add(galaxy);
        }
    }

    public static void addT1RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchRecipes.add(recipe);
    }

    public static void addMoonBuggyRecipe(INasaWorkbenchRecipe recipe) {
        buggyBenchRecipes.add(recipe);
    }

    public static ITeleportType getTeleportTypeForDimension(Class<? extends WorldProvider> clazz) {
        return teleportTypeMap.get(clazz);
    }

    public static void registerSpaceStation(SpaceStationType type) {
        spaceStations.add(type);
    }

    public SpaceStationType getTypeFromPlanetID(int planetID) {
        return spaceStations.get(planetID);
    }

    public static List<SpaceStationType> getSpaceStationData() {
        return spaceStations;
    }

    public static List<ICelestialBody> getCelestialBodies() {
        return celestialBodies;
    }

    public static List<IGalaxy> getGalaxyList() {
        return galaxies;
    }

    public static List<INasaWorkbenchRecipe> getRocketT1Recipes() {
        return rocketBenchRecipes;
    }

    public static List<INasaWorkbenchRecipe> getBuggyBenchRecipes() {
        return buggyBenchRecipes;
    }
}

