/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class Object3D {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimensionId;

    public Object3D(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = 0;
    }

    public Object3D(int x, int y, int z, int dimension) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = dimension;
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
    }

    public int getBlockId(IBlockAccess world) {
        return world.func_72798_a(this.xCoord, this.yCoord, this.zCoord);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_72796_p(this.xCoord, this.yCoord, this.zCoord);
    }

    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("x", this.xCoord);
        nbtTags.func_74768_a("y", this.yCoord);
        nbtTags.func_74768_a("z", this.zCoord);
        nbtTags.func_74768_a("dimensionId", this.dimensionId);
    }

    public Object3D translate(int x, int y, int z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
        return this;
    }

    public Object3D getFromSide(ForgeDirection side) {
        return new Object3D(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ, this.dimensionId);
    }

    public static Object3D get(TileEntity tileEntity) {
        return new Object3D(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, tileEntity.field_70331_k.field_73011_w.field_76574_g);
    }

    public static Object3D read(NBTTagCompound nbtTags) {
        return new Object3D(nbtTags.func_74762_e("x"), nbtTags.func_74762_e("y"), nbtTags.func_74762_e("z"), nbtTags.func_74762_e("dimensionId"));
    }

    public int distanceTo(Object3D obj) {
        int subX = this.xCoord - obj.xCoord;
        int subY = this.yCoord - obj.yCoord;
        int subZ = this.zCoord - obj.zCoord;
        return (int)MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public boolean sideVisible(ForgeDirection side, IBlockAccess world) {
        return world.func_72798_a(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ) == 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Object3D && ((Object3D)obj).xCoord == this.xCoord && ((Object3D)obj).yCoord == this.yCoord && ((Object3D)obj).zCoord == this.zCoord && ((Object3D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xCoord;
        code = 31 * code + this.yCoord;
        code = 31 * code + this.zCoord;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

