/*
 * Decompiled with CFR 0.152.
 */
package icbm.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import universalelectricity.core.vector.Vector2;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.vector.Region2;

public class RadarRegistry {
    private static Set<TileEntity> detectableTileEntities = new HashSet<TileEntity>();
    private static Set<Entity> detectableEntities = new HashSet<Entity>();

    public static void register(TileEntity tileEntity) {
        if (!detectableTileEntities.contains(tileEntity)) {
            detectableTileEntities.add(tileEntity);
        }
    }

    public static void unregister(TileEntity tileEntity) {
        if (detectableTileEntities.contains(tileEntity)) {
            detectableTileEntities.remove(tileEntity);
        }
    }

    public static void register(Entity entity) {
        if (!detectableEntities.contains(entity)) {
            detectableEntities.add(entity);
        }
    }

    public static void unregister(Entity entity) {
        if (detectableEntities.contains(entity)) {
            detectableEntities.remove(entity);
        }
    }

    public static List<TileEntity> getTileEntitiesInArea(Vector2 minVector, Vector2 maxVector) {
        RadarRegistry.cleanUpArray();
        ArrayList<TileEntity> returnArray = new ArrayList<TileEntity>();
        for (TileEntity tileEntity : detectableTileEntities) {
            if (!new Region2(minVector, maxVector).isIn(new Vector3(tileEntity).toVector2())) continue;
            returnArray.add(tileEntity);
        }
        return returnArray;
    }

    public static List<Entity> getEntitiesWithinRadius(Vector2 vector, int radius) {
        RadarRegistry.cleanUpArray();
        ArrayList<Entity> returnArray = new ArrayList<Entity>();
        for (Entity entity : detectableEntities) {
            Vector3 vector3 = new Vector3(entity);
            if (!(Vector2.distance(vector, vector3.toVector2()) <= (double)radius)) continue;
            returnArray.add(entity);
        }
        return returnArray;
    }

    public static Set<TileEntity> getTileEntities() {
        RadarRegistry.cleanUpArray();
        return detectableTileEntities;
    }

    public static Set<Entity> getEntities() {
        RadarRegistry.cleanUpArray();
        return detectableEntities;
    }

    public static void cleanUpArray() {
        try {
            Iterator<TileEntity> it = detectableTileEntities.iterator();
            while (it.hasNext()) {
                TileEntity tileEntity = it.next();
                if (tileEntity == null) {
                    it.remove();
                    continue;
                }
                if (tileEntity.func_70320_p()) {
                    it.remove();
                    continue;
                }
                if (tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) == tileEntity) continue;
                it.remove();
            }
            Iterator<Entity> it2 = detectableEntities.iterator();
            while (it2.hasNext()) {
                Entity entity = it2.next();
                if (entity == null) {
                    it2.remove();
                    continue;
                }
                if (!entity.field_70128_L) continue;
                it2.remove();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to clean up radar list properly.");
            e.printStackTrace();
        }
    }
}

