/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTKeyframe;
import com.overminddl1.mods.NMT.NMTModelFile;
import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTPolygon;
import com.overminddl1.mods.NMT.NMTTextureVertex;
import com.overminddl1.mods.NMT.NMTVertex;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.util.Vec3;

public class NMTModelFileOBJ
extends NMTModelFile {
    private ArrayList<Vec3> normal = new ArrayList();
    private ArrayList<Float[]> texCoord = new ArrayList();
    public ArrayList<NMTKeyframe> keyframeList;

    public NMTModelFileOBJ(NMTModelRenderer nmtmodelrenderer, String mdlFile) throws IllegalStateException, IOException {
        super(nmtmodelrenderer, mdlFile);
    }

    @Override
    protected NMTModelFile getInstance() {
        try {
            return new NMTModelFileOBJ(this.renderer, this.modelName);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected String[] getExtensions() {
        return new String[]{"obj"};
    }

    @Override
    protected String getModelFormat() {
        return "Wavefront OBJ";
    }

    @Override
    public NMTModelFile parseFile() {
        if (this.modelURL == null) {
            return this;
        }
        try {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.modelURL.openStream()));
            while ((s = in.readLine()) != null) {
                if (s.indexOf("#") > -1) {
                    s = s.substring(0, s.indexOf("#"));
                }
                if ((s = s.trim()).equals("")) continue;
                String parse = s.substring(s.indexOf(" ") + 1).trim();
                parse = parse.replaceAll("  ", " ");
                parse = parse.replaceAll("\t", "");
                String[] p = parse.split(" ");
                if (s.startsWith("v ")) {
                    this.vertices.add(this.parseVertex(p));
                    continue;
                }
                if (s.startsWith("vt ")) {
                    this.texCoord.add(this.parseTexCoords(p));
                    continue;
                }
                if (s.startsWith("vn ")) {
                    this.normal.add(this.parseNormal(p));
                    continue;
                }
                if (!s.startsWith("f ")) continue;
                this.polygons.add(this.parseFace(p));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found " + this.modelURL.toString());
            return this;
        }
        catch (IOException e) {
            System.out.println("Error opening file " + this.modelURL.toString());
            return this;
        }
        return this;
    }

    private NMTVertex parseVertex(String[] s) {
        float[] v = new float[]{Float.parseFloat(s[0]), -Float.parseFloat(s[2]), Float.parseFloat(s[1])};
        return new NMTVertex(v[0], v[1], v[2]);
    }

    private Float[] parseTexCoords(String[] s) {
        Float[] vt = new Float[]{Float.valueOf(Float.parseFloat(s[0])), Float.valueOf(0.0f)};
        if (s.length > 1) {
            vt[1] = Float.valueOf(Float.parseFloat(s[1]));
        }
        return vt;
    }

    private Vec3 parseNormal(String[] s) {
        float[] vn = new float[]{Float.parseFloat(s[0]), -Float.parseFloat(s[2]), Float.parseFloat(s[1])};
        return Vec3.func_72443_a((double)vn[0], (double)vn[1], (double)vn[2]);
    }

    private NMTPolygon parseFace(String[] s) {
        ArrayList<NMTTextureVertex> verts = new ArrayList<NMTTextureVertex>();
        boolean polyTextured = true;
        boolean polyIndNormal = false;
        for (int idx = 0; idx < s.length; ++idx) {
            int vtInd;
            String[] p = s[idx].split("/");
            Float[] vt = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
            Vec3 vn = null;
            boolean textured = false;
            int vInd = Integer.parseInt(p[0]) - 1;
            if (p.length > 1 && !p[1].equals("") && (vtInd = Integer.parseInt(p[1]) - 1) < this.texCoord.size()) {
                vt = this.texCoord.get(vtInd);
                textured = true;
            }
            if (p.length > 2) {
                vn = this.normal.get(Integer.parseInt(p[2]) - 1);
                polyIndNormal = true;
            } else if (vInd < this.normal.size()) {
                vn = this.normal.get(vInd);
                polyIndNormal = true;
            }
            NMTTextureVertex vert = new NMTTextureVertex((NMTVertex)this.vertices.get(vInd), vt[0].floatValue(), vt[1].floatValue(), vn);
            vert.textured = textured;
            verts.add(vert);
            polyTextured = polyTextured && textured;
        }
        NMTPolygon poly = new NMTPolygon(verts);
        poly.textured = polyTextured;
        poly.indivNormal = polyIndNormal;
        return poly;
    }
}

