/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTGlobal;
import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTPolygon;
import com.overminddl1.mods.NMT.NMTTextureVertex;
import com.overminddl1.mods.NMT.NMTVertex;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;

public abstract class NMTModelFile
extends NMTModelBase {
    protected URL modelURL;
    protected String modelName;
    public boolean useGlobalInstance;
    protected boolean[] mirrored;

    public NMTModelFile(NMTModelRenderer nmtmodelrenderer, String mdlFile) throws MalformedURLException {
        this(nmtmodelrenderer, new URL(mdlFile));
    }

    public NMTModelFile(NMTModelRenderer nmtmodelrenderer, URL mdlURL) {
        super(nmtmodelrenderer);
        this.modelURL = this.checkValidPath(mdlURL);
        this.modelName = mdlURL.toString();
        this.useGlobalInstance = true;
        this.mirrored = new boolean[3];
    }

    @Override
    public void render(Tessellator tessellator, float scale) {
        boolean isMirrored;
        boolean bl = isMirrored = this.useGlobalInstance && (this.mirrored[0] || this.mirrored[1] || this.mirrored[2]);
        if (isMirrored) {
            super.doMirror(this.mirrored[0], this.mirrored[1], this.mirrored[2]);
        }
        super.render(tessellator, scale);
        if (isMirrored) {
            super.doMirror(this.mirrored[0], this.mirrored[1], this.mirrored[2]);
        }
    }

    public NMTModelFile setToCopy() {
        this.useGlobalInstance = false;
        return this;
    }

    protected URL checkValidPath(URL url) {
        String[] fileExtensions;
        String path = url.getPath();
        for (String ext : fileExtensions = this.getExtensions()) {
            if (!path.endsWith(ext)) continue;
            return url;
        }
        return null;
    }

    @Override
    public NMTModelBase create() {
        HashMap<String, NMTModelBase> fileMap;
        if (!NMTGlobal.NMT_MODEL_DATA.containsKey(this.getModelFormat())) {
            NMTGlobal.NMT_MODEL_DATA.put(this.getModelFormat(), new HashMap());
        }
        if (!(fileMap = NMTGlobal.NMT_MODEL_DATA.get(this.getModelFormat())).containsKey(this.modelName)) {
            System.out.println("Loading model file " + this.modelName + " using " + this.getModelFormat());
            fileMap.put(this.modelName, this.getInstance().parseFile());
        }
        NMTModelBase baseModel = fileMap.get(this.modelName);
        if (!this.useGlobalInstance) {
            this.copyModel(baseModel);
        } else {
            this.useDataFromGlobalInstance(baseModel);
        }
        return this;
    }

    protected void copyModel(NMTModelBase baseModel) {
        int idx;
        HashMap<NMTVertex, NMTVertex> vertMap = new HashMap<NMTVertex, NMTVertex>();
        for (idx = 0; idx < baseModel.vertices.size(); ++idx) {
            NMTVertex vert = baseModel.vertices.get(idx).copyVertex();
            this.vertices.add(vert);
            vertMap.put(baseModel.vertices.get(idx), vert);
        }
        for (idx = 0; idx < baseModel.polygons.size(); ++idx) {
            ArrayList<NMTTextureVertex> verts = new ArrayList<NMTTextureVertex>();
            NMTPolygon basePoly = baseModel.polygons.get(idx);
            for (int idy = 0; idy < basePoly.vertices.size(); ++idy) {
                NMTTextureVertex texVert = basePoly.vertices.get(idy);
                Vec3 normal = null;
                if (texVert.normal != null) {
                    normal = Vec3.func_72443_a((double)texVert.normal.field_72450_a, (double)texVert.normal.field_72448_b, (double)texVert.normal.field_72449_c);
                }
                NMTTextureVertex tV = new NMTTextureVertex((NMTVertex)vertMap.get(texVert.vertex), texVert.textureU, texVert.textureV, normal);
                tV.textured = texVert.textured;
                verts.add(tV);
            }
            NMTPolygon poly = new NMTPolygon(verts);
            poly.indivNormal = basePoly.indivNormal;
            poly.invertNormal = basePoly.invertNormal;
            poly.recalcNormal = basePoly.recalcNormal;
            poly.textured = basePoly.textured;
            this.polygons.add(poly);
        }
    }

    protected void useDataFromGlobalInstance(NMTModelBase baseModel) {
        this.vertices = baseModel.vertices;
        this.polygons = baseModel.polygons;
    }

    @Override
    public void doMirror(boolean x, boolean y, boolean z) {
        if (!this.useGlobalInstance) {
            super.doMirror(x, y, z);
        } else {
            this.mirrored = new boolean[]{x, y, z};
        }
    }

    protected abstract NMTModelFile getInstance();

    protected abstract NMTModelFile parseFile();

    protected abstract String[] getExtensions();

    protected abstract String getModelFormat();
}

