/*
 * Decompiled with CFR 0.152.
 */
package basiccomponents.common.block;

import basiccomponents.common.BasicComponents;
import basiccomponents.common.tileentity.TileEntityBatteryBox;
import basiccomponents.common.tileentity.TileEntityCoalGenerator;
import basiccomponents.common.tileentity.TileEntityElectricFurnace;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.prefab.block.BlockTile;

public class BlockBasicMachine
extends BlockTile {
    public static final int COAL_GENERATOR_METADATA = 0;
    public static final int BATTERY_BOX_METADATA = 4;
    public static final int ELECTRIC_FURNACE_METADATA = 8;
    private Icon iconMachineSide;
    private Icon iconInput;
    private Icon iconOutput;
    private Icon iconCoalGenerator;
    private Icon iconBatteryBox;
    private Icon iconElectricFurnace;

    public BlockBasicMachine(int id, int textureIndex) {
        super(id, UniversalElectricity.machine);
        this.func_71864_b("basiccomponents:bcMachine");
        this.func_71849_a(CreativeTabs.field_78031_c);
        this.func_71884_a(field_71977_i);
    }

    public void func_94332_a(IconRegister par1IconRegister) {
        this.field_94336_cN = par1IconRegister.func_94245_a("basiccomponents:machine");
        this.iconInput = par1IconRegister.func_94245_a("basiccomponents:machine_input");
        this.iconOutput = par1IconRegister.func_94245_a("basiccomponents:machine_output");
        this.iconMachineSide = par1IconRegister.func_94245_a("basiccomponents:machine_side");
        this.iconCoalGenerator = par1IconRegister.func_94245_a("basiccomponents:coalGenerator");
        this.iconBatteryBox = par1IconRegister.func_94245_a("basiccomponents:batteryBox");
        this.iconElectricFurnace = par1IconRegister.func_94245_a("basiccomponents:electricFurnace");
    }

    public void func_71862_a(World par1World, int x, int y, int z, Random par5Random) {
        TileEntity tile = par1World.func_72796_p(x, y, z);
        if (tile instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tileEntity = (TileEntityCoalGenerator)tile;
            if (tileEntity.generateWatts > 0.0f) {
                int metadata = par1World.func_72805_g(x, y, z);
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
                if (metadata == 3) {
                    par1World.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 2) {
                    par1World.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 1) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                } else if (metadata == 0) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_94336_cN;
        }
        if (metadata >= 8) {
            if (side == (metadata -= 8) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconElectricFurnace;
            }
        } else {
            if (metadata >= 4) {
                if (side == (metadata -= 4) + 2) {
                    return this.iconOutput;
                }
                if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                    return this.iconInput;
                }
                return this.iconBatteryBox;
            }
            if (side == metadata + 2) {
                return this.iconOutput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconCoalGenerator;
            }
        }
        return this.iconMachineSide;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        if (metadata >= 8) {
            world.func_72921_c(x, y, z, 8 + change, 3);
        } else if (metadata >= 4) {
            switch (angle) {
                case 0: {
                    change = 3;
                    break;
                }
                case 1: {
                    change = 1;
                    break;
                }
                case 2: {
                    change = 2;
                    break;
                }
                case 3: {
                    change = 0;
                }
            }
            world.func_72921_c(x, y, z, 4 + change, 3);
        } else {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 8) {
            original -= 8;
        } else if (metadata >= 4) {
            original -= 4;
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 8) {
            change += 8;
        } else if (metadata >= 4) {
            change += 4;
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            if (metadata >= 8) {
                par5EntityPlayer.openGui(BasicComponents.getFirstDependant(), -1, par1World, x, y, z);
                return true;
            }
            if (metadata >= 4) {
                par5EntityPlayer.openGui(BasicComponents.getFirstDependant(), -1, par1World, x, y, z);
                return true;
            }
            par5EntityPlayer.openGui(BasicComponents.getFirstDependant(), -1, par1World, x, y, z);
            return true;
        }
        return true;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 8) {
            return new TileEntityElectricFurnace();
        }
        if (metadata >= 4) {
            return new TileEntityBatteryBox();
        }
        return new TileEntityCoalGenerator();
    }

    public ItemStack getCoalGenerator() {
        return new ItemStack(this.field_71990_ca, 1, 0);
    }

    public ItemStack getBatteryBox() {
        return new ItemStack(this.field_71990_ca, 1, 4);
    }

    public ItemStack getElectricFurnace() {
        return new ItemStack(this.field_71990_ca, 1, 8);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getCoalGenerator());
        par3List.add(this.getBatteryBox());
        par3List.add(this.getElectricFurnace());
    }

    public int func_71899_b(int metadata) {
        if (metadata >= 8) {
            return 8;
        }
        if (metadata >= 4) {
            return 4;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int id = this.func_71922_a(world, x, y, z);
        if (id == 0) {
            return null;
        }
        Item item = Item.field_77698_e[id];
        if (item == null) {
            return null;
        }
        int metadata = this.func_71873_h(world, x, y, z);
        return new ItemStack(id, 1, metadata);
    }
}

