/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.wgen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.wgen.dungeon.GCCoreDungeonRoom;
import micdoodle8.mods.galacticraft.core.wgen.dungeon.GCCoreMapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class GCMoonRoomTreasure
extends GCCoreDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final ArrayList<ChunkCoordinates> chests = new ArrayList();

    public GCMoonRoomTreasure(GCCoreMapGenDungeon dungeon, int posX, int posY, int posZ, int entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(6) + 7;
            this.sizeY = rand.nextInt(2) + 5;
            this.sizeZ = rand.nextInt(6) + 7;
        }
    }

    @Override
    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (!(i != this.posX && i != this.posX + this.sizeX - 1 || k != this.posZ && k != this.posZ + this.sizeZ - 1)) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, Block.field_72014_bd.field_71990_ca, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, GCCoreBlocks.treasureChest.field_71990_ca, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    @Override
    public GCCoreDungeonBoundingBox getBoundingBox() {
        return new GCCoreDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GCCoreDungeonRoom makeRoom(GCCoreMapGenDungeon dungeon, int x, int y, int z, int dir) {
        return new GCMoonRoomTreasure(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        for (ChunkCoordinates chestCoords : this.chests) {
            TileEntity chest = this.worldObj.func_72796_p(chestCoords.field_71574_a, chestCoords.field_71572_b, chestCoords.field_71573_c);
            if (chest == null || !(chest instanceof GCCoreTileEntityTreasureChest)) continue;
            ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)((GCCoreTileEntityTreasureChest)chest), (int)info.getCount(rand));
            ((GCCoreTileEntityTreasureChest)chest).func_70299_a(rand.nextInt(((GCCoreTileEntityTreasureChest)chest).func_70302_i_()), this.getGuaranteedLoot(rand));
        }
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        switch (rand.nextInt(2)) {
            case 0: {
                return new ItemStack(GCCoreItems.schematic, 1, 0);
            }
            case 1: {
                return new ItemStack(GCCoreItems.schematic, 1, 1);
            }
        }
        return null;
    }
}

