/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.world.IMoon;
import micdoodle8.mods.galacticraft.core.GCCoreCreativeTab;
import micdoodle8.mods.galacticraft.moon.GCMoonCelestialBody;
import micdoodle8.mods.galacticraft.moon.GCMoonConfigManager;
import micdoodle8.mods.galacticraft.moon.blocks.GCMoonBlocks;
import micdoodle8.mods.galacticraft.moon.dimension.GCMoonTeleportType;
import micdoodle8.mods.galacticraft.moon.dimension.GCMoonWorldProvider;
import micdoodle8.mods.galacticraft.moon.items.GCMoonItems;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;
import universalelectricity.prefab.TranslationHelper;

public class GalacticraftMoon {
    public static final String NAME = "Galacticraft Moon";
    public static final String MODID = "GalacticraftMoon";
    public static final String FILE_PATH = "/micdoodle8/mods/galacticraft/moon/";
    public static final String CLIENT_PATH = "client/";
    public static final String LANGUAGE_PATH = "/micdoodle8/mods/galacticraft/moon/client/lang/";
    public static final String BLOCK_TEXTURE_FILE = "/micdoodle8/mods/galacticraft/moon/client/blocks/moon.png";
    public static final String ITEM_TEXTURE_FILE = "/micdoodle8/mods/galacticraft/moon/client/items/moon.png";
    public static final String CONFIG_FILE = "Galacticraft/moon.conf";
    private static final String[] LANGUAGES_SUPPORTED = new String[]{"cz_CZE", "de_DE", "en_GB", "en_US", "es_ES", "fi_FI", "fr_FR", "ja_JP", "nl_NL", "pl_PL", "ru_RU", "zh_CN"};
    public static GCCoreCreativeTab galacticraftMoonTab;
    public static IMoon celestialBodyMoon;

    public void preLoad(FMLPreInitializationEvent event) {
        new GCMoonConfigManager(new File(event.getModConfigurationDirectory(), CONFIG_FILE));
        GCMoonBlocks.initBlocks();
        GCMoonBlocks.registerBlocks();
        GCMoonBlocks.setHarvestLevels();
        GCMoonItems.initItems();
    }

    public void load(FMLInitializationEvent event) {
        galacticraftMoonTab = new GCCoreCreativeTab(CreativeTabs.getNextID(), MODID, GCMoonBlocks.blockMoon.field_71990_ca, 5);
        celestialBodyMoon = new GCMoonCelestialBody();
        GalacticraftRegistry.registerCelestialBody(celestialBodyMoon);
        System.out.println("Galacticraft Moon Loaded: " + TranslationHelper.loadLanguages(LANGUAGE_PATH, LANGUAGES_SUPPORTED) + " Languages.");
        GalacticraftRegistry.registerTeleportType(GCMoonWorldProvider.class, new GCMoonTeleportType());
        GalacticraftMoon.addCraftingRecipes();
        GalacticraftMoon.addSmeltingRecipes();
    }

    public void postLoad(FMLPostInitializationEvent event) {
    }

    public void serverInit(FMLServerStartedEvent event) {
        TickRegistry.registerTickHandler((ITickHandler)new CommonTickHandler(), (Side)Side.SERVER);
    }

    public void serverStarting(FMLServerStartingEvent event) {
    }

    public static void addCraftingRecipes() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(GCMoonItems.cheeseBlock, 1), new Object[]{"YYY", "YXY", "YYY", Character.valueOf('X'), Item.field_77771_aG, Character.valueOf('Y'), GCMoonItems.cheeseCurd});
    }

    public static void addSmeltingRecipes() {
        FurnaceRecipes.func_77602_a().func_77600_a(GCMoonItems.meteoricIronRaw.field_77779_bT, new ItemStack(GCMoonItems.meteoricIronIngot), 1.0f);
        if (OreDictionary.getOres((String)"ingotCopper").size() > 0) {
            FurnaceRecipes.func_77602_a().addSmelting(GCMoonBlocks.blockMoon.field_71990_ca, 0, (ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0), 1.0f);
        }
        if (OreDictionary.getOres((String)"ingotTin").size() > 0) {
            FurnaceRecipes.func_77602_a().addSmelting(GCMoonBlocks.blockMoon.field_71990_ca, 1, (ItemStack)OreDictionary.getOres((String)"ingotTin").get(0), 1.0f);
        }
        FurnaceRecipes.func_77602_a().addSmelting(GCMoonBlocks.blockMoon.field_71990_ca, 2, new ItemStack(GCMoonItems.cheeseCurd), 1.0f);
    }

    public class CommonTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            if (type.equals(EnumSet.of(TickType.WORLD))) {
                // empty if block
            }
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.WORLD);
        }

        public String getLabel() {
            return "Galacticraft Moon Common";
        }
    }
}

