/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IMapObject;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.client.GCCorePlayerSP;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreSpaceStationData;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreWorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.entities.planet.IUpdateable;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketDimensionListPlanets;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketDimensionListSpaceStations;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSpaceStationData;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.moon.dimension.GCMoonWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import universalelectricity.core.vector.Vector3;

public class WorldUtil {
    public static Collection<Integer> registeredSpaceStations;
    public static Collection<Integer> registeredPlanets;
    public static Collection<String> registeredPlanetNames;
    public static List<ItemStack> useless;
    public static List<ItemStack> common;
    public static List<ItemStack> uncommon;
    public static List<ItemStack> rare;
    public static List<ItemStack> ultrarare;
    public static List<IUpdateable> updateableObjects;
    private static MinecraftServer mcServer;

    public static void updatePlanets() {
        ArrayList<IUpdateable> planetList = new ArrayList<IUpdateable>();
        planetList.addAll(updateableObjects);
        for (IUpdateable planet : planetList) {
            planet.update();
        }
    }

    public static double getGravityForEntity(EntityLivingBase eLiving) {
        if (eLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)eLiving.field_70170_p.field_73011_w;
            if (eLiving instanceof EntityPlayer) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && eLiving instanceof GCCorePlayerSP) {
                    return ((GCCorePlayerSP)eLiving).touchedGround ? 0.08 - (double)customProvider.getGravity() : 0.08;
                }
                if (eLiving instanceof GCCorePlayerMP) {
                    return ((GCCorePlayerMP)eLiving).isTouchedGround() ? 0.08 - (double)customProvider.getGravity() : 0.08;
                }
                return 0.08;
            }
            return 0.08 - (double)customProvider.getGravity();
        }
        return 0.08;
    }

    public static double getItemGravity(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.field_70170_p.field_73011_w;
            return (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75;
        }
        return 0.04f;
    }

    public static double getItemGravity2(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            return 1.0;
        }
        return 0.98f;
    }

    public static Vector3 getWorldColor(World world) {
        if (world.field_73011_w instanceof GCMoonWorldProvider) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            double d = 1.0 - (double)(f2 * f2) * 0.7;
            return new Vector3(d, d, d);
        }
        return new Vector3(1.0, 1.0, 1.0);
    }

    public static float getColorRed(World world) {
        return (float)WorldUtil.getWorldColor((World)world).x;
    }

    public static float getColorGreen(World world) {
        return (float)WorldUtil.getWorldColor((World)world).y;
    }

    public static float getColorBlue(World world) {
        return (float)WorldUtil.getWorldColor((World)world).z;
    }

    public static Vec3 getFogColorHook(World world) {
        if (world.field_73011_w instanceof WorldProviderSurface && FMLClientHandler.instance().getClient().field_71439_g.field_70163_u >= 200.0) {
            float var20 = (float)(FMLClientHandler.instance().getClient().field_71439_g.field_70163_u - 200.0) / 1000.0f;
            float var21 = Math.max(1.0f - var20 * 4.0f, 0.0f);
            Vec3 vec = world.func_72948_g(1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)var21), (double)(vec.field_72448_b * (double)var21), (double)(vec.field_72449_c * (double)var21));
        }
        return world.func_72948_g(1.0f);
    }

    public static Vec3 getSkyColorHook(World world) {
        if (world.field_73011_w instanceof WorldProviderSurface && FMLClientHandler.instance().getClient().field_71439_g.field_70163_u >= 200.0) {
            float var20 = (float)(FMLClientHandler.instance().getClient().field_71439_g.field_70163_u - 200.0) / 1000.0f;
            float var21 = Math.max(1.0f - var20 * 2.0f, 0.0f);
            Vec3 vec = world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)var21), (double)(vec.field_72448_b * (double)var21), (double)(vec.field_72449_c * (double)var21));
        }
        return world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
    }

    public static boolean generateChestContents(World var1, Random var2, int var3, int var4, int var5) {
        int var7;
        boolean var6 = true;
        var1.func_72832_d(var3, var4, var5, Block.field_72077_au.field_71990_ca, 0, 3);
        for (var7 = 0; var7 < 4; ++var7) {
            var6 &= WorldUtil.addItemToChest(var1, var2, var3, var4, var5, WorldUtil.getCommonItem(var2));
        }
        for (var7 = 0; var7 < 2; ++var7) {
            var6 &= WorldUtil.addItemToChest(var1, var2, var3, var4, var5, WorldUtil.getUncommonItem(var2));
        }
        for (var7 = 0; var7 < 1; ++var7) {
            var6 &= WorldUtil.addItemToChest(var1, var2, var3, var4, var5, WorldUtil.getRareItem(var2));
        }
        return var6;
    }

    public static ItemStack getCommonItem(Random var1) {
        return var1.nextInt(4) == 0 ? WorldUtil.getRandomItemFromList(useless, var1) : WorldUtil.getRandomItemFromList(common, var1);
    }

    public static ItemStack getUncommonItem(Random var1) {
        return WorldUtil.getRandomItemFromList(uncommon, var1);
    }

    public static ItemStack getRareItem(Random var1) {
        return var1.nextInt(4) == 0 ? WorldUtil.getRandomItemFromList(ultrarare, var1) : WorldUtil.getRandomItemFromList(rare, var1);
    }

    public static ItemStack getRandomItemFromList(List list, Random rand) {
        return (ItemStack)list.get(rand.nextInt(list.size()));
    }

    protected static boolean addItemToChest(World var1, Random var2, int var3, int var4, int var5, ItemStack var6) {
        int var8;
        TileEntityChest var7 = (TileEntityChest)var1.func_72796_p(var3, var4, var5);
        if (var7 != null && (var8 = WorldUtil.findRandomInventorySlot(var7, var2)) != -1) {
            var7.func_70299_a(var8, var6);
            return true;
        }
        return false;
    }

    protected static int findRandomInventorySlot(TileEntityChest var1, Random var2) {
        for (int var3 = 0; var3 < 100; ++var3) {
            int var4 = var2.nextInt(var1.func_70302_i_());
            if (var1.func_70301_a(var4) != null) continue;
            return var4;
        }
        return -1;
    }

    public static WorldProvider getProviderForName(String par1String) {
        Integer[] var1;
        for (Integer element : var1 = WorldUtil.getArrayOfPossibleDimensions()) {
            if (WorldProvider.func_76570_a((int)element) == null || WorldProvider.func_76570_a((int)element).func_80007_l() == null) continue;
            if (par1String.contains("$")) {
                String[] twoDimensions = par1String.split("\\$");
                if (!WorldProvider.func_76570_a((int)element).func_80007_l().equals(twoDimensions[0])) continue;
                return WorldProvider.func_76570_a((int)element);
            }
            if (!WorldProvider.func_76570_a((int)element).func_80007_l().equals(par1String)) continue;
            return WorldProvider.func_76570_a((int)element);
        }
        return null;
    }

    public static int getAmountOfPossibleProviders(Integer[] ids) {
        int amount = 0;
        for (Integer id : ids) {
            if (!(WorldProvider.func_76570_a((int)id) instanceof IGalacticraftWorldProvider) && WorldProvider.func_76570_a((int)id.intValue()).field_76574_g != 0) continue;
            ++amount;
        }
        return amount;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier) {
        WorldProvider provider;
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(0);
        for (Integer element : registeredPlanets) {
            provider = WorldProvider.func_76570_a((int)element);
            if (provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        for (Integer element : registeredSpaceStations) {
            provider = WorldProvider.func_76570_a((int)element);
            if (provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(Integer[] ids) {
        return WorldUtil.getArrayOfPossibleDimensions(ids, null);
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(Integer[] ids, GCCorePlayerMP playerBase) {
        return WorldUtil.getArrayOfPossibleDimensions(Arrays.asList(ids), playerBase);
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(List<Integer> ids, GCCorePlayerMP playerBase) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Integer id : ids) {
            if (WorldProvider.func_76570_a((int)id) == null) continue;
            if (WorldProvider.func_76570_a((int)id) instanceof IGalacticraftWorldProvider && !(WorldProvider.func_76570_a((int)id) instanceof IOrbitDimension) || WorldProvider.func_76570_a((int)id.intValue()).field_76574_g == 0) {
                map.put(WorldProvider.func_76570_a((int)id).func_80007_l(), WorldProvider.func_76570_a((int)id.intValue()).field_76574_g);
                continue;
            }
            if (playerBase == null || !(WorldProvider.func_76570_a((int)id) instanceof IOrbitDimension)) continue;
            GCCoreSpaceStationData data = GCCoreSpaceStationData.getStationData(playerBase.field_70170_p, id, (EntityPlayer)playerBase);
            if (GCCoreConfigManager.spaceStationsRequirePermission && !data.getAllowedPlayers().contains(playerBase.field_71092_bJ.toLowerCase()) && !data.getAllowedPlayers().contains(playerBase.field_71092_bJ)) continue;
            map.put(WorldProvider.func_76570_a((int)id).func_80007_l() + "$" + data.getOwner() + "$" + data.getSpaceStationName(), WorldProvider.func_76570_a((int)id.intValue()).field_76574_g);
        }
        for (int j = 0; j < GalacticraftRegistry.getCelestialBodies().size(); ++j) {
            ICelestialBody object = GalacticraftRegistry.getCelestialBodies().get(j);
            if (object.isReachable() || !object.addToList()) continue;
            map.put(object.getName() + "*", 0);
        }
        return map;
    }

    public static double getSpaceshipFailChance(EntityPlayer player) {
        Double level = player.field_71068_ca;
        if (level <= 50.0) {
            return 12.5 - level / 4.0;
        }
        return 0.0;
    }

    public static float calculateMarsAngleFromOtherPlanet(long par1, float par3) {
        int var4 = (int)(par1 % 48000L);
        float var5 = ((float)var4 + par3) / 48000.0f - 0.25f;
        if (var5 < 0.0f) {
            var5 += 1.0f;
        }
        if (var5 > 1.0f) {
            var5 -= 1.0f;
        }
        float var6 = var5;
        var5 = 1.0f - (float)((Math.cos((double)var5 * Math.PI) + 1.0) / 2.0);
        var5 = var6 + (var5 - var6) / 3.0f;
        return var5;
    }

    public static float calculateEarthAngleFromOtherPlanet(long par1, float par3) {
        int var4 = (int)(par1 % 48000L);
        float var5 = ((float)var4 + par3) / 48000.0f - 0.25f;
        if (var5 < 0.0f) {
            var5 += 1.0f;
        }
        if (var5 > 1.0f) {
            var5 -= 1.0f;
        }
        float var6 = var5;
        var5 = 1.0f - (float)((Math.cos((double)var5 * Math.PI) + 1.0) / 2.0);
        var5 = var6 + (var5 - var6) / 3.0f;
        return var5;
    }

    public static List getPlayersOnPlanet(IMapObject planet) {
        ArrayList<String> list = new ArrayList<String>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            if (world == null || !(world.field_73011_w instanceof IGalacticraftWorldProvider) || !planet.getSlotRenderer().getPlanetName().toLowerCase().equals(world.field_73011_w.func_80007_l().toLowerCase())) continue;
            for (int j = 0; j < world.func_72910_y().size(); ++j) {
                if (world.func_72910_y().get(j) == null || !(world.func_72910_y().get(j) instanceof EntityPlayer)) continue;
                list.add(((EntityPlayer)world.func_72910_y().get((int)j)).field_71092_bJ);
            }
        }
        return list;
    }

    private static List getExistingSpaceStationList(File var0) {
        ArrayList<Integer> var1 = new ArrayList<Integer>();
        for (File var5 : var0.listFiles()) {
            if (!var5.getName().contains("spacestation_")) continue;
            String var6 = var5.getName();
            var6 = var6.substring(13, var6.length() - 4);
            var1.add(Integer.parseInt(var6));
        }
        return var1;
    }

    public static void unregisterSpaceStations() {
        if (registeredSpaceStations != null) {
            for (Integer var1 : registeredSpaceStations) {
                DimensionManager.unregisterDimension((int)var1);
            }
            registeredSpaceStations = null;
        }
    }

    public static void registerSpaceStations(File var0) {
        registeredSpaceStations = WorldUtil.getExistingSpaceStationList(var0);
        for (Integer var2 : registeredSpaceStations) {
            DimensionManager.registerDimension((int)var2, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
        }
    }

    public static void registerPlanet(int planetID, boolean isStatic) {
        if (registeredPlanets == null) {
            registeredPlanets = new ArrayList<Integer>();
        }
        registeredPlanets.add(planetID);
        if (isStatic) {
            DimensionManager.registerDimension((int)planetID, (int)planetID);
            GCLog.info("Registered Dimension: " + planetID);
        }
    }

    public static void unregisterPlanets() {
        if (registeredPlanets != null) {
            for (Integer var1 : registeredPlanets) {
                DimensionManager.unregisterDimension((int)var1);
                GCLog.info("Unregistered Dimension: " + var1);
            }
            registeredPlanets = null;
        }
    }

    public static Integer[] getArrayOfPossibleDimensions() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(0);
        for (Integer i : registeredPlanets) {
            temp.add(i);
        }
        for (Integer i : registeredSpaceStations) {
            temp.add(i);
        }
        Integer[] finalArray = new Integer[temp.size()];
        int count = 0;
        for (Integer integ : temp) {
            finalArray[count++] = integ;
        }
        return finalArray;
    }

    public static GCCoreSpaceStationData bindSpaceStationToNewDimension(World var0, GCCorePlayerMP player) {
        int newID = DimensionManager.getNextFreeDimId();
        GCCoreSpaceStationData data = WorldUtil.createSpaceStation(var0, newID, player);
        player.setSpaceStationDimensionID(newID);
        player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 18, new Object[]{newID}));
        return data;
    }

    public static GCCoreSpaceStationData createSpaceStation(World var0, int par1, GCCorePlayerMP player) {
        registeredSpaceStations.add(par1);
        DimensionManager.registerDimension((int)par1, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
        MinecraftServer var2 = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (var2 != null) {
            ArrayList<Integer> var1 = new ArrayList<Integer>();
            var1.add(par1);
            var2.func_71203_ab().func_72384_a(GCCorePacketDimensionListSpaceStations.buildDimensionListPacket(var1));
        }
        GCCoreSpaceStationData var3 = GCCoreSpaceStationData.getStationData(var0, par1, (EntityPlayer)player);
        return var3;
    }

    public static void transferEntityToDimension(Entity entity, int dimensionID, WorldServer world) {
        WorldUtil.transferEntityToDimension(entity, dimensionID, world, true);
    }

    public static void transferEntityToDimension(Entity entity, int dimensionID, WorldServer world, boolean transferInv) {
        if (!world.field_72995_K) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                ArrayList<Integer> array = new ArrayList<Integer>();
                for (int i : registeredPlanets) {
                    array.add(i);
                }
                server.func_71203_ab().func_72384_a(GCCorePacketDimensionListPlanets.buildDimensionListPacket(array));
            }
            if (mcServer == null) {
                mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            }
            if (mcServer != null) {
                ITeleportType type;
                WorldServer var6 = mcServer.func_71218_a(dimensionID);
                if (var6 == null) {
                    System.err.println("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                }
                if ((type = GalacticraftRegistry.getTeleportTypeForDimension(var6.field_73011_w.getClass())) != null) {
                    WorldUtil.teleportEntity((World)var6, entity, dimensionID, type, transferInv);
                }
            }
        }
    }

    private static Entity teleportEntity(World var0, Entity var1, int var2, ITeleportType type, boolean transferInv) {
        Entity var6 = var1.field_70154_o;
        if (var1.field_70154_o != null && var1.field_70154_o instanceof EntitySpaceshipBase) {
            var1.func_70078_a(var1.field_70154_o);
        }
        boolean var7 = var1.field_70170_p != var0;
        var1.field_70170_p.func_72866_a(var1, false);
        GCCorePlayerMP var8 = null;
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            var8.func_71053_j();
            if (var7) {
                var8.field_71093_bK = var2;
                var8.field_71135_a.func_72567_b((Packet)new Packet9Respawn(var8.field_71093_bK, (byte)var8.field_70170_p.field_73013_u, var0.func_72912_H().func_76067_t(), var0.func_72800_K(), var8.field_71134_c.func_73081_b()));
                if (var0.field_73011_w instanceof GCCoreWorldProviderSpaceStation && registeredSpaceStations.contains((Object)var8)) {
                    var8.field_71135_a.func_72567_b(GCCorePacketSpaceStationData.buildSpaceStationDataPacket(var0, var0.field_73011_w.field_76574_g, var8));
                }
                ((WorldServer)var1.field_70170_p).func_73040_p().func_72695_c((EntityPlayerMP)var8);
            }
            var8.setNotUsingPlanetGui();
        }
        if (var7) {
            WorldUtil.removeEntityFromWorld(var1.field_70170_p, var1);
        }
        if (var7 && var1 instanceof EntityPlayerMP) {
            var1.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).z, var1.field_70177_z, var1.field_70125_A);
            ((WorldServer)var0).field_73059_b.func_73158_c(var0.func_72964_e((int)type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).getIntX(), (int)type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).getIntZ()).func_76632_l().field_77276_a, var0.func_72964_e((int)type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).getIntX(), (int)type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).getIntZ()).func_76632_l().field_77275_b);
        }
        if (var7 && var1 instanceof EntityPlayer) {
            var1.func_70107_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).z);
        }
        if (var7) {
            if (!(var1 instanceof EntityPlayer)) {
                NBTTagCompound var11 = new NBTTagCompound();
                var1.field_70128_L = false;
                var1.func_70039_c(var11);
                var1.field_70128_L = true;
                var1 = EntityList.func_75615_a((NBTTagCompound)var11, (World)var0);
                if (var1 == null) {
                    return null;
                }
            }
            var0.func_72838_d(var1);
            var1.func_70029_a(var0);
        }
        if (var7 && var1 instanceof EntityPlayer) {
            var1.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).z, var1.field_70177_z, var1.field_70125_A);
        }
        var0.func_72866_a(var1, false);
        if (var7 && var1 instanceof EntityPlayer) {
            var1.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).z, var1.field_70177_z, var1.field_70125_A);
        }
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            if (var7) {
                var8.field_71133_b.func_71203_ab().func_72375_a((EntityPlayerMP)var8, (WorldServer)var0);
            }
            var8.field_71135_a.func_72569_a(type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).z, var1.field_70177_z, var1.field_70125_A);
            GCLog.info("Server attempting to transfer player " + var8.field_71092_bJ + " to dimension " + var0.field_73011_w.field_76574_g);
        }
        var0.func_72866_a(var1, false);
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            if (type.useParachute()) {
                var8.setUsingParachute(true);
            }
        }
        if (var1 instanceof GCCorePlayerMP && var7) {
            var8 = (GCCorePlayerMP)var1;
            var8.field_71134_c.func_73080_a((WorldServer)var0);
            var8.field_71133_b.func_71203_ab().func_72354_b((EntityPlayerMP)var8, (WorldServer)var0);
            var8.field_71133_b.func_71203_ab().func_72385_f((EntityPlayerMP)var8);
            for (PotionEffect var10 : var8.func_70651_bq()) {
                var8.field_71135_a.func_72567_b((Packet)new Packet41EntityEffect(var8.field_70157_k, var10));
            }
            var8.field_71135_a.func_72567_b((Packet)new Packet43Experience(var8.field_71106_cc, var8.field_71067_cb, var8.field_71068_ca));
        }
        if (var8 != null) {
            var1.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)var1)).z, var1.field_70177_z, var1.field_70125_A);
        } else {
            var1.func_70012_b(type.getEntitySpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (Entity)var1).x, type.getEntitySpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (Entity)var1).y, type.getEntitySpawnLocation((WorldServer)((WorldServer)var1.field_70170_p), (Entity)var1).z, var1.field_70177_z, var1.field_70125_A);
        }
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            if (var8.getRocketStacks() != null && var8.getRocketStacks().length > 0) {
                for (int i = 0; i < var8.getRocketStacks().length; ++i) {
                    if (transferInv) {
                        if (var8.getRocketStacks()[i] != null) continue;
                        if (i == var8.getRocketStacks().length - 1) {
                            var8.getRocketStacks()[i] = new ItemStack(GCCoreItems.spaceship, 1, var8.getRocketType());
                            continue;
                        }
                        if (i != var8.getRocketStacks().length - 2) continue;
                        var8.getRocketStacks()[i] = new ItemStack(GCCoreBlocks.landingPad, 9, 0);
                        continue;
                    }
                    var8.getRocketStacks()[i] = null;
                }
            }
            if (transferInv && var8.getChestSpawnCooldown() == 0) {
                var8.setChestSpawnVector(type.getParaChestSpawnLocation((WorldServer)var1.field_70170_p, var8, new Random()));
                var8.setChestSpawnCooldown(200);
            }
        }
        if (var1 != null && var6 != null) {
            if (var1 instanceof EntityPlayerMP) {
                var0.func_72866_a(var1, true);
            }
            var1.func_70078_a(var6);
        }
        if (var1 instanceof EntityPlayerMP) {
            GameRegistry.onPlayerChangedDimension((EntityPlayer)((EntityPlayerMP)var1));
            type.onSpaceDimensionChanged(var0, (EntityPlayerMP)var1);
        }
        return var1;
    }

    private static void removeEntityFromWorld(World var0, Entity var1) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            var2.func_71053_j();
            var0.field_73010_i.remove(var2);
            var0.func_72854_c();
            int var3 = var1.field_70176_ah;
            int var4 = var1.field_70164_aj;
            if (var1.field_70175_ag && var0.func_72863_F().func_73149_a(var3, var4)) {
                var0.func_72964_e(var3, var4).func_76622_b(var1);
                var0.func_72964_e((int)var3, (int)var4).field_76643_l = true;
            }
            var0.field_72996_f.remove(var1);
            var0.func_72847_b(var1);
        }
        var1.field_70128_L = false;
    }

    public static SpaceStationRecipe getSpaceStationRecipe(int planetID) {
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != planetID) continue;
            return type.getRecipeForSpaceStation();
        }
        return null;
    }

    static {
        useless = new ArrayList<ItemStack>();
        common = new ArrayList<ItemStack>();
        uncommon = new ArrayList<ItemStack>();
        rare = new ArrayList<ItemStack>();
        ultrarare = new ArrayList<ItemStack>();
        updateableObjects = new ArrayList<IUpdateable>();
        mcServer = null;
    }
}

