/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.LanguageRegistry;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.ITubeConnection;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntityOxygenCollector
extends GCCoreTileEntityElectric
implements ITubeConnection,
IInventory,
ISidedInventory {
    public boolean active;
    public static final float WATTS_PER_TICK = 0.2f;
    public double power;
    public int MAX_POWER = 180;
    public int outputSpeed = 16;
    private ItemStack[] containingItems = new ItemStack[1];

    public GCCoreTileEntityOxygenCollector() {
        super(0.2f, 50.0f);
    }

    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor(this.power / (double)this.MAX_POWER * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.getEnergyStored() > 0.0f && this.getPower() > 0.0) {
                for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                    if (orientation != ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)).getOpposite()) continue;
                    GasTransmission.emitGasToNetwork(EnumGas.OXYGEN, (int)Math.min(this.getPower(), (double)this.outputSpeed), this, orientation);
                    TileEntity tileEntity = VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), orientation);
                    if (!(tileEntity instanceof IGasAcceptor) || !((IGasAcceptor)tileEntity).canReceiveGas(orientation.getOpposite(), EnumGas.OXYGEN)) continue;
                    double sendingGas = 0.0;
                    if (this.getPower() >= (double)this.outputSpeed) {
                        sendingGas = this.outputSpeed;
                    } else if (this.getPower() < (double)this.outputSpeed) {
                        sendingGas = this.getPower();
                    }
                    ((IGasAcceptor)tileEntity).transferGasToAcceptor(MathHelper.func_76128_c((double)sendingGas), EnumGas.OXYGEN);
                }
            }
            double power = 0.0;
            if (this.getEnergyStored() > 0.0f) {
                if (this.field_70331_k.field_73011_w instanceof IGalacticraftWorldProvider) {
                    for (int y = this.field_70330_m - 5; y <= this.field_70330_m + 5; ++y) {
                        for (int x = this.field_70329_l - 5; x <= this.field_70329_l + 5; ++x) {
                            for (int z = this.field_70327_n - 5; z <= this.field_70327_n + 5; ++z) {
                                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, y, z)];
                                if (block == null) continue;
                                if (this.field_70331_k.func_72803_f(x, y, z) == Material.field_76257_i) {
                                    if (!this.field_70331_k.field_72995_K && this.field_70331_k.field_73012_v.nextInt(100000) == 0 && !GCCoreConfigManager.disableLeafDecay) {
                                        this.field_70331_k.func_94571_i(x, y, z);
                                    }
                                    power += 1.0;
                                    continue;
                                }
                                if (!(block instanceof IPlantable) || ((IPlantable)block).getPlantType(this.field_70331_k, x, y, z) != EnumPlantType.Crop) continue;
                                power += 2.0;
                            }
                        }
                    }
                    power /= 1.2;
                } else {
                    power = this.MAX_POWER;
                }
                if (power < this.getPower()) {
                    this.setPower(this.getPower() - 1.0);
                } else if (power > this.getPower()) {
                    this.setPower(this.getPower() + 1.0);
                }
            }
            if (!this.field_70331_k.field_72995_K && this.getEnergyStored() == 0.0f) {
                this.setPower(Math.min((double)this.MAX_POWER, Math.max(this.getPower() - 1.0, 0.0)));
            }
            this.setPower(Math.min((double)this.MAX_POWER, Math.max(this.getPower(), 0.0)));
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.setPower(par1NBTTagCompound.func_74769_h("storedOxygenD"));
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74780_a("storedOxygenD", this.getPower());
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection direction) {
        return direction == ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)).getOpposite();
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization("container.oxygencollector.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 ? itemstack.func_77973_b() instanceof IItemElectric : false;
    }

    @Override
    public boolean shouldPullEnergy() {
        return this.getEnergyStored() <= this.getMaxEnergyStored() - this.ueWattsPerTick;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.getPower() > 0.0;
    }

    @Override
    public void readPacket(ByteArrayDataInput data) {
        if (this.field_70331_k.field_72995_K) {
            this.setPower(data.readDouble());
            this.setEnergyStored(data.readFloat());
            this.disabled = data.readBoolean();
        }
    }

    @Override
    public Packet getPacket() {
        return PacketManager.getPacket("GCCoreEntities", this, new Object[]{this.power, Float.valueOf(this.getEnergyStored()), this.disabled});
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_70322_n() + 2));
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }
}

