/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.LanguageRegistry;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntityCargoUnloader
extends GCCoreTileEntityElectric
implements IInventory,
ISidedInventory,
ICargoEntity {
    private ItemStack[] containingItems = new ItemStack[15];
    public static final float WATTS_PER_TICK = 0.15f;
    public boolean targetEmpty;
    public boolean targetNoInventory;
    public boolean noTarget;
    public ICargoEntity attachedFuelable;

    public GCCoreTileEntityCargoUnloader() {
        super(0.15f, 50.0f);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.ticks % 100L == 0L) {
                this.checkForCargoEntity();
            }
            if (this.attachedFuelable != null) {
                this.noTarget = false;
                ICargoEntity.RemovalResult result = this.attachedFuelable.removeCargo(false);
                if (result.resultStack != null) {
                    this.targetEmpty = false;
                    ICargoEntity.EnumCargoLoadingState state = this.addCargo(result.resultStack, false);
                    boolean bl = this.targetEmpty = state == ICargoEntity.EnumCargoLoadingState.EMPTY;
                    if (this.ticks % 15L == 0L && state == ICargoEntity.EnumCargoLoadingState.SUCCESS && !this.disabled && this.getEnergyStored() > 0.0f) {
                        this.addCargo(this.attachedFuelable.removeCargo((boolean)true).resultStack, true);
                    }
                } else {
                    this.targetNoInventory = result.resultState == ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
                    this.noTarget = result.resultState == ICargoEntity.EnumCargoLoadingState.NOTARGET;
                    this.targetEmpty = true;
                }
            } else {
                this.noTarget = true;
            }
        }
    }

    public void checkForCargoEntity() {
        boolean foundFuelable = false;
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN) continue;
            Vector3 vecAt = new Vector3(this);
            TileEntity pad = (vecAt = vecAt.modifyPositionFromSide(dir)).getTileEntity((IBlockAccess)this.field_70331_k);
            if (pad != null && pad instanceof TileEntityMulti) {
                TileEntity mainTile = ((TileEntityMulti)pad).mainBlockPosition.getTileEntity((IBlockAccess)this.field_70331_k);
                if (mainTile == null || !(mainTile instanceof ICargoEntity)) continue;
                this.attachedFuelable = (ICargoEntity)mainTile;
                foundFuelable = true;
                break;
            }
            if (pad == null || !(pad instanceof ICargoEntity)) continue;
            this.attachedFuelable = (ICargoEntity)pad;
            foundFuelable = true;
            break;
        }
        if (!foundFuelable) {
            this.attachedFuelable = null;
        }
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization("container.cargounloader.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.getOrientation((int)(this.func_70322_n() - 2)).getOpposite().ordinal()) {
            int[] nArray2 = new int[14];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 5;
            nArray2[5] = 6;
            nArray2[6] = 7;
            nArray2[7] = 8;
            nArray2[8] = 9;
            nArray2[9] = 10;
            nArray2[10] = 11;
            nArray2[11] = 12;
            nArray2[12] = 13;
            nArray = nArray2;
            nArray2[13] = 14;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (side == ForgeDirection.getOrientation((int)(this.func_70322_n() - 2)).getOpposite().ordinal()) {
            if (slotID == 0) {
                return itemstack.func_77973_b() instanceof IItemElectric;
            }
            return true;
        }
        return false;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IItemElectric;
        }
        return true;
    }

    @Override
    public boolean shouldPullEnergy() {
        return this.getEnergyStored() <= this.getMaxEnergyStored() - this.ueWattsPerTick;
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.getDisabled();
    }

    @Override
    public void readPacket(ByteArrayDataInput data) {
        if (this.field_70331_k.field_72995_K) {
            this.setEnergyStored(data.readFloat());
            this.disabled = data.readBoolean();
            this.disableCooldown = data.readInt();
            this.targetEmpty = data.readBoolean();
            this.noTarget = data.readBoolean();
            this.targetNoInventory = data.readBoolean();
        }
    }

    @Override
    public Packet getPacket() {
        return PacketManager.getPacket("GCCoreEntities", this, new Object[]{Float.valueOf(this.getEnergyStored()), this.disabled, this.disableCooldown, this.targetEmpty, this.noTarget, this.targetNoInventory});
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_70322_n() - 2));
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        int count = 1;
        for (count = 1; count < this.containingItems.length; ++count) {
            stackAt = this.containingItems[count];
            if (stackAt == null || stackAt.field_77993_c != stack.field_77993_c || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (doAdd) {
                this.containingItems[count].field_77994_a += stack.field_77994_a;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        for (count = 1; count < this.containingItems.length; ++count) {
            stackAt = this.containingItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.containingItems[count] = stack;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 1; i < this.containingItems.length; ++i) {
            ItemStack stackAt = this.containingItems[i];
            if (stackAt == null) continue;
            if (doRemove && --this.containingItems[i].field_77994_a <= 0) {
                this.containingItems[i] = null;
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, new ItemStack(stackAt.field_77993_c, 1, stackAt.func_77960_j()));
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }
}

