/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.nei.NEIGalacticraftConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RefineryRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation refineryGuiTexture = new ResourceLocation(GalacticraftCore.TEXTURE_DOMAIN, "textures/gui/refinery.png");
    int ticksPassed;

    public String getRecipeId() {
        return "galacticraft.refinery";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public Set<Map.Entry<PositionedStack, PositionedStack>> getRecipes() {
        return NEIGalacticraftConfig.getRefineryRecipes();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)refineryGuiTexture);
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)4, (int)168, (int)64);
        if (this.ticksPassed % 144 < 124 && this.ticksPassed % 144 > 10) {
            GuiDraw.drawTexturedModalRect((int)2, (int)42, (int)176, (int)6, (int)16, (int)20);
        } else if (this.ticksPassed % 144 < 134) {
            GuiDraw.drawTexturedModalRect((int)148, (int)42, (int)192, (int)6, (int)16, (int)20);
        }
        GuiDraw.drawTexturedModalRect((int)21, (int)21, (int)0, (int)186, (int)(this.ticksPassed % 144), (int)20);
    }

    public void onUpdate() {
        this.ticksPassed += 2;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedRefineryRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedRefineryRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)irecipe.getKey().item)) continue;
            this.arecipes.add(new CachedRefineryRecipe(irecipe));
            break;
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        if (this.ticksPassed % 144 > 10) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(new PositionedStack((Object)new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l()), ((PositionedStack)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get((int)recipe)).getIngredients().get((int)0)).relx, ((PositionedStack)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get((int)recipe)).getIngredients().get((int)0)).rely));
            return stacks;
        }
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (this.ticksPassed % 144 < 134) {
            return new PositionedStack((Object)new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l()), ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get((int)recipe)).getResult().relx, ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get((int)recipe)).getResult().rely);
        }
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    public String getRecipeName() {
        return "Refinery";
    }

    public String getGuiTexture() {
        return "/mods/galacticraftcore/textures/gui/refinery.png";
    }

    public class CachedRefineryRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedRefineryRecipe(PositionedStack pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)RefineryRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CachedRefineryRecipe(Map.Entry recipe) {
            this((PositionedStack)recipe.getKey(), (PositionedStack)recipe.getValue());
        }
    }
}

