/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import icbm.api.IMissile;
import icbm.api.IMissileLockable;
import icbm.api.RadarRegistry;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoPad;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import universalelectricity.core.vector.Vector3;

public class GCCoreEntityRocketT1
extends EntitySpaceshipBase
implements IInventory,
IMissileLockable {
    private final int tankCapacity = 1000;
    public FluidTank spaceshipFuelTank = new FluidTank(this.tankCapacity);
    protected ItemStack[] cargoItems;
    public IUpdatePlayerListBox rocketSoundUpdater;
    private IFuelDock landingPad;

    public GCCoreEntityRocketT1(World par1World) {
        super(par1World);
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.spaceshipFuelTank.getFluid() == null ? 0.0 : (double)this.spaceshipFuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public GCCoreEntityRocketT1(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World);
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
        this.rocketType = rocketType;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        RadarRegistry.register(this);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        RadarRegistry.unregister(this);
        if (this.rocketSoundUpdater != null) {
            this.rocketSoundUpdater.func_73660_a();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() && this.field_70146_Z.nextInt(i) == 0) && !GCCoreConfigManager.disableSpaceshipParticles && this.hasValidFuel() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.rocketSoundUpdater != null && (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() || this.getLaunched())) {
            this.rocketSoundUpdater.func_73660_a();
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase() && this.hasValidFuel()) {
            double d = this.timeSinceLaunch / 250.0f;
            if ((d = Math.min(d, 1.0)) != 0.0) {
                this.field_70181_x = -d * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    @Override
    public void readNetworkedData(ByteArrayDataInput dataStream) {
        super.readNetworkedData(dataStream);
        this.spaceshipFuelTank.setFluid(new FluidStack(GalacticraftCore.FUEL, dataStream.readInt()));
        if (this.cargoItems == null) {
            this.cargoItems = new ItemStack[this.func_70302_i_()];
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList list) {
        super.getNetworkedData(list);
        list.add(this.spaceshipFuelTank.getFluid() == null ? 0 : this.spaceshipFuelTank.getFluid().amount);
        return list;
    }

    @Override
    public boolean hasValidFuel() {
        return this.spaceshipFuelTank.getFluid() != null && this.spaceshipFuelTank.getFluid().amount != 0;
    }

    @Override
    public void onLaunch() {
    }

    @Override
    public void onTeleport(EntityPlayerMP player) {
        GCCorePlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player);
        player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, new Object[]{0}));
        if (playerBase != null) {
            if (this.cargoItems == null || this.cargoItems.length == 0) {
                playerBase.setRocketStacks(new ItemStack[9]);
            } else {
                playerBase.setRocketStacks(this.cargoItems);
            }
            playerBase.setRocketType(this.rocketType.getIndex());
            int liquid = this.spaceshipFuelTank.getFluid() == null ? 0 : this.spaceshipFuelTank.getFluid().amount;
            playerBase.setFuelLevel(liquid);
        }
    }

    protected void spawnParticles(boolean launched) {
        double x1 = 2.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double z1 = 2.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double y1 = 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
        double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r);
        if (!this.field_70128_L) {
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t + 0.4 + x1, y - 0.0 + y1, this.field_70161_v + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t - 0.4 + x1, y - 0.0 + y1, this.field_70161_v + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v + 0.4 + z1, x1, y1, z1, this.getLaunched());
            GalacticraftCore.proxy.spawnParticle("launchflame", this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v - 0.4 + z1, x1, y1, z1, this.getLaunched());
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70128_L ? false : par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    public int func_70302_i_() {
        return this.rocketType.getInventorySpace();
    }

    @Override
    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74774_a("Slot", (byte)var3);
                this.cargoItems[var3].func_77955_b(var4);
                var2.func_74742_a((NBTBase)var4);
            }
            par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
        }
        if (this.spaceshipFuelTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("fuelTank", (NBTBase)this.spaceshipFuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
            this.cargoItems = new ItemStack[this.func_70302_i_()];
            for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
                NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
                int var5 = var4.func_74771_c("Slot") & 0xFF;
                if (var5 >= 0 && var5 < this.cargoItems.length) {
                    this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
                    continue;
                }
                if (var5 != this.cargoItems.length) continue;
                this.cargoItems[var5 - 1] = ItemStack.func_77949_a((NBTTagCompound)var4);
            }
        }
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.spaceshipFuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
    }

    public ItemStack func_70301_a(int par1) {
        return this.cargoItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[par1].func_77979_a(par2);
            if (this.cargoItems[par1].field_77994_a == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization("container.spaceship.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getPreLaunchWait() {
        return 400;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(GCCoreItems.spaceship, 1, this.rocketType.getIndex()));
        if (this.cargoItems != null) {
            for (ItemStack item : this.cargoItems) {
                if (item == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getMaxFuel() {
        return this.spaceshipFuelTank.getCapacity();
    }

    @Override
    public boolean canLock(IMissile missile) {
        return true;
    }

    @Override
    public Vector3 getPredictedPosition(int ticks) {
        return new Vector3(this);
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        FluidStack liquidInTank = this.spaceshipFuelTank.getFluid();
        if (liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("Fuel") && (liquidInTank == null || liquidInTank.amount + liquid.amount <= this.spaceshipFuelTank.getCapacity())) {
            return this.spaceshipFuelTank.fill(liquid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        return this.spaceshipFuelTank.drain(amount, true);
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.rocketType.getInventorySpace() <= 3) {
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.cargoItems.length - 2; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt == null || stackAt.field_77993_c != stack.field_77993_c || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (doAdd) {
                this.cargoItems[count].field_77994_a += stack.field_77994_a;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        for (count = 0; count < this.cargoItems.length - 3; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.cargoItems[count] = stack;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.cargoItems.length - 2; ++i) {
            ItemStack stackAt = this.cargoItems[i];
            if (stackAt == null) continue;
            if (doRemove && --this.cargoItems[i].field_77994_a <= 0) {
                this.cargoItems[i] = null;
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, new ItemStack(stackAt.field_77993_c, 1, stackAt.func_77960_j()));
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof GCCoreTileEntityLandingPad || dock instanceof GCCoreTileEntityCargoPad;
    }

    @Override
    public void destroyCraft() {
        this.func_70106_y();
    }

    @Override
    public int doDamage(int damage) {
        return (int)(this.shipDamage += (float)damage);
    }

    @Override
    public boolean canBeTargeted(Object entity) {
        return this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase() && this.timeSinceLaunch > 50.0f;
    }

    @Override
    public int getRocketTier() {
        return 1;
    }
}

