/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.api.IMissileLockable;
import icbm.api.sentry.IAATarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreDamageSource;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockLandingPad;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public abstract class EntitySpaceshipBase
extends Entity
implements IPacketReceiver,
IMissileLockable,
IAATarget,
IDockable,
IInventory,
IRocketType {
    public int launchPhase = EnumLaunchPhase.UNIGNITED.getPhase();
    protected long ticks = 0L;
    protected double dragAir;
    public int timeUntilLaunch;
    public float timeSinceLaunch;
    public float rumble;
    public float rollAmplitude;
    public float shipDamage;
    public IRocketType.EnumRocketType rocketType;

    public EntitySpaceshipBase(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 4.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.field_70158_ak = true;
        this.field_70155_l = 5.0;
    }

    public abstract int getMaxFuel();

    public abstract int getScaledFuelLevel(int var1);

    public abstract boolean hasValidFuel();

    public abstract int getPreLaunchWait();

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70106_y() {
        if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
            Object[] toSend2 = new Object[]{0};
            ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, toSend2));
        }
        super.func_70106_y();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_85032_ar() || this.field_70163_u > 300.0) {
                return false;
            }
            this.rollAmplitude = 10.0f;
            this.func_70018_K();
            this.shipDamage += par2 * 10.0f;
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.shipDamage = 100.0f;
            }
            if (this.shipDamage > 90.0f && !this.field_70170_p.field_72995_K) {
                if (this.field_70153_n != null) {
                    Object[] toSend2 = new Object[]{0};
                    ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, toSend2));
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70106_y();
                this.dropShipAsItem();
                return true;
            }
            return true;
        }
        return true;
    }

    public void dropShipAsItem() {
        if (this.getItemsDropped() == null || this.field_70170_p.field_72995_K) {
            return;
        }
        for (ItemStack item : this.getItemsDropped()) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public abstract List<ItemStack> getItemsDropped();

    public void func_70057_ab() {
        this.rollAmplitude = 5.0f;
        this.shipDamage += this.shipDamage * 10.0f;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70071_h_() {
        block31: {
            block30: {
                if (this.ticks >= Long.MAX_VALUE) {
                    this.ticks = 1L;
                }
                ++this.ticks;
                super.func_70071_h_();
                if (!this.field_70170_p.field_72995_K && this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
                    for (TileEntity tile : this.getLandingPad().getConnectedTiles()) {
                        if (this.field_70170_p.func_72796_p(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n) == null || !(this.field_70170_p.func_72796_p(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n) instanceof GCCoreTileEntityFuelLoader) || !(tile instanceof GCCoreTileEntityFuelLoader) || !(((GCCoreTileEntityFuelLoader)tile).getEnergyStored() > 0.0f) || this.launchPhase != EnumLaunchPhase.LAUNCHED.getPhase()) continue;
                        this.setPad(null);
                    }
                }
                if (this.rumble > 0.0f) {
                    this.rumble -= 1.0f;
                }
                if (this.rumble < 0.0f) {
                    this.rumble += 1.0f;
                }
                if (this.field_70153_n != null) {
                    this.field_70153_n.field_70165_t += (double)(this.rumble / 30.0f);
                    this.field_70153_n.field_70161_v += (double)(this.rumble / 30.0f);
                }
                double d = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                if (this.field_70163_u > d) {
                    this.teleport();
                }
                if (this.rollAmplitude > 0.0f) {
                    this.rollAmplitude -= 1.0f;
                }
                if (this.shipDamage > 0.0f) {
                    this.shipDamage -= 1.0f;
                }
                if (this.field_70163_u < 0.0) break block30;
                double d2 = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                if (!(this.field_70163_u > d2 + 10.0)) break block31;
            }
            this.func_70076_C();
        }
        if (this.launchPhase == EnumLaunchPhase.UNIGNITED.getPhase()) {
            this.timeUntilLaunch = this.getPreLaunchWait();
        }
        this.timeSinceLaunch = this.launchPhase == EnumLaunchPhase.LAUNCHED.getPhase() ? (this.timeSinceLaunch += 1.0f) : 0.0f;
        if (this.timeUntilLaunch > 0 && this.launchPhase == EnumLaunchPhase.IGNITED.getPhase()) {
            --this.timeUntilLaunch;
        }
        AxisAlignedBB box = null;
        box = this.field_70121_D.func_72314_b(0.2, 0.2, 0.2);
        List var15 = this.field_70170_p.func_72839_b((Entity)this, box);
        if (var15 != null && !var15.isEmpty()) {
            for (int var52 = 0; var52 < var15.size(); ++var52) {
                Entity var17 = (Entity)var15.get(var52);
                if (var17 == this.field_70153_n) continue;
                var17.func_70108_f((Entity)this);
            }
        }
        if (this.timeUntilLaunch == 0 && this.launchPhase == EnumLaunchPhase.IGNITED.getPhase()) {
            this.launchPhase = EnumLaunchPhase.LAUNCHED.getPhase();
            this.onLaunch();
            if (!this.field_70170_p.field_72995_K) {
                if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension) && this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
                    ((GCCorePlayerMP)this.field_70153_n).setCoordsTeleportedFromX(this.field_70153_n.field_70165_t);
                    ((GCCorePlayerMP)this.field_70153_n).setCoordsTeleportedFromZ(this.field_70153_n.field_70161_v);
                }
                int amountRemoved = 0;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            int id = this.field_70170_p.func_72798_a(x, y, z);
                            Block block = Block.field_71973_m[id];
                            if (block != null && block instanceof GCCoreBlockLandingPadFull && amountRemoved < 9) {
                                this.field_70170_p.func_94571_i(x, y, z);
                                amountRemoved = 9;
                            }
                            if (block == null || !(block instanceof GCCoreBlockLandingPad) || amountRemoved >= 9) continue;
                            this.field_70170_p.func_94571_i(x, y, z);
                            ++amountRemoved;
                        }
                    }
                }
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        if (this.launchPhase == EnumLaunchPhase.IGNITED.getPhase() || this.launchPhase == EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (this.field_70125_A > 90.0f) {
            this.field_70125_A = 90.0f;
        }
        if (this.field_70125_A < -90.0f) {
            this.field_70125_A = -90.0f;
        }
        this.field_70159_w = -(50.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0));
        this.field_70179_y = -(50.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0));
        if (this.timeSinceLaunch > 50.0f && this.field_70122_E) {
            this.failRocket();
        }
        if (this.launchPhase != EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K && this.ticks % 3L == 0L) {
            PacketManager.sendPacketToClients(GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, this.getNetworkedData(new ArrayList())), this.field_70170_p, new Vector3(this), 50.0);
        }
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.readNetworkedData(dataStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readNetworkedData(ByteArrayDataInput dataStream) {
        this.launchPhase = dataStream.readInt();
        this.timeSinceLaunch = dataStream.readFloat();
        this.timeUntilLaunch = dataStream.readInt();
        this.rocketType = IRocketType.EnumRocketType.values()[dataStream.readInt()];
    }

    public ArrayList getNetworkedData(ArrayList list) {
        list.add(this.launchPhase);
        list.add(Float.valueOf(this.timeSinceLaunch));
        list.add(this.timeUntilLaunch);
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        return list;
    }

    public void turnYaw(float f) {
        this.field_70177_z += f;
    }

    public void turnPitch(float f) {
        this.field_70125_A += f;
    }

    private void failRocket() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70097_a((DamageSource)GCCoreDamageSource.spaceshipCrash, 81.0f);
        }
        if (!GCCoreConfigManager.disableSpaceshipGrief) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70101_b(par7, par8);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("launchPhase", this.launchPhase);
        nbt.func_74768_a("timeUntilLaunch", this.timeUntilLaunch);
        nbt.func_74768_a("Type", this.rocketType.getIndex());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.timeUntilLaunch = nbt.func_74762_e("timeUntilLaunch");
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        boolean hasOldTags = false;
        if (nbt.func_74758_c().contains("launched")) {
            hasOldTags = true;
            boolean launched = nbt.func_74767_n("launched");
            if (launched) {
                this.launchPhase = EnumLaunchPhase.LAUNCHED.getPhase();
            }
        }
        if (nbt.func_74758_c().contains("ignite")) {
            hasOldTags = true;
            int ignite = nbt.func_74762_e("ignite");
            if (ignite == 1) {
                this.launchPhase = EnumLaunchPhase.IGNITED.getPhase();
            }
        }
        if (hasOldTags) {
            if (this.launchPhase != EnumLaunchPhase.LAUNCHED.getPhase() && this.launchPhase != EnumLaunchPhase.IGNITED.getPhase()) {
                this.launchPhase = EnumLaunchPhase.UNIGNITED.getPhase();
            }
        } else {
            this.launchPhase = nbt.func_74762_e("launchPhase");
        }
    }

    public boolean getLaunched() {
        return this.launchPhase == EnumLaunchPhase.LAUNCHED.getPhase();
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (this.launchPhase == EnumLaunchPhase.LAUNCHED.getPhase()) {
            return false;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                Object[] toSend = new Object[]{((EntityPlayerMP)this.field_70153_n).field_71092_bJ};
                ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 13, toSend));
                Object[] toSend2 = new Object[]{0};
                ((EntityPlayerMP)par1EntityPlayer).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, toSend2));
                ((GCCorePlayerMP)par1EntityPlayer).setChatCooldown(0);
                par1EntityPlayer.func_70078_a(null);
            }
            return true;
        }
        if (par1EntityPlayer instanceof GCCorePlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                Object[] toSend = new Object[]{par1EntityPlayer.field_71092_bJ};
                ((EntityPlayerMP)par1EntityPlayer).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 8, toSend));
                Object[] toSend2 = new Object[]{1};
                ((EntityPlayerMP)par1EntityPlayer).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, toSend2));
                ((GCCorePlayerMP)par1EntityPlayer).setChatCooldown(0);
                par1EntityPlayer.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }

    public void ignite() {
        this.launchPhase = EnumLaunchPhase.IGNITED.getPhase();
    }

    public double func_70042_X() {
        return -1.0;
    }

    public void teleport() {
        if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
            GCCorePlayerMP player = (GCCorePlayerMP)this.field_70153_n;
            HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(WorldUtil.getPossibleDimensionsForSpaceshipTier(this.getRocketTier()), player);
            String temp = "";
            int count = 0;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                temp = temp.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "." : ""));
                ++count;
            }
            player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 2, new Object[]{player.field_71092_bJ, temp}));
            player.setSpaceshipTier(this.getRocketTier());
            player.setUsingPlanetGui();
            this.onTeleport(player);
            player.func_70078_a(this);
            if (!this.field_70128_L) {
                this.func_70106_y();
            }
        }
    }

    public void onLaunch() {
    }

    public void onTeleport(EntityPlayerMP player) {
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    @Override
    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public static enum EnumLaunchPhase {
        UNIGNITED(1),
        IGNITED(2),
        LAUNCHED(3);

        private int phase;

        private EnumLaunchPhase(int phase) {
            this.phase = phase;
        }

        public int getPhase() {
            return this.phase;
        }
    }
}

