/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.ICelestialBodyRenderer;
import micdoodle8.mods.galacticraft.api.world.IGalaxy;
import micdoodle8.mods.galacticraft.api.world.IMapObject;
import micdoodle8.mods.galacticraft.api.world.IMoon;
import micdoodle8.mods.galacticraft.api.world.IPlanet;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiChoosePlanet;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiStarBackground;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GCCoreGuiGalaxyMap
extends GCCoreGuiStarBackground {
    private static final ResourceLocation guiTexture = new ResourceLocation(GalacticraftCore.TEXTURE_DOMAIN, "textures/gui/gui.png");
    private static int guiMapMinX;
    private static int guiMapMinY;
    private static int guiMapMaxX;
    private static int guiMapMaxY;
    protected float mouseX = 0.0f;
    protected float mouseY = 0.0f;
    protected double field_74117_m;
    protected double field_74115_n;
    protected double guiMapX;
    protected double guiMapY;
    protected double field_74124_q;
    protected double field_74123_r;
    private float zoom = 0.2f;
    EntityPlayer player;
    private ICelestialBody selectedPlanet = null;
    private String[] listOfDimensions;

    public GCCoreGuiGalaxyMap(EntityPlayer player) {
        this.player = player;
    }

    public GCCoreGuiGalaxyMap(EntityPlayer player, String[] listOfDimensions) {
        this.player = player;
        this.listOfDimensions = listOfDimensions;
    }

    public void func_73866_w_() {
        this.field_73882_e.field_71417_B.func_74372_a();
        this.guiMapX = this.field_74124_q = (double)(0 - this.field_73880_f / 4);
        this.field_74117_m = this.field_74124_q;
        this.guiMapY = this.field_74123_r = (double)(0 - this.field_73881_g / 4);
        this.field_74115_n = this.field_74123_r;
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
            this.field_73882_e.func_71373_a((GuiScreen)null);
            this.field_73882_e.func_71381_h();
        } else if (par2 == 1) {
            if (this.listOfDimensions != null) {
                FMLClientHandler.instance().getClient().field_71462_r = null;
                FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCCoreGuiChoosePlanet(this.player, this.listOfDimensions));
                this.field_73882_e.field_71415_G = true;
                this.field_73882_e.field_71417_B.func_74373_b();
            } else {
                super.func_73869_a(par1, par2);
            }
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        guiMapMinX = -250000 - this.field_73880_f;
        guiMapMaxX = 250000 + this.field_73880_f;
        guiMapMinY = -250000 - this.field_73881_g;
        guiMapMaxY = 250000 + this.field_73881_g;
        while (!Mouse.isButtonDown((int)0) && Mouse.next()) {
            float wheel = Mouse.getEventDWheel();
            if (!Mouse.hasWheel() || wheel == 0.0f) continue;
            wheel /= 7500.0f;
            if (this.zoom <= 0.0171f) {
                wheel /= 10.0f;
            }
            this.zoom = MathHelper.func_76131_a((float)(this.zoom + wheel), (float)0.0011000001f, (float)2.0f);
        }
        if (GCCoreConfigManager.wasdMapMovement) {
            if (Keyboard.isKeyDown((int)17)) {
                this.mouseY = 1.0f * (1.0f / (this.zoom * 2.0f));
            }
            if (Keyboard.isKeyDown((int)31)) {
                this.mouseY = -1.0f * (1.0f / (this.zoom * 2.0f));
            }
            if (Keyboard.isKeyDown((int)32)) {
                this.mouseX = -1.0f * (1.0f / (this.zoom * 2.0f));
            }
            if (Keyboard.isKeyDown((int)30)) {
                this.mouseX = 1.0f * (1.0f / (this.zoom * 2.0f));
            }
            this.mouseY = (float)((double)this.mouseY * 0.9);
            this.mouseX = (float)((double)this.mouseX * 0.9);
        } else {
            this.mouseY = (float)(-(this.field_73882_e.field_71440_d / 2) + Mouse.getY()) / 100.0f * (1.0f / (this.zoom * 5.0f));
            this.mouseX = (float)(this.field_73882_e.field_71443_c / 2 - Mouse.getX()) / 100.0f * (1.0f / (this.zoom * 5.0f));
            if (Mouse.getX() > this.field_73882_e.field_71443_c / 2 - 90 && Mouse.getX() < this.field_73882_e.field_71443_c / 2 + 90 && Mouse.getY() > this.field_73882_e.field_71440_d / 2 - 90 && Mouse.getY() < this.field_73882_e.field_71440_d / 2 + 90) {
                this.mouseX = 0.0f;
                this.mouseY = 0.0f;
            }
        }
        if (this.field_74124_q < (double)guiMapMinX) {
            this.field_74124_q = guiMapMinX;
            if (this.mouseX > 0.0f) {
                this.mouseX = 0.0f;
            }
        }
        if (this.field_74123_r < (double)guiMapMinY) {
            this.field_74123_r = guiMapMinY;
            if (this.mouseY > 0.0f) {
                this.mouseY = 0.0f;
            }
        }
        if (this.field_74124_q >= (double)guiMapMaxX) {
            this.field_74124_q = guiMapMaxX - 1;
            if (this.mouseX < 0.0f) {
                this.mouseX = 0.0f;
            }
        }
        if (this.field_74123_r >= (double)guiMapMaxY) {
            this.field_74123_r = guiMapMaxY - 1;
            if (this.mouseY < 0.0f) {
                this.mouseY = 0.0f;
            }
        }
        this.guiMapX -= (double)this.mouseX;
        this.guiMapY -= (double)this.mouseY;
        this.field_74124_q = this.field_74117_m = this.guiMapX;
        this.field_74123_r = this.field_74115_n = this.guiMapY;
        this.func_73873_v_();
        this.genAchievementBackground(par1, par2, par3);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void func_73876_c() {
        this.field_74117_m = this.guiMapX;
        this.field_74115_n = this.guiMapY;
    }

    protected void genAchievementBackground(int par1, int par2, float par3) {
        ScaledResolution var13 = new ScaledResolution(this.field_73882_e.field_71474_y, this.field_73882_e.field_71443_c, this.field_73882_e.field_71440_d);
        var13.func_78326_a();
        var13.func_78328_b();
        int var4 = MathHelper.func_76128_c((double)(this.field_74117_m + (this.guiMapX - this.field_74117_m) * (double)par3));
        int var5 = MathHelper.func_76128_c((double)(this.field_74115_n + (this.guiMapY - this.field_74115_n) * (double)par3));
        if (var4 < guiMapMinX) {
            var4 = guiMapMinX;
        }
        if (var5 < guiMapMinY) {
            var5 = guiMapMinY;
        }
        if (var4 >= guiMapMaxX) {
            var4 = guiMapMaxX - 1;
        }
        if (var5 >= guiMapMaxY) {
            var5 = guiMapMaxY - 1;
        }
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)518);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        this.drawBlackBackground();
        this.renderSkybox(1.0f);
        this.zoom(this.zoom);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (IGalaxy galaxy : GalacticraftRegistry.getGalaxyList()) {
            int var10 = -var4 + galaxy.getXCoord() * 10000;
            int var11 = -var5 + galaxy.getYCoord() * 10000;
            this.drawCircles(galaxy, var10 + var10, var11 + var11);
            for (IPlanet thePlanet : GalacticraftCore.mapPlanets) {
                IMapObject planet = thePlanet.getMapObject();
                if (thePlanet.getParentGalaxy() == null || thePlanet.getParentGalaxy() != galaxy) continue;
                int var26 = 0;
                int var27 = 0;
                Map[] posMaps = this.computePlanetPos(var10, var11, planet.getDistanceFromCenter() * 750.0f, 2880.0f);
                if (posMaps[0] != null && posMaps[1] != null && posMaps[0].get(MathHelper.func_76141_d((float)((float)Sys.getTime() / (720.0f * planet.getStretchValue()) % 2880.0f))) != null && posMaps[1].get(MathHelper.func_76141_d((float)((float)Sys.getTime() / 720.0f % 2880.0f))) != null) {
                    int x = MathHelper.func_76141_d((float)((Float)posMaps[0].get(MathHelper.func_76141_d((float)((planet.getPhaseShift() + (float)Sys.getTime() / (720.0f * planet.getStretchValue())) % 2880.0f)))).floatValue());
                    int y = MathHelper.func_76141_d((float)((Float)posMaps[1].get(MathHelper.func_76141_d((float)((planet.getPhaseShift() + (float)Sys.getTime() / (720.0f * planet.getStretchValue())) % 2880.0f)))).floatValue());
                    var26 = x;
                    var27 = y;
                }
                int var42 = var10 + var26;
                int var41 = var11 + var27;
                ICelestialBodyRenderer renderer = planet.getSlotRenderer();
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                int width = (int)(planet.getPlanetSize() * 15.0f + 1.0f / this.zoom * 3.0f);
                if (Mouse.isButtonDown((int)0)) {
                    int pointerMinX = this.field_73880_f / 2 - 5;
                    int pointerMaxX = this.field_73880_f / 2 + 5;
                    int pointerMinY = this.field_73881_g / 2 - 5;
                    int pointerMaxY = this.field_73881_g / 2 + 5;
                    int planetMinX = var42 - width;
                    int planetMaxX = var42 + width;
                    int planetMinY = var41 - width;
                    int planetMaxY = var41 + width;
                    if ((pointerMaxX >= planetMinX && pointerMinX <= planetMinX || pointerMinX <= planetMinX && pointerMaxY >= planetMaxX || pointerMinX >= planetMinX && pointerMinX <= planetMaxX) && (pointerMaxY >= planetMinY && pointerMinY <= planetMinY || pointerMinY <= planetMinY && pointerMaxY >= planetMaxY || pointerMinY >= planetMinY && pointerMinY <= planetMaxY) && !planet.getSlotRenderer().getPlanetName().equals("Sun")) {
                        if ((double)this.zoom <= 0.2) {
                            if (!GalacticraftCore.mapMoons.containsValue(planet)) {
                                this.selectedPlanet = thePlanet;
                            }
                        } else {
                            this.selectedPlanet = thePlanet;
                        }
                    }
                }
                Tessellator var3 = Tessellator.field_78398_a;
                if (renderer != null) {
                    this.field_73882_e.field_71446_o.func_110577_a(renderer.getPlanetSprite());
                    renderer.renderSlot(0, var42, var41, planet.getPlanetSize() * 15.0f + 1.0f / this.zoom * 3.0f, var3);
                    if (this.selectedPlanet != null && planet.getSlotRenderer().getPlanetName().equals(this.selectedPlanet.getMapObject().getSlotRenderer().getPlanetName())) {
                        renderer.renderSlot(0, var42, var41, planet.getPlanetSize() * 15.0f + 1.0f / this.zoom * 3.0f, var3);
                    }
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (Map.Entry<IPlanet, ArrayList<IMoon>> e : GalacticraftCore.mapMoons.entrySet()) {
                    if (!e.getKey().equals(thePlanet)) continue;
                    List moonList = e.getValue();
                    for (IMoon theMoon : moonList) {
                        ICelestialBodyRenderer moonRenderer;
                        IMapObject moon = theMoon.getMapObject();
                        int var26b = 0;
                        int var27b = 0;
                        int var42b = 0;
                        int var41b = 0;
                        if (moon == null) continue;
                        Map[] posMaps2 = this.computePlanetPos(var42, var41, moon.getDistanceFromCenter() / 2.0f, 2880.0f);
                        if (posMaps2[0] != null && posMaps2[1] != null && posMaps2[0].get(MathHelper.func_76141_d((float)((float)Sys.getTime() / (720.0f * moon.getStretchValue()) % 2880.0f))) != null && posMaps2[1].get(MathHelper.func_76141_d((float)((float)Sys.getTime() / 720.0f % 2880.0f))) != null) {
                            int x = MathHelper.func_76141_d((float)((Float)posMaps2[0].get(MathHelper.func_76141_d((float)((moon.getPhaseShift() + (float)Sys.getTime() / (720.0f * moon.getStretchValue())) % 2880.0f)))).floatValue());
                            int y = MathHelper.func_76141_d((float)((Float)posMaps2[1].get(MathHelper.func_76141_d((float)((moon.getPhaseShift() + (float)Sys.getTime() / (720.0f * moon.getStretchValue())) % 2880.0f)))).floatValue());
                            var26b = x;
                            var27b = y;
                        }
                        var42b = var26b;
                        var41b = var27b;
                        width = (int)(moon.getPlanetSize() + 1.0f / this.zoom * 3.0f);
                        if (Mouse.isButtonDown((int)0)) {
                            int pointerMinX = this.field_73880_f / 2 - 5;
                            int pointerMaxX = this.field_73880_f / 2 + 5;
                            int pointerMinY = this.field_73881_g / 2 - 5;
                            int pointerMaxY = this.field_73881_g / 2 + 5;
                            int planetMinX = var42b - width;
                            int planetMaxX = var42b + width;
                            int planetMinY = var41b - width;
                            int planetMaxY = var41b + width;
                            if ((pointerMaxX >= planetMinX && pointerMinX <= planetMinX || pointerMinX <= planetMinX && pointerMaxY >= planetMaxX || pointerMinX >= planetMinX && pointerMinX <= planetMaxX) && (pointerMaxY >= planetMinY && pointerMinY <= planetMinY || pointerMinY <= planetMinY && pointerMaxY >= planetMaxY || pointerMinY >= planetMinY && pointerMinY <= planetMaxY)) {
                                this.selectedPlanet = theMoon;
                            }
                        }
                        if ((moonRenderer = moon.getSlotRenderer()) != null) {
                            this.field_73882_e.field_71446_o.func_110577_a(moonRenderer.getPlanetSprite());
                            moonRenderer.renderSlot(0, var42b, var41b, (float)((double)(moon.getPlanetSize() * 15.0f) + 1.0 / Math.pow(this.zoom, -2.0)), var3);
                            if (this.selectedPlanet != null && moon.getSlotRenderer().getPlanetName().equals(this.selectedPlanet.getMapObject().getSlotRenderer().getPlanetName())) {
                                moonRenderer.renderSlot(0, var42b, var41b, (float)((double)(moon.getPlanetSize() * 15.0f) + 1.0 / Math.pow(this.zoom, -2.0)), var3);
                            }
                        }
                        if (this.selectedPlanet == null || !moon.getSlotRenderer().getPlanetName().equals(this.selectedPlanet.getMapObject().getSlotRenderer().getPlanetName())) continue;
                        this.drawInfoBox(var42b, var41b, moon);
                    }
                }
                if (!planet.getSlotRenderer().getPlanetName().equals("Sun")) {
                    // empty if block
                }
                if (this.selectedPlanet != null && planet.getSlotRenderer().getPlanetName().equals(this.selectedPlanet.getMapObject().getSlotRenderer().getPlanetName())) {
                    this.drawInfoBox(var42, var41, planet);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDepthMask((boolean)true);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        this.field_73882_e.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(this.field_73880_f / 2 - 5, this.field_73881_g / 2 - 5, 123, 0, 10, 10);
        int col = GCCoreUtil.convertTo32BitColor(255, 198, 198, 198);
        int col2 = GCCoreUtil.convertTo32BitColor(255, 145, 145, 145);
        int col3 = GCCoreUtil.convertTo32BitColor(255, 33, 33, 33);
        int textCol1 = GCCoreUtil.convertTo32BitColor(255, 133, 133, 133);
        Gui.func_73734_a((int)0, (int)0, (int)this.field_73880_f, (int)20, (int)col);
        Gui.func_73734_a((int)0, (int)(this.field_73881_g - 24), (int)this.field_73880_f, (int)this.field_73881_g, (int)col);
        Gui.func_73734_a((int)0, (int)0, (int)10, (int)this.field_73881_g, (int)col);
        Gui.func_73734_a((int)(this.field_73880_f - 10), (int)0, (int)this.field_73880_f, (int)this.field_73881_g, (int)col);
        Gui.func_73734_a((int)10, (int)20, (int)(this.field_73880_f - 10), (int)22, (int)col3);
        Gui.func_73734_a((int)10, (int)(this.field_73881_g - 26), (int)(this.field_73880_f - 10), (int)(this.field_73881_g - 24), (int)col2);
        Gui.func_73734_a((int)10, (int)20, (int)12, (int)(this.field_73881_g - 24), (int)col3);
        Gui.func_73734_a((int)(this.field_73880_f - 12), (int)20, (int)(this.field_73880_f - 10), (int)(this.field_73881_g - 24), (int)col2);
        this.field_73886_k.func_85187_a("ASWD - Move Map", 5, 1, textCol1, false);
        this.field_73886_k.func_85187_a("Mouse Wheel - Zoom", 5, 10, textCol1, false);
        this.field_73886_k.func_85187_a("Mouse 1 - Select Planet", this.field_73880_f - this.field_73886_k.func_78256_a("Mouse 1 - Select Planet") - 5, 1, textCol1, false);
        this.field_73886_k.func_85187_a("Esc - Exit Map", this.field_73880_f - this.field_73886_k.func_78256_a("Esc - Exit Map") - 5, 10, textCol1, false);
        if (this.selectedPlanet != null) {
            Vector.Vector3 vecCol = this.selectedPlanet.getMapObject().getParentGalaxy().getRGBRingColors();
            int textCol2 = GCCoreUtil.convertTo32BitColor(255, MathHelper.func_76128_c((double)vecCol.x) * 255, MathHelper.func_76128_c((double)vecCol.z) * 255, MathHelper.func_76128_c((double)vecCol.y) * 255);
            int width = this.field_73886_k.func_78256_a(this.selectedPlanet.getMapObject().getSlotRenderer().getPlanetName());
            Gui.func_73734_a((int)(this.field_73880_f / 2 - width / 2 - 4), (int)4, (int)(this.field_73880_f / 2 + width / 2 + 4), (int)15, (int)textCol1);
            this.field_73886_k.func_85187_a(this.selectedPlanet.getMapObject().getSlotRenderer().getPlanetName(), this.field_73880_f / 2 - width / 2, 6, textCol2, false);
            for (int j = 0; j < GalacticraftCore.mapPlanets.size(); ++j) {
                IPlanet planet = GalacticraftCore.mapPlanets.get(j);
                if (planet == null) continue;
                for (Map.Entry<IPlanet, ArrayList<IMoon>> e : GalacticraftCore.mapMoons.entrySet()) {
                    List moonList = e.getValue();
                    for (IMoon moon : moonList) {
                        if (!this.selectedPlanet.equals(moon) || !e.getKey().equals(planet)) continue;
                        this.field_73886_k.func_85187_a("Moon of " + planet.getMapObject().getSlotRenderer().getPlanetName(), this.field_73880_f / 2 - width / 2 + width + 10, 6, textCol2, false);
                    }
                }
            }
        }
        super.func_73863_a(par1, par2, par3);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.func_74518_a();
    }

    public void drawCircles(IGalaxy galaxy, float cx, float cy) {
        float theta = 0.012566371f;
        float c = (float)Math.cos(0.012566370889544487);
        float s = (float)Math.sin(0.012566370889544487);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)32826);
        for (IPlanet planet : GalacticraftCore.mapPlanets) {
            if (planet.getMapObject().getParentGalaxy() != galaxy) continue;
            float x = planet.getMapObject().getDistanceFromCenter() * 750.0f;
            float y = 0.0f;
            GL11.glColor4f((float)((float)galaxy.getRGBRingColors().x), (float)((float)galaxy.getRGBRingColors().y), (float)((float)galaxy.getRGBRingColors().z), (float)1.0f);
            GL11.glBegin((int)2);
            for (int ii = 0; ii < 500; ++ii) {
                GL11.glVertex2f((float)(x + cx), (float)(y + cy));
                float t = x;
                x = c * x - s * y;
                y = s * t + c * y;
            }
            GL11.glEnd();
        }
        GL11.glDepthFunc((int)518);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
    }

    public void drawAsteroidBelt(float cx, float cy) {
        Random rand = new Random();
        rand.setSeed(1234L);
        GL11.glColor4f((float)0.54509807f, (float)0.27058825f, (float)0.07450981f, (float)1.0f);
        for (int i = 1; i < 15; ++i) {
            float theta = (float)(Math.PI * 2 / (double)(15 * i));
            float c = (float)Math.cos(theta);
            float s = (float)Math.sin(theta);
            float x = i < 8 ? (float)(4400.0 + Math.pow(2.5, i)) : (float)(4400.0 - Math.pow(2.5, 15 - i));
            float y = 0.0f;
            for (int ii = 0; ii < 15 * i; ++ii) {
                Tessellator var0 = Tessellator.field_78398_a;
                var0.func_78382_b();
                var0.func_78377_a((double)(x + cx - 2.0f + (float)rand.nextInt(50)), (double)(y + cy + 2.0f + (float)rand.nextInt(50)), -90.0);
                var0.func_78377_a((double)(x + cx + 2.0f + (float)rand.nextInt(50)), (double)(y + cy + 2.0f + (float)rand.nextInt(50)), -90.0);
                var0.func_78377_a((double)(x + cx + 2.0f + (float)rand.nextInt(50)), (double)(y + cy - 2.0f + (float)rand.nextInt(50)), -90.0);
                var0.func_78377_a((double)(x + cx - 2.0f + (float)rand.nextInt(50)), (double)(y + cy - 2.0f + (float)rand.nextInt(50)), -90.0);
                var0.func_78381_a();
                float t = x;
                x = c * x - s * y;
                y = s * t + c * y;
            }
        }
    }

    private void drawInfoBox(int cx, int cy, IMapObject planet) {
        this.func_73733_a(cx + MathHelper.func_76141_d((float)(planet.getPlanetSize() * 15.0f)), cy - 3, cx + MathHelper.func_76141_d((float)(planet.getPlanetSize() * 15.0f)) + 80, cy + 10, GCCoreUtil.convertTo32BitColor(100, 50, 50, 50), GCCoreUtil.convertTo32BitColor(100, 50, 50, 50));
        this.field_73886_k.func_78261_a(planet.getSlotRenderer().getPlanetName(), cx + MathHelper.func_76141_d((float)(planet.getPlanetSize() * 15.0f)) + 3, cy - 1, GCCoreUtil.convertTo32BitColor(255, 200, 200, 200));
        for (int i = 0; i < WorldUtil.getPlayersOnPlanet(planet).size(); ++i) {
            this.func_73733_a(cx + MathHelper.func_76141_d((float)(planet.getPlanetSize() * 15.0f)), cy + 10 * (i + 1), cx + MathHelper.func_76141_d((float)(planet.getPlanetSize() * 15.0f)) + 80, cy + 10 * (i + 1) + 10, GCCoreUtil.convertTo32BitColor(255, 50, 50, 50), GCCoreUtil.convertTo32BitColor(255, 50, 50, 50));
            this.field_73886_k.func_78261_a(String.valueOf(WorldUtil.getPlayersOnPlanet(planet).get(i)), cx + MathHelper.func_76141_d((float)(planet.getPlanetSize() * 30.0f)), cy + 1 + 10 * (i + 1), GCCoreUtil.convertTo32BitColor(255, 220, 220, 220));
            this.field_73880_f = Math.max(this.field_73880_f, String.valueOf(WorldUtil.getPlayersOnPlanet(planet).get(i)).length());
        }
    }

    public Map[] computePlanetPos(float cx, float cy, float r, float stretch) {
        HashMap<Integer, Float> mapX = new HashMap<Integer, Float>();
        HashMap<Integer, Float> mapY = new HashMap<Integer, Float>();
        float theta = (float)(Math.PI * 2 / (double)stretch);
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        float x = r;
        float y = 0.0f;
        int ii = 0;
        while ((float)ii < stretch) {
            mapX.put(ii, Float.valueOf(x + cx));
            mapY.put(ii, Float.valueOf(y + cy));
            float t = x;
            x = c * x - s * y;
            y = s * t + c * y;
            ++ii;
        }
        return new Map[]{mapX, mapY};
    }

    public boolean func_73868_f() {
        return true;
    }

    private void zoom(float f) {
        ScaledResolution var5 = new ScaledResolution(this.field_73882_e.field_71474_y, this.field_73882_e.field_71443_c, this.field_73882_e.field_71440_d);
        int x = var5.func_78326_a();
        int y = var5.func_78328_b();
        GL11.glTranslatef((float)(x / 2), (float)(y / 2), (float)0.0f);
        GL11.glScalef((float)f, (float)f, (float)0.0f);
        GL11.glTranslatef((float)(-(x / 2)), (float)(-(y / 2)), (float)0.0f);
    }

    @Override
    public void doCustomTranslation(int type, float coord1, float coord2, float coord3, float mX, float mY) {
        switch (type) {
            case 0: {
                GL11.glTranslatef((float)(coord1 - mX / (50.0f / this.zoom)), (float)(coord2 - mY / (50.0f / this.zoom)), (float)(coord3 + 0.5f));
                float i = MathHelper.func_76131_a((float)(7.0f * (this.zoom / 1.1f)), (float)3.0f, (float)9.0f);
                GL11.glScalef((float)i, (float)i, (float)i);
                return;
            }
            case 1: {
                GL11.glTranslatef((float)(coord1 - mX / (200.0f / this.zoom)), (float)(coord2 - mY / (200.0f / this.zoom)), (float)(coord3 + 0.5f));
                float i2 = MathHelper.func_76131_a((float)(7.0f * (this.zoom / 1.1f)), (float)3.0f, (float)9.0f);
                GL11.glScalef((float)(i2 / 3.0f), (float)(i2 / 3.0f), (float)(i2 / 3.0f));
                return;
            }
        }
    }
}

