/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.item.IKeyItem;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreDamageSource;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSchematicList;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class GCCoreEvents {
    @ForgeSubscribe
    public void onEntityFall(LivingFallEvent event) {
        if (event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setCanceled(false);
        event.setResult(Event.Result.ALLOW);
    }

    @ForgeSubscribe
    public void onPlayerClicked(PlayerInteractEvent event) {
        ItemStack heldStack = event.entityPlayer.field_71071_by.func_70448_g();
        TileEntity tileClicked = event.entityPlayer.field_70170_p.func_72796_p(event.x, event.y, event.z);
        int idClicked = event.entityPlayer.field_70170_p.func_72798_a(event.x, event.y, event.z);
        if (heldStack != null) {
            if (tileClicked != null && tileClicked instanceof IKeyable) {
                if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                    event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                    return;
                }
                if (event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
                    if (heldStack.func_77973_b() instanceof IKeyItem) {
                        if (((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == -1 || ((IKeyable)tileClicked).getTierOfKeyRequired() == -1 || ((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == ((IKeyable)tileClicked).getTierOfKeyRequired()) {
                            event.setCanceled(((IKeyable)tileClicked).onValidKeyActivated(event.entityPlayer, heldStack, event.face));
                        } else {
                            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                        }
                    } else {
                        event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                    }
                }
            }
            if (event.entityPlayer.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && heldStack.func_77973_b() instanceof ItemFlintAndSteel && event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && idClicked != Block.field_72091_am.field_71990_ca) {
                event.setCanceled(true);
            }
        } else if (tileClicked != null && tileClicked instanceof IKeyable) {
            if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                return;
            }
            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
        }
    }

    @ForgeSubscribe
    public void growTreeBonemeal(BonemealEvent event) {
        if (event.world.func_72798_a(event.X, event.Y, event.Z) == GCCoreBlocks.sapling.field_71990_ca && !event.world.field_72995_K && event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            GCCoreBlocks.sapling.func_72269_c(event.world, event.X, event.Y, event.Z, event.world.field_73012_v);
            event.setResult(Event.Result.ALLOW);
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    @ForgeSubscribe
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !(event.entityLiving instanceof EntityPlayer) && !OxygenUtil.isAABBInBreathableAirBlock((Entity)event.entityLiving) && (!(event.entityLiving instanceof IEntityBreathable) || event.entityLiving instanceof IEntityBreathable && !((IEntityBreathable)event.entityLiving).canBreath()) && event.entityLiving.field_70173_aa % 100 == 0) {
            event.entityLiving.func_70097_a((DamageSource)GCCoreDamageSource.oxygenSuffocation, 1.0f);
        }
    }

    @ForgeSubscribe
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    public ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
        int blockID;
        Class<?> buildCraftClass = null;
        int bcOilID1 = -1;
        int bcOilID2 = -1;
        Item bcOilBucket = null;
        try {
            buildCraftClass = Class.forName("buildcraft.BuildCraftEnergy");
            if (buildCraftClass != null) {
                for (Field f : buildCraftClass.getFields()) {
                    Item item;
                    Block block;
                    if (f.getName().equals("oilMoving")) {
                        block = (Block)f.get(null);
                        bcOilID1 = block.field_71990_ca;
                        continue;
                    }
                    if (f.getName().equals("oilStill")) {
                        block = (Block)f.get(null);
                        bcOilID2 = block.field_71990_ca;
                        continue;
                    }
                    if (!f.getName().equals("bucketOil")) continue;
                    bcOilBucket = item = (Item)f.get(null);
                }
            }
        }
        catch (Throwable cnfe) {
            // empty catch block
        }
        if (((blockID = world.func_72798_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) == bcOilID1 || blockID == bcOilID2 || blockID == GCCoreBlocks.crudeOilStill.field_71990_ca) && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0 && bcOilBucket != null) {
            world.func_94571_i(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            return new ItemStack(bcOilBucket);
        }
        return null;
    }

    @ForgeSubscribe
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkX, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        boolean doGen2 = false;
        int[] arr$ = GCCoreConfigManager.externalOilGen;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer dim = arr$[i$];
            if (dim != event.world.field_73011_w.field_76574_g) continue;
            doGen2 = true;
            break;
        }
        if (!doGen || !(event.world.field_73011_w instanceof IGalacticraftWorldProvider) && !doGen2) {
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        GCCoreEvents.doPopulate(event.world, event.rand, worldX + event.rand.nextInt(16), worldZ + event.rand.nextInt(16));
    }

    public static void doPopulate(World world, Random rand, int x, int z) {
        boolean flag2;
        BiomeGenBase biomegenbase = world.func_72807_a(x + 16, z + 16);
        if (biomegenbase.field_76756_M == BiomeGenBase.field_76779_k.field_76756_M || biomegenbase.field_76756_M == BiomeGenBase.field_76778_j.field_76756_M) {
            return;
        }
        double randMod = Math.min(0.5, 0.2 * GCCoreConfigManager.oilGenFactor);
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            int cx = x;
            int cy = 20 + rand.nextInt(11);
            int cz = z;
            int r = 2 + rand.nextInt(2);
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r; by <= r; ++by) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by * by + bz * bz;
                        if (d2 > r2) continue;
                        world.func_72832_d(bx + cx, by + cy, bz + cz, GCCoreBlocks.crudeOilStill.field_71990_ca, 0, 2);
                    }
                }
            }
        }
    }

    @ForgeSubscribe
    public void schematicUnlocked(SchematicEvent.Unlock event) {
        GCCorePlayerMP player = (GCCorePlayerMP)event.player;
        if (!player.getUnlockedSchematics().contains(event.page)) {
            player.getUnlockedSchematics().add(event.page);
            Collections.sort(player.getUnlockedSchematics());
            if (player != null && player.field_71135_a != null) {
                player.field_71135_a.func_72567_b(GCCorePacketSchematicList.buildSchematicListPacket(player.getUnlockedSchematics()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void schematicFlipEvent(SchematicEvent.FlipPage event) {
        ISchematicPage page = null;
        switch (event.direction) {
            case 1: {
                page = GCCoreEvents.getNextSchematic(event.index);
                break;
            }
            case -1: {
                page = GCCoreEvents.getLastSchematic(event.index);
            }
        }
        if (page != null) {
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket("GalacticraftCore", 4, new Object[]{page.getPageID()}));
            FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)GalacticraftCore.instance, page.getGuiID(), FMLClientHandler.instance().getClient().field_71439_g.field_70170_p, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70165_t, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70163_u, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70161_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getNextSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        for (int i = 0; i < PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.size(); ++i) {
            idList.put(i, PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count + 1 < PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.size()) {
                return PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.get(count + 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getLastSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        for (int i = 0; i < PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.size(); ++i) {
            idList.put(i, PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count - 1 >= 0) {
                return PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g).unlockedSchematics.get(count - 1);
            }
            return null;
        }
        return null;
    }

    @ForgeSubscribe
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof GCCorePlayerMP && !event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            for (int i = 0; i < ((GCCorePlayerMP)event.entityLiving).getExtendedInventory().func_70302_i_(); ++i) {
                ItemStack stack = ((GCCorePlayerMP)event.entityLiving).getExtendedInventory().func_70301_a(i);
                if (stack == null) continue;
                ((GCCorePlayerMP)event.entityLiving).func_71019_a(stack, true);
                ((GCCorePlayerMP)event.entityLiving).getExtendedInventory().func_70299_a(i, null);
            }
        }
    }
}

