/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IPressurizedTube;
import mekanism.api.Object3D;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;

public class GasNetwork {
    public Set<IPressurizedTube> tubes = new HashSet<IPressurizedTube>();
    public Set<IGasAcceptor> possibleAcceptors = new HashSet<IGasAcceptor>();
    public Map<IGasAcceptor, ForgeDirection> acceptorDirections = new HashMap<IGasAcceptor, ForgeDirection>();

    public GasNetwork(IPressurizedTube ... varPipes) {
        this.tubes.addAll(Arrays.asList(varPipes));
    }

    public int emit(int gasToSend, EnumGas transferType, TileEntity emitter) {
        List<Object> availableAcceptors = Arrays.asList(this.getGasAcceptors(transferType).toArray());
        Collections.shuffle(availableAcceptors);
        int prevSending = gasToSend;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = gasToSend % divider;
            int sending = (gasToSend - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof IGasAcceptor) || obj == emitter) continue;
                IGasAcceptor acceptor = (IGasAcceptor)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                gasToSend -= currentSending - acceptor.transferGasToAcceptor(currentSending, transferType);
            }
        }
        if (prevSending > gasToSend && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, transferType));
        }
        return gasToSend;
    }

    public Set<IGasAcceptor> getGasAcceptors(EnumGas transferType) {
        HashSet<IGasAcceptor> toReturn = new HashSet<IGasAcceptor>();
        for (IGasAcceptor acceptor : this.possibleAcceptors) {
            if (!acceptor.canReceiveGas(this.acceptorDirections.get(acceptor).getOpposite(), transferType) || acceptor instanceof IGasStorage && (!(acceptor instanceof IGasStorage) || ((IGasStorage)((Object)acceptor)).getMaxGas(transferType, new Object[0]) - ((IGasStorage)((Object)acceptor)).getGas(transferType, new Object[0]) <= 0)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    public void refresh() {
        Iterator<IPressurizedTube> it = this.tubes.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            IPressurizedTube conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            if (((TileEntity)conductor).func_70320_p()) {
                it.remove();
                continue;
            }
            conductor.setNetwork(this);
        }
        for (IPressurizedTube pipe : this.tubes) {
            IGasAcceptor[] acceptors;
            for (IGasAcceptor acceptor : acceptors = GasTransmission.getConnectedAcceptors((TileEntity)pipe)) {
                if (acceptor == null || acceptor instanceof IPressurizedTube) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
    }

    public void merge(GasNetwork network) {
        if (network != null && network != this) {
            GasNetwork newNetwork = new GasNetwork(new IPressurizedTube[0]);
            newNetwork.tubes.addAll(this.tubes);
            newNetwork.tubes.addAll(network.tubes);
            newNetwork.refresh();
        }
    }

    public void split(IPressurizedTube splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.tubes.remove(splitPoint);
            TileEntity[] connectedBlocks = new TileEntity[6];
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity sideTile = Object3D.get((TileEntity)splitPoint).getFromSide(direction).getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                if (sideTile == null) continue;
                connectedBlocks[Arrays.asList(ForgeDirection.values()).indexOf((Object)direction)] = sideTile;
            }
            for (int countOne = 0; countOne < connectedBlocks.length; ++countOne) {
                TileEntity connectedBlockA = connectedBlocks[countOne];
                if (!(connectedBlockA instanceof IPressurizedTube)) continue;
                for (int countTwo = 0; countTwo < connectedBlocks.length; ++countTwo) {
                    TileEntity connectedBlockB = connectedBlocks[countTwo];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof IPressurizedTube)) continue;
                    NetworkFinder finder = new NetworkFinder(((TileEntity)splitPoint).field_70331_k, Object3D.get(connectedBlockB), Object3D.get((TileEntity)splitPoint));
                    if (finder.foundTarget(Object3D.get(connectedBlockA))) {
                        for (Object3D node : finder.iterated) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof IPressurizedTube) || nodeTile == splitPoint) continue;
                            ((IPressurizedTube)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    GasNetwork newNetwork = new GasNetwork(new IPressurizedTube[0]);
                    for (Object3D node : finder.iterated) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof IPressurizedTube) || nodeTile == splitPoint) continue;
                        newNetwork.tubes.add((IPressurizedTube)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "[GasNetwork] " + this.tubes.size() + " pipes, " + this.possibleAcceptors.size() + " acceptors.";
    }

    public static class NetworkLoader {
        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null) {
                ArrayList collection = new ArrayList();
                collection.addAll(event.getChunk().field_76648_i.values());
                for (Object obj : collection) {
                    TileEntity tileEntity;
                    if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IPressurizedTube)) continue;
                    ((IPressurizedTube)tileEntity).refreshNetwork();
                }
            }
        }
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final EnumGas transferType;

        public GasTransferEvent(GasNetwork network, EnumGas type) {
            this.gasNetwork = network;
            this.transferType = type;
        }
    }

    public static class NetworkFinder {
        public World worldObj;
        public Object3D toFind;
        public List<Object3D> iterated = new ArrayList<Object3D>();
        public List<Object3D> toIgnore = new ArrayList<Object3D>();

        public NetworkFinder(World world, Object3D target, Object3D ... ignore) {
            this.worldObj = world;
            this.toFind = target;
            if (ignore != null) {
                this.toIgnore = Arrays.asList(ignore);
            }
        }

        public void loopThrough(Object3D location) {
            this.iterated.add(location);
            if (this.iterated.contains(this.toFind)) {
                return;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                Object3D obj = location.getFromSide(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj)) continue;
                TileEntity tileEntity = location.getTileEntity((IBlockAccess)this.worldObj);
                TileEntity sideTile = obj.getTileEntity((IBlockAccess)this.worldObj);
                if (!(sideTile instanceof IPressurizedTube) || !((IPressurizedTube)sideTile).canTransferGas() || !((IPressurizedTube)sideTile).canTransferGasToTube(tileEntity) || !((IPressurizedTube)tileEntity).canTransferGasToTube(sideTile)) continue;
                this.loopThrough(obj);
            }
        }

        public boolean foundTarget(Object3D start) {
            this.loopThrough(start);
            return this.iterated.contains(this.toFind);
        }
    }
}

