/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTMaterial;
import com.overminddl1.mods.NMT.NMTTextureVertex;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;

public class NMTPolygon {
    public ArrayList<NMTTextureVertex> vertices;
    public Vec3 normal;
    public boolean invertNormal;
    public boolean recalcNormal;
    public boolean indivNormal;
    public boolean fromOrigNormal;
    public boolean textured;
    public NMTMaterial material;

    public NMTPolygon(ArrayList<NMTTextureVertex> verts, Vec3 vec) {
        this.vertices = verts;
        this.normal = vec;
        this.invertNormal = false;
        this.recalcNormal = true;
        this.indivNormal = false;
        this.fromOrigNormal = false;
        this.textured = true;
        this.material = null;
    }

    public NMTPolygon(ArrayList<NMTTextureVertex> verts) {
        this(verts, null);
    }

    public NMTPolygon(NMTTextureVertex[] verts) {
        this(new ArrayList<NMTTextureVertex>(Arrays.asList(verts)));
    }

    public void flipFace() {
        ArrayList<NMTTextureVertex> tempVerts = new ArrayList<NMTTextureVertex>();
        for (int idx = 0; idx < this.vertices.size(); ++idx) {
            tempVerts.add(this.vertices.get(this.vertices.size() - (idx + 1)));
        }
        this.vertices.clear();
        this.vertices = tempVerts;
    }

    public void setNormal(float x, float y, float z) {
        this.normal = Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public void setMaterial(NMTMaterial mat) {
        this.material = mat;
    }

    public void draw(Tessellator tessellator, float scale) {
        this.draw(tessellator, scale, false);
    }

    public void draw(Tessellator tessellator, float scale, boolean disableTexture) {
        if (this.material != null) {
            this.material.setMaterial();
        }
        if (this.normal == null || this.recalcNormal) {
            Vec3 vec3d = this.vertices.get((int)1).vertex.transformVector.func_72444_a(this.vertices.get((int)0).vertex.transformVector);
            Vec3 vec3d1 = this.vertices.get((int)1).vertex.transformVector.func_72444_a(this.vertices.get((int)2).vertex.transformVector);
            this.normal = vec3d1.func_72431_c(vec3d).func_72432_b();
        }
        if (this.vertices.size() == 4) {
            tessellator.func_78382_b();
        } else if (this.vertices.size() == 3) {
            tessellator.func_78371_b(4);
        } else {
            tessellator.func_78371_b(9);
        }
        if (this.invertNormal) {
            this.normal.field_72450_a = -this.normal.field_72450_a;
            this.normal.field_72448_b = -this.normal.field_72448_b;
            this.normal.field_72449_c = -this.normal.field_72449_c;
        }
        for (int idx = 0; idx < this.vertices.size(); ++idx) {
            NMTTextureVertex vertex = this.vertices.get(idx);
            if (this.fromOrigNormal) {
                Vec3 vec3d2 = Vec3.func_72443_a((double)vertex.vertex.transformVector.field_72450_a, (double)vertex.vertex.transformVector.field_72448_b, (double)vertex.vertex.transformVector.field_72449_c);
                vec3d2.func_72432_b();
                if (this.invertNormal) {
                    vec3d2.field_72450_a = -vec3d2.field_72450_a;
                    vec3d2.field_72448_b = -vec3d2.field_72448_b;
                    vec3d2.field_72449_c = -vec3d2.field_72449_c;
                }
                tessellator.func_78375_b((float)vec3d2.field_72450_a, (float)vec3d2.field_72448_b, (float)vec3d2.field_72449_c);
            } else if (!this.indivNormal || vertex.normal == null && vertex.vertex.normal == null) {
                tessellator.func_78375_b((float)this.normal.field_72450_a, (float)this.normal.field_72448_b, (float)this.normal.field_72449_c);
            } else {
                Vec3 useNormal = vertex.normal;
                if (useNormal == null) {
                    useNormal = vertex.vertex.normal;
                }
                if (this.invertNormal) {
                    tessellator.func_78375_b(-((float)useNormal.field_72450_a), -((float)useNormal.field_72448_b), -((float)useNormal.field_72449_c));
                } else {
                    tessellator.func_78375_b((float)useNormal.field_72450_a, (float)useNormal.field_72448_b, (float)useNormal.field_72449_c);
                }
            }
            if (disableTexture || !this.textured) {
                tessellator.func_78377_a((double)((float)vertex.vertex.transformVector.field_72450_a * scale), (double)((float)vertex.vertex.transformVector.field_72448_b * scale), (double)((float)vertex.vertex.transformVector.field_72449_c * scale));
                continue;
            }
            tessellator.func_78374_a((double)((float)vertex.vertex.transformVector.field_72450_a * scale), (double)((float)vertex.vertex.transformVector.field_72448_b * scale), (double)((float)vertex.vertex.transformVector.field_72449_c * scale), (double)vertex.textureU, (double)vertex.textureV);
        }
        tessellator.func_78381_a();
        if (this.material != null) {
            this.material.resetMaterial();
        }
    }
}

