/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelBase;
import com.overminddl1.mods.NMT.NMTModelBox;
import com.overminddl1.mods.NMT.NMTModelFileOBJ;
import com.overminddl1.mods.NMT.NMTModelSphere;
import com.overminddl1.mods.NMT.NMTModelSprite;
import com.overminddl1.mods.NMT.NMTModelTrapezoid;
import com.overminddl1.mods.NMT.NMTModelVoxel;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class NMTModelRenderer
extends ModelRenderer {
    private boolean field_78812_q;
    private int field_78811_r;
    private ModelBase field_78810_s;
    public int textureU;
    public int textureV;
    public ArrayList<NMTModelBase> modelList;
    public boolean disableTextureMapping;
    public boolean recompile;

    public NMTModelRenderer(ModelBase modelbase, String s) {
        super(modelbase, s);
        this.field_78810_s = modelbase;
        this.field_78812_q = false;
        this.field_78811_r = 0;
        this.modelList = new ArrayList();
        this.disableTextureMapping = false;
    }

    public NMTModelRenderer(ModelBase modelbase) {
        super(modelbase);
        this.field_78812_q = false;
        this.field_78810_s = modelbase;
        this.field_78811_r = 0;
        this.modelList = new ArrayList();
        this.disableTextureMapping = false;
    }

    public NMTModelRenderer(ModelBase modelbase, int textureX, int textureY) {
        super(modelbase, textureX, textureY);
        this.field_78812_q = false;
        this.field_78810_s = modelbase;
        this.field_78811_r = 0;
        this.modelList = new ArrayList();
        this.func_78784_a(textureX, textureY);
        this.disableTextureMapping = false;
    }

    public NMTModelRenderer(ModelBase modelbase, int textureX, int textureY, int textureW, int textureH) {
        this(modelbase, textureX, textureY);
        this.func_78787_b(textureW, textureH);
    }

    public ModelRenderer func_78784_a(int u, int v) {
        super.func_78784_a(u, v);
        this.textureU = u;
        this.textureV = v;
        return this;
    }

    public NMTModelRenderer addModel(String name, NMTModelBase model) {
        name = this.field_78802_n + "." + name;
        TextureOffset textureoffset = this.field_78810_s.func_78084_a(name);
        this.func_78784_a(textureoffset.field_78783_a, textureoffset.field_78782_b);
        this.modelList.add(model.create().setName(name));
        return this;
    }

    public NMTModelRenderer addModel(NMTModelBase model) {
        this.modelList.add(model.create());
        return this;
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth) {
        return this.addBox(name, x, y, z, width, height, depth, 0.0f);
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float extrusion) {
        return this.addBox(name, x, y, z, width, height, depth, extrusion, 1.0f);
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float extrusion, float scale) {
        return this.addBox(name, x, y, z, width, height, depth, extrusion, scale, false);
    }

    public NMTModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float extrusion, float scale, boolean smooth) {
        return this.addModel(name, new NMTModelBox(this, x, y, z, width, height, depth, extrusion, scale, smooth));
    }

    public NMTModelRenderer addBox(float x, float y, float z, int width, int height, int depth) {
        return this.addBox(x, y, z, width, height, depth, 0.0f, 1.0f, false);
    }

    public void func_78790_a(float x, float y, float z, int width, int height, int depth, float extrusion) {
        this.addBox(x, y, z, width, height, depth, extrusion, 1.0f);
    }

    public void addBox(float x, float y, float z, int width, int height, int depth, float extrusion, float scale) {
        this.addBox(x, y, z, width, height, depth, extrusion, scale, false);
    }

    public NMTModelRenderer addBox(float x, float y, float z, int width, int height, int depth, float extrusion, float scale, boolean smooth) {
        return this.addModel(new NMTModelBox(this, x, y, z, width, height, depth, extrusion, scale, smooth));
    }

    public NMTModelRenderer addTrapezoid(String name, float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        return this.addModel(name, new NMTModelTrapezoid(this, x, y, z, w, h, d, scale, bottomScale, dir));
    }

    public NMTModelRenderer addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        return this.addModel(new NMTModelTrapezoid(this, x, y, z, w, h, d, scale, bottomScale, dir));
    }

    public NMTModelRenderer addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir, boolean smooth) {
        return this.addModel(new NMTModelTrapezoid(this, x, y, z, w, h, d, scale, bottomScale, dir, smooth));
    }

    public NMTModelRenderer addVoxel(String name, float x, float y, float z) {
        return this.addVoxel(name, x, y, z, 1.0f, 1.0f, 1.0f);
    }

    public NMTModelRenderer addVoxel(String name, float x, float y, float z, float width, float height, float depth) {
        return this.addVoxel(name, x, y, z, width, height, depth, 0, 0);
    }

    public NMTModelRenderer addVoxel(String name, float x, float y, float z, float width, float height, float depth, int relativeU, int relativeV) {
        return this.addModel(name, new NMTModelVoxel(this, x, y, z, width, height, depth, relativeU, relativeV));
    }

    public NMTModelRenderer addVoxel(float x, float y, float z, float width, float height, float depth) {
        return this.addVoxel(x, y, z, width, height, depth, 0, 0);
    }

    public NMTModelRenderer addVoxel(float x, float y, float z, float width, float height, float depth, int relativeU, int relativeV) {
        return this.addModel(new NMTModelVoxel(this, x, y, z, width, height, depth, relativeU, relativeV));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth, int texW, int texH) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers));
    }

    public NMTModelRenderer addSprite(String name, float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers, int layersPerRow) {
        return this.addModel(name, new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers, layersPerRow));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers, int layersPerRow) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers, layersPerRow));
    }

    public NMTModelRenderer addSprite(float x, float y, float z, float width, float height, float depth, int texW, int texH, int layers, int layersPerRow, boolean rotX, boolean rotY, boolean rotZ) {
        return this.addModel(new NMTModelSprite(this, x, y, z, width, height, depth, texW, texH, layers, layersPerRow, rotX, rotY, rotZ));
    }

    public NMTModelRenderer addSphere(float x, float y, float z, float r, int slices, int stacks, int tW, int tH, boolean cN, int mappingUsed) {
        return this.addModel(new NMTModelSphere(this, x, y, z, r, slices, stacks, tW, tH, cN, mappingUsed));
    }

    public NMTModelRenderer addModelOBJ(String name, String file) {
        try {
            return this.addModel(name, new NMTModelFileOBJ(this, file));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public NMTModelRenderer addModelOBJ(String file) {
        try {
            return this.addModel(new NMTModelFileOBJ(this, file));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void copyRotations(ModelRenderer model) {
        this.field_78795_f = model.field_78795_f;
        this.field_78796_g = model.field_78796_g;
        this.field_78808_h = model.field_78808_h;
    }

    public void func_78785_a(float f) {
        if (this.field_78807_k) {
            return;
        }
        if (!this.field_78806_j) {
            return;
        }
        if (!this.field_78812_q || this.recompile) {
            this.func_78788_d(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_78800_c * f), (float)(this.field_78797_d * f), (float)(this.field_78798_e * f));
        if (this.field_78796_g != 0.0f) {
            GL11.glRotatef((float)(this.field_78796_g * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.field_78795_f != 0.0f) {
            GL11.glRotatef((float)(this.field_78795_f * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.field_78808_h != 0.0f) {
            GL11.glRotatef((float)(this.field_78808_h * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.field_78811_r);
        this.renderList(f);
        GL11.glPopMatrix();
    }

    private void func_78788_d(float f) {
        this.field_78811_r = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.field_78811_r, (int)4864);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.modelList.size(); ++i) {
            NMTModelBase model = this.modelList.get(i);
            if (!model.doCompile) continue;
            model.compile(tessellator, f);
        }
        GL11.glEndList();
        this.field_78812_q = true;
    }

    private void renderList(float f) {
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.modelList.size(); ++i) {
            NMTModelBase model = this.modelList.get(i);
            if (!model.doRender) continue;
            model.render(tessellator, f);
        }
    }
}

