/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.wgen.dungeon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.wgen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.wgen.dungeon.GCCoreDungeonRoom;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class GCCoreMapGenDungeon {
    public final int DUNGEON_WALL_ID;
    public final int DUNGEON_WALL_META;
    public final int RANGE;
    public final int HALLWAY_LENGTH;
    public final int HALLWAY_HEIGHT;
    public static boolean useArrays = false;
    public World worldObj;
    private final ArrayList<GCCoreDungeonRoom> rooms = new ArrayList();

    public GCCoreMapGenDungeon(int wallID, int wallMeta, int range, int hallwayLength, int hallwayHeight) {
        this.DUNGEON_WALL_ID = wallID;
        this.DUNGEON_WALL_META = wallMeta;
        this.RANGE = range;
        this.HALLWAY_LENGTH = hallwayLength;
        this.HALLWAY_HEIGHT = hallwayHeight;
    }

    public void generateUsingArrays(World world, long seed, int x, int y, int z, int chunkX, int chunkZ, short[] blocks, byte[] metas) {
        ChunkCoordinates dungeonCoords = this.getDungeonNear(seed, chunkX, chunkZ);
        if (dungeonCoords != null) {
            this.generate(world, new Random(seed * (long)dungeonCoords.field_71574_a * (long)dungeonCoords.field_71573_c * 24789L), dungeonCoords.field_71574_a, y, dungeonCoords.field_71573_c, chunkX, chunkZ, blocks, metas, true);
        }
    }

    public void generateUsingSetBlock(World world, int x, int y, int z) {
        this.generate(world, new Random(this.worldObj.func_72912_H().func_76063_b() * (long)x * (long)z * 24789L), x, y, z, x, z, null, null, false);
    }

    public void generate(World world, Random rand, int x, int y, int z, int chunkX, int chunkZ, short[] blocks, byte[] metas, boolean useArrays) {
        GCCoreMapGenDungeon.useArrays = useArrays;
        this.worldObj = world;
        ArrayList<GCCoreDungeonBoundingBox> boundingBoxes = new ArrayList<GCCoreDungeonBoundingBox>();
        int length = rand.nextInt(4) + 5;
        GCCoreDungeonRoom currentRoom = GCCoreDungeonRoom.makeRoom(this, rand, x, y, z, 4);
        currentRoom.generate(blocks, metas, chunkX, chunkZ);
        this.rooms.add(currentRoom);
        GCCoreDungeonBoundingBox cbb = currentRoom.getBoundingBox();
        this.generateEntranceCrater(blocks, metas, x + (cbb.maxX - cbb.minX) / 2, y, z + (cbb.maxZ - cbb.minZ) / 2, chunkX, chunkZ);
        block18: for (int i = 0; i <= length; ++i) {
            for (int j = 0; j < 6; ++j) {
                GCCoreDungeonBoundingBox corridor1;
                int dir;
                int offsetX = 0;
                int offsetZ = 0;
                int entranceDir = dir = this.randDir(rand, currentRoom.entranceDir);
                switch (dir) {
                    case 0: {
                        offsetZ = this.HALLWAY_LENGTH + rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 1;
                            offsetX = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 2;
                        offsetX = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                    case 1: {
                        offsetX = this.HALLWAY_LENGTH + rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 0;
                            offsetZ = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 3;
                        offsetZ = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                    case 2: {
                        offsetX = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 0;
                            offsetZ = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 3;
                        offsetZ = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                    case 3: {
                        offsetZ = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = 1;
                            offsetX = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = 2;
                        offsetX = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                }
                GCCoreDungeonRoom possibleRoom = GCCoreDungeonRoom.makeRoom(this, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, this.getOppositeDir(entranceDir));
                if (i == length - 1) {
                    possibleRoom = GCCoreDungeonRoom.makeBossRoom(this, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, this.getOppositeDir(entranceDir));
                }
                if (i == length) {
                    possibleRoom = GCCoreDungeonRoom.makeTreasureRoom(this, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, this.getOppositeDir(entranceDir));
                }
                GCCoreDungeonBoundingBox possibleRoomBb = possibleRoom.getBoundingBox();
                GCCoreDungeonBoundingBox currentRoomBb = currentRoom.getBoundingBox();
                if (this.isIntersecting(possibleRoomBb, boundingBoxes)) continue;
                int cx = (currentRoomBb.minX + currentRoomBb.maxX) / 2;
                int cz = (currentRoomBb.minZ + currentRoomBb.maxZ) / 2;
                int px = (possibleRoomBb.minX + possibleRoomBb.maxX) / 2;
                int pz = (possibleRoomBb.minZ + possibleRoomBb.maxZ) / 2;
                int ax = (cx + px) / 2;
                int az = (cz + pz) / 2;
                if (offsetX == 0 || offsetZ == 0) {
                    corridor1 = null;
                    switch (dir) {
                        case 0: {
                            corridor1 = new GCCoreDungeonBoundingBox(ax - 1, currentRoomBb.maxZ, ax, possibleRoomBb.minZ - 1);
                            break;
                        }
                        case 1: {
                            corridor1 = new GCCoreDungeonBoundingBox(currentRoomBb.maxX, az - 1, possibleRoomBb.minX - 1, az);
                            break;
                        }
                        case 2: {
                            corridor1 = new GCCoreDungeonBoundingBox(possibleRoomBb.maxX, az - 1, currentRoomBb.minX - 1, az);
                            break;
                        }
                        case 3: {
                            corridor1 = new GCCoreDungeonBoundingBox(ax - 1, possibleRoomBb.maxZ, ax, currentRoomBb.minZ - 1);
                            break;
                        }
                    }
                    if (this.isIntersecting(corridor1, boundingBoxes)) continue;
                    boundingBoxes.add(possibleRoomBb);
                    boundingBoxes.add(corridor1);
                    currentRoom = possibleRoom;
                    currentRoom.generate(blocks, metas, chunkX, chunkZ);
                    this.rooms.add(currentRoom);
                    if (corridor1 == null) continue block18;
                    this.genCorridor(corridor1, rand, possibleRoom.posY, chunkX, chunkZ, dir, blocks, metas, false);
                    continue block18;
                }
                corridor1 = null;
                GCCoreDungeonBoundingBox corridor2 = null;
                int dir2 = 0;
                int extraLength = 0;
                if (rand.nextInt(6) == 0) {
                    extraLength = rand.nextInt(7);
                }
                switch (dir) {
                    case 0: {
                        corridor1 = new GCCoreDungeonBoundingBox(cx - 1, currentRoomBb.maxZ, cx + 1, pz - 1);
                        if (offsetX > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - extraLength, corridor1.maxZ + 1, possibleRoomBb.minX, corridor1.maxZ + 3);
                            dir2 = 1;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(possibleRoomBb.maxX, corridor1.maxZ + 1, corridor1.maxX + extraLength, corridor1.maxZ + 3);
                        dir2 = 2;
                        break;
                    }
                    case 1: {
                        corridor1 = new GCCoreDungeonBoundingBox(currentRoomBb.maxX, cz - 1, px - 1, cz + 1);
                        if (offsetZ > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.maxX + 1, corridor1.minZ - extraLength, corridor1.maxX + 4, possibleRoomBb.minZ);
                            dir2 = 0;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(corridor1.maxX + 1, possibleRoomBb.maxZ, corridor1.maxX + 4, corridor1.maxZ + extraLength);
                        dir2 = 3;
                        break;
                    }
                    case 2: {
                        corridor1 = new GCCoreDungeonBoundingBox(px + 1, cz - 1, currentRoomBb.minX - 1, cz + 1);
                        if (offsetZ > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - 3, corridor1.minZ - extraLength, corridor1.minX - 1, possibleRoomBb.minZ);
                            dir2 = 0;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - 3, possibleRoomBb.maxZ, corridor1.minX - 1, corridor1.maxZ + extraLength);
                        dir2 = 3;
                        break;
                    }
                    case 3: {
                        corridor1 = new GCCoreDungeonBoundingBox(cx - 1, pz + 1, cx + 1, currentRoomBb.minZ - 1);
                        if (offsetX > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - extraLength, corridor1.minZ - 3, possibleRoomBb.minX, corridor1.minZ - 1);
                            dir2 = 1;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(possibleRoomBb.maxX, corridor1.minZ - 3, corridor1.maxX + extraLength, corridor1.minZ - 1);
                        dir2 = 2;
                        break;
                    }
                }
                if (this.isIntersecting(corridor1, boundingBoxes) || this.isIntersecting(corridor2, boundingBoxes)) continue;
                boundingBoxes.add(possibleRoomBb);
                boundingBoxes.add(corridor1);
                boundingBoxes.add(corridor2);
                currentRoom = possibleRoom;
                currentRoom.generate(blocks, metas, chunkX, chunkZ);
                this.rooms.add(currentRoom);
                if (corridor1 == null || corridor2 == null) continue block18;
                this.genCorridor(corridor2, rand, possibleRoom.posY, chunkX, chunkZ, dir2, blocks, metas, true);
                this.genCorridor(corridor1, rand, possibleRoom.posY, chunkX, chunkZ, dir, blocks, metas, false);
                continue block18;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void genCorridor(GCCoreDungeonBoundingBox corridor, Random rand, int y, int cx, int cz, int dir, short[] blocks, byte[] metas, boolean doubleCorridor) {
        int i = corridor.minX - 1;
        block6: while (i <= corridor.maxX + 1) {
            int k = corridor.minZ - 1;
            while (true) {
                if (k <= corridor.maxZ + 1) {
                } else {
                    ++i;
                    continue block6;
                }
                block8: for (int j = y - 1; j <= y + this.HALLWAY_HEIGHT; ++j) {
                    boolean flag = false;
                    int flag2 = -1;
                    switch (dir) {
                        case 0: {
                            if (k == corridor.minZ - 1 && !doubleCorridor || k == corridor.maxZ + 1) break block8;
                            if (doubleCorridor && k == corridor.minZ - 1) {
                                flag = true;
                            }
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (i != corridor.minX && i != corridor.maxX || k % 4 != 0 || j != y + 2) break;
                            flag2 = i == corridor.minX ? 2 : 1;
                            break;
                        }
                        case 3: {
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 && !doubleCorridor) break block8;
                            if (doubleCorridor && k == corridor.maxX + 1) {
                                flag = true;
                            }
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (i != corridor.minX && i != corridor.maxX || k % 4 != 0 || j != y + 2) break;
                            flag2 = i == corridor.minX ? 2 : 1;
                            break;
                        }
                        case 1: {
                            if (i == corridor.minX - 1 && !doubleCorridor || i == corridor.maxX + 1) break block8;
                            if (i == corridor.minX - 1) {
                                flag = true;
                            }
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (k != corridor.minZ && k != corridor.maxZ || i % 4 != 0 || j != y + 2) break;
                            flag2 = k == corridor.minZ ? 4 : 3;
                            break;
                        }
                        case 2: {
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 && !doubleCorridor) break block8;
                            if (i == corridor.maxX + 1) {
                                flag = true;
                            }
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (k != corridor.minZ && k != corridor.maxZ || i % 4 != 0 || j != y + 2) break;
                            flag2 = k == corridor.minZ ? 4 : 3;
                        }
                    }
                    if (!flag) {
                        if (flag2 != -1) {
                            this.placeBlock(blocks, metas, i, j, k, cx, cz, GCCoreBlocks.unlitTorch.field_71990_ca, 0);
                            this.worldObj.func_72892_b(i, j, k, GCCoreBlocks.unlitTorch.field_71990_ca, 40, 0);
                            continue;
                        }
                        this.placeBlock(blocks, metas, i, j, k, cx, cz, 0, 0);
                        continue;
                    }
                    this.placeBlock(blocks, metas, i, j, k, cx, cz, this.DUNGEON_WALL_ID, this.DUNGEON_WALL_META);
                }
                ++k;
            }
            break;
        }
        return;
    }

    public void handleTileEntities(Random rand) {
        ArrayList<GCCoreDungeonRoom> rooms = new ArrayList<GCCoreDungeonRoom>();
        rooms.addAll(this.rooms);
        for (GCCoreDungeonRoom room : rooms) {
            room.handleTileEntities(rand);
        }
    }

    protected boolean canGenDungeonAtCoords(long worldSeed, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= 31;
        }
        if (j < 0) {
            j -= 31;
        }
        int randX = i / 32;
        int randZ = j / 32;
        long dungeonSeed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldSeed + 4291726L;
        Random rand = new Random(dungeonSeed);
        randX *= 32;
        randZ *= 32;
        return oldi == (randX += rand.nextInt(24)) && oldj == (randZ += rand.nextInt(24));
    }

    public void generateEntranceCrater(short[] blocks, byte[] meta, int x, int y, int z, int cx, int cz) {
        int range = 18;
        for (int i = x - 18; i < x + 18; ++i) {
            block1: for (int k = z - 18; k < z + 18; ++k) {
                double xDev = (double)(i - x) / 10.0;
                double zDev = (double)(k - z) / 10.0;
                double distance = xDev * xDev + zDev * zDev;
                int depth = (int)Math.abs(2.0 / (distance + 1.0E-5));
                int helper = 0;
                for (int j = 127; j > 0; --j) {
                    if ((this.getBlockID(blocks, i, j - 1, k, cx, cz) != 0 || this.getBlockID(blocks, i, j, k, cx, cz) == this.DUNGEON_WALL_ID) && helper <= depth) {
                        this.placeBlock(blocks, meta, i, j, k, cx, cz, 0, 0);
                        ++helper;
                    }
                    if (helper > depth || j <= y + 1) continue block1;
                }
            }
        }
    }

    public ChunkCoordinates getDungeonNear(long worldSeed, int i, int j) {
        int range = 8;
        for (int x = i - 8; x <= i + 8; ++x) {
            for (int z = j - 8; z <= j + 8; ++z) {
                if (!this.canGenDungeonAtCoords(worldSeed, x, z)) continue;
                return new ChunkCoordinates(x * 16 + 8, 0, z * 16 + 8);
            }
        }
        return null;
    }

    private void placeBlock(short[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, int id, int meta) {
        if (useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = (short)id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.func_72832_d(x, y, z, id, meta, 3);
        }
    }

    private int getBlockID(short[] blocks, int x, int y, int z, int cx, int cz) {
        if (useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return 1;
            }
            return blocks[this.getIndex(x, y, z)];
        }
        return this.worldObj.func_72798_a(x, y, z);
    }

    private int getOppositeDir(int dir) {
        switch (dir) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 5;
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private int randDir(Random rand, int dir) {
        int[] dirHelper = new int[dir < 4 ? 3 : 4];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            if (i == dir) continue;
            dirHelper[k] = i;
            ++k;
        }
        return dirHelper[rand.nextInt(dirHelper.length)];
    }

    private boolean isIntersecting(GCCoreDungeonBoundingBox bb, List<GCCoreDungeonBoundingBox> dungeonBbs) {
        for (GCCoreDungeonBoundingBox bb2 : dungeonBbs) {
            if (!bb.isOverlapping(bb2)) continue;
            return true;
        }
        return false;
    }
}

