/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.tile.IWrenchable;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.core.GCCoreCompatibilityManager;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.TileEntityUniversalElectrical;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public abstract class GCCoreTileEntityElectric
extends TileEntityUniversalElectrical
implements IWrenchable,
IPacketReceiver,
IDisableableMachine {
    public float ueWattsPerTick;
    private final float ueMaxEnergy;
    public boolean addedToEnergyNet = false;
    public boolean disabled = true;
    public int disableCooldown = 0;

    public abstract boolean shouldPullEnergy();

    public abstract boolean shouldUseEnergy();

    public abstract void readPacket(ByteArrayDataInput var1);

    public abstract Packet getPacket();

    public abstract ForgeDirection getElectricInputDirection();

    public abstract ItemStack getBatteryInSlot();

    public GCCoreTileEntityElectric(float ueWattsPerTick, float maxEnergy) {
        this.ueMaxEnergy = maxEnergy;
        this.ueWattsPerTick = ueWattsPerTick;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.ueMaxEnergy;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStored() * (float)i / (this.getMaxEnergyStored() - this.ueWattsPerTick));
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        if (this.shouldPullEnergy()) {
            return this.ueWattsPerTick * 2.0f;
        }
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public void func_70316_g() {
        if (this.shouldPullEnergy() && this.getEnergyStored() < this.getMaxEnergyStored()) {
            this.receiveElectricity(this.getElectricInputDirection(), ElectricityPack.getFromWatts(ElectricItemHelper.dischargeItem(this.getBatteryInSlot(), this.getRequest(ForgeDirection.UNKNOWN)), this.getVoltage()), true);
        }
        if (!this.field_70331_k.field_72995_K && this.shouldUseEnergy()) {
            this.setEnergyStored(this.getEnergyStored() - this.ueWattsPerTick);
        }
        super.func_70316_g();
        if (!this.addedToEnergyNet && this.field_70331_k != null) {
            if (GCCoreCompatibilityManager.isIc2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this.addedToEnergyNet = true;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if (this.ticks % 3L == 0L) {
                PacketManager.sendPacketToClients(this.getPacket(), this.field_70331_k, new Vector3(this), 12.0);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isDisabled", this.getDisabled());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.setDisabled(nbt.func_74767_n("isDisabled"));
    }

    @Override
    public void handlePacketData(INetworkManager network, int type, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            this.readPacket(dataStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return true;
    }

    @Override
    public short getFacing() {
        return (short)this.field_70331_k.func_72805_g(MathHelper.func_76128_c((double)this.field_70329_l), MathHelper.func_76128_c((double)this.field_70330_m), MathHelper.func_76128_c((double)this.field_70327_n));
    }

    @Override
    public void setFacing(short facing) {
        int change = 0;
        switch (this.getFacing()) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        this.field_70331_k.func_72921_c(MathHelper.func_76128_c((double)this.field_70329_l), MathHelper.func_76128_c((double)this.field_70330_m), MathHelper.func_76128_c((double)this.field_70327_n), change, 3);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return Block.field_71973_m[this.func_70311_o().field_71990_ca].getPickBlock(null, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public EnumSet<ForgeDirection> getInputDirections() {
        return EnumSet.of(this.getElectricInputDirection());
    }
}

