/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreSpaceStationData;
import micdoodle8.mods.galacticraft.core.entities.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityLander;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.inventory.GCCoreContainerSchematic;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemParachute;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketControllableEntity;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketLanderUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketParachestUpdate;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityParachest;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public class GCCorePacketHandlerServer
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player p) {
        if (packet == null) {
            FMLLog.severe((String)"Packet received as null!", (Object[])new Object[0]);
            return;
        }
        if (packet.field_73629_c == null) {
            FMLLog.severe((String)("Packet data received as null! ID " + packet.func_73281_k()), (Object[])new Object[0]);
            return;
        }
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        int packetType = PacketUtil.readPacketID(data);
        EntityPlayerMP player = (EntityPlayerMP)p;
        GCCorePlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player);
        if (packetType == 0) {
            Class[] decodeAs = new Class[]{String.class};
            PacketUtil.readPacketData(data, decodeAs);
            player.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiTankRefill, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else if (packetType == 1) {
            Class[] decodeAs = new Class[]{String.class};
            PacketUtil.readPacketData(data, decodeAs);
            player.field_71135_a.func_72567_b((Packet)new Packet9Respawn(player.field_71093_bK, (byte)player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_70170_p.func_72800_K(), player.field_71134_c.func_73081_b()));
        } else if (packetType == 2) {
            Class[] decodeAs = new Class[]{String.class};
            Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
            if (playerBase != null) {
                try {
                    WorldProvider provider = WorldUtil.getProviderForName((String)packetReadout[0]);
                    Integer dim = provider.field_76574_g;
                    GCLog.info("Found matching world name for " + (String)packetReadout[0]);
                    if (playerBase.field_70170_p instanceof WorldServer) {
                        WorldServer world = (WorldServer)playerBase.field_70170_p;
                        if (provider instanceof IOrbitDimension) {
                            WorldUtil.transferEntityToDimension((Entity)playerBase, dim, world);
                        } else {
                            WorldUtil.transferEntityToDimension((Entity)playerBase, dim, world);
                        }
                    }
                    playerBase.setTeleportCooldown(300);
                    Object[] toSend = new Object[]{player.field_71092_bJ};
                    player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 12, toSend));
                }
                catch (Exception e) {
                    GCLog.severe("Error occurred when attempting to transfer entity to dimension: " + (String)packetReadout[0]);
                    e.printStackTrace();
                }
            }
        } else if (packetType == 3) {
            if (!player.field_70170_p.field_72995_K && !player.field_70128_L && player.field_70154_o != null && !player.field_70154_o.field_70128_L && player.field_70154_o instanceof EntitySpaceshipBase) {
                EntitySpaceshipBase ship = (EntitySpaceshipBase)player.field_70154_o;
                if (ship.hasValidFuel()) {
                    ItemStack stack2 = null;
                    if (playerBase != null) {
                        stack2 = playerBase.getExtendedInventory().func_70301_a(4);
                    }
                    if (stack2 != null && stack2.func_77973_b() instanceof GCCoreItemParachute || playerBase != null && playerBase.getLaunchAttempts() > 0) {
                        ship.ignite();
                        playerBase.setLaunchAttempts(0);
                    } else if (playerBase.getChatCooldown() == 0 && playerBase.getLaunchAttempts() == 0) {
                        player.func_70006_a(ChatMessageComponent.func_111066_d((String)"I don't have a parachute! If I press launch again, there's no going back!"));
                        playerBase.setChatCooldown(250);
                        playerBase.setLaunchAttempts(1);
                    }
                } else if (playerBase.getChatCooldown() == 0) {
                    player.func_70006_a(ChatMessageComponent.func_111066_d((String)"I'll need to load in some rocket fuel first!"));
                    playerBase.setChatCooldown(250);
                }
            }
        } else if (packetType == 4) {
            Class[] decodeAs = new Class[]{Integer.class};
            Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
            if (player != null) {
                ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)packetReadout[0]);
                player.openGui((Object)GalacticraftCore.instance, page.getGuiID(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        } else if (packetType != 5) {
            if (packetType == 6) {
                Class[] decodeAs = new Class[]{Integer.class};
                PacketUtil.readPacketData(data, decodeAs);
                player.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiSpaceshipInventory, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else if (packetType == 7) {
                EntitySpaceshipBase ship;
                Class[] decodeAs = new Class[]{Float.class};
                Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                if (player.field_70154_o instanceof EntitySpaceshipBase && (ship = (EntitySpaceshipBase)player.field_70154_o) != null) {
                    ship.field_70177_z = ((Float)packetReadout[0]).floatValue();
                }
            } else if (packetType == 8) {
                EntitySpaceshipBase ship;
                Class[] decodeAs = new Class[]{Float.class};
                Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                if (player.field_70154_o instanceof EntitySpaceshipBase && (ship = (EntitySpaceshipBase)player.field_70154_o) != null) {
                    ship.field_70125_A = ((Float)packetReadout[0]).floatValue();
                }
            } else if (packetType == 10) {
                Class[] decodeAs = new Class[]{Integer.class};
                Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                for (Object object : player.field_70170_p.field_72996_f) {
                    if (!(object instanceof EntityLiving)) continue;
                    EntityLiving entity = (EntityLiving)object;
                    if (entity.field_70157_k != (Integer)packetReadout[0] || entity.field_70154_o != null) continue;
                    entity.func_70015_d(3);
                }
            } else if (packetType == 11) {
                Class[] decodeAs = new Class[]{Integer.class, Integer.class, Integer.class};
                Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                player.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiRefinery, player.field_70170_p, ((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
            } else if (packetType == 12) {
                try {
                    new GCCorePacketControllableEntity().handlePacket(data, new Object[]{player}, Side.SERVER);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (packetType != 13) {
                if (packetType == 14) {
                    try {
                        new GCCorePacketEntityUpdate().handlePacket(data, new Object[]{player}, Side.SERVER);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (packetType == 15) {
                    Class[] decodeAs = new Class[]{Integer.class};
                    Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                    if (playerBase.getSpaceStationDimensionID() == -1 || playerBase.getSpaceStationDimensionID() == 0) {
                        WorldUtil.bindSpaceStationToNewDimension(playerBase.field_70170_p, playerBase);
                        WorldUtil.getSpaceStationRecipe((Integer)packetReadout[0]).matches((EntityPlayer)playerBase, true);
                    }
                } else if (packetType == 16) {
                    Container container = player.field_71070_bA;
                    if (container instanceof GCCoreContainerSchematic) {
                        ISchematicPage page;
                        GCCoreContainerSchematic schematicContainer = (GCCoreContainerSchematic)container;
                        ItemStack stack = schematicContainer.craftMatrix.func_70301_a(0);
                        if (stack != null && (page = SchematicRegistry.getMatchingRecipeForItemStack(stack)) != null) {
                            SchematicRegistry.unlockNewPage(playerBase, stack);
                            if (--stack.field_77994_a <= 0) {
                                stack = null;
                            }
                            schematicContainer.craftMatrix.func_70299_a(0, stack);
                            schematicContainer.craftMatrix.func_70296_d();
                            player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 20, new Object[]{page.getPageID()}));
                        }
                    }
                } else if (packetType == 17) {
                    Class[] decodeAs = new Class[]{Integer.class, Integer.class, Integer.class};
                    Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                    TileEntity tileAt = player.field_70170_p.func_72796_p(((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
                    if (tileAt instanceof IDisableableMachine) {
                        IDisableableMachine machine;
                        machine.setDisabled(!(machine = (IDisableableMachine)tileAt).getDisabled());
                    }
                } else if (packetType == 18) {
                    Class[] decodeAs = new Class[]{Integer.class};
                    Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                    if (playerBase.getChatCooldown() == 0) {
                        player.func_70006_a(ChatMessageComponent.func_111066_d((String)("I'll probably need a Tier " + packetReadout[0] + " Dungeon key to unlock this!")));
                        playerBase.setChatCooldown(100);
                    }
                } else if (packetType == 19) {
                    Class[] decodeAs = new Class[]{String.class, Integer.class};
                    Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                    GCCoreSpaceStationData ssdata = GCCoreSpaceStationData.getStationData(playerBase.field_70170_p, (Integer)packetReadout[1], (EntityPlayer)playerBase);
                    if (ssdata != null && ssdata.getOwner().equalsIgnoreCase(player.field_71092_bJ)) {
                        ssdata.setSpaceStationName((String)packetReadout[0]);
                        ssdata.func_76186_a(true);
                    }
                } else if (packetType == 20) {
                    if (player.field_70154_o instanceof GCCoreEntityBuggy) {
                        GCCoreUtil.openBuggyInv(player, (GCCoreEntityBuggy)player.field_70154_o, ((GCCoreEntityBuggy)player.field_70154_o).getType());
                    }
                } else if (packetType == 21) {
                    Class[] decodeAs = new Class[]{Integer.class};
                    Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                    Entity e = player.field_70170_p.func_73045_a(((Integer)packetReadout[0]).intValue());
                    if (e != null && e instanceof GCCoreEntityLander) {
                        new GCCorePacketLanderUpdate();
                        player.field_71135_a.func_72567_b(GCCorePacketLanderUpdate.buildKeyPacket((GCCoreEntityLander)e));
                    }
                } else if (packetType == 22) {
                    Class[] decodeAs = new Class[]{Integer.class, Integer.class, Integer.class};
                    Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
                    TileEntity tile = player.field_70170_p.func_72796_p(((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
                    if (tile != null && tile instanceof GCCoreTileEntityParachest) {
                        new GCCorePacketParachestUpdate();
                        player.field_71135_a.func_72567_b(GCCorePacketParachestUpdate.buildKeyPacket((GCCoreTileEntityParachest)tile));
                    }
                } else if (packetType == 23) {
                    player.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiExtendedInventory, player.field_70170_p, 0, 0, 0);
                }
            }
        }
    }
}

