/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityParachest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

public class GCCoreEntityParaChest
extends Entity {
    public ItemStack[] cargo;
    public int fuelLevel;
    private boolean placedChest;

    public GCCoreEntityParaChest(World world, ItemStack[] cargo, int fuelLevel) {
        this(world);
        this.cargo = cargo;
        this.placedChest = false;
        this.fuelLevel = fuelLevel;
    }

    public GCCoreEntityParaChest(World world) {
        super(world);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.cargo = new ItemStack[27];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.cargo.length) continue;
            this.cargo[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.placedChest = nbt.func_74767_n("placedChest");
        this.fuelLevel = nbt.func_74762_e("FuelLevel");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.cargo.length; ++var3) {
            if (this.cargo[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.cargo[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
        nbt.func_74757_a("placedChest", this.placedChest);
        nbt.func_74768_a("FuelLevel", this.fuelLevel);
    }

    public void func_70071_h_() {
        if (!this.placedChest) {
            if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 100; ++i) {
                    int z;
                    int y;
                    int x = MathHelper.func_76128_c((double)this.field_70165_t);
                    int id = this.field_70170_p.func_72798_a(x, (y = MathHelper.func_76128_c((double)this.field_70163_u)) + i, z = MathHelper.func_76128_c((double)this.field_70161_v));
                    if (id != 0) continue;
                    if (this.placeChest(x, y + i, z)) {
                        this.func_70106_y();
                        return;
                    }
                    if (this.cargo == null) continue;
                    for (ItemStack stack : this.cargo) {
                        EntityItem e = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                        this.field_70170_p.func_72838_d((Entity)e);
                    }
                    return;
                }
                if (this.cargo != null) {
                    for (ItemStack stack : this.cargo) {
                        EntityItem e = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                        this.field_70170_p.func_72838_d((Entity)e);
                    }
                }
            } else {
                this.field_70181_x = -0.25;
            }
            this.func_70091_d(0.0, this.field_70181_x, 0.0);
        }
    }

    private boolean placeChest(int x, int y, int z) {
        this.field_70170_p.func_72832_d(x, y, z, GCCoreBlocks.parachest.field_71990_ca, 0, 3);
        TileEntity te = this.field_70170_p.func_72796_p(x, y, z);
        if (te instanceof GCCoreTileEntityParachest && this.cargo != null) {
            GCCoreTileEntityParachest chest = (GCCoreTileEntityParachest)te;
            chest.chestContents = new ItemStack[this.cargo.length + 1];
            for (int i = 0; i < this.cargo.length; ++i) {
                chest.chestContents[i] = this.cargo[i];
            }
            chest.fuelTank.fill(FluidRegistry.getFluidStack((String)GalacticraftCore.FUEL.getName().toLowerCase(), (int)this.fuelLevel), true);
            return true;
        }
        this.placedChest = true;
        return true;
    }
}

